/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2016 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::fileFormats::NASTRANMeshWriter

Description
    Writes polyMesh in NASTRAN mesh format


Note


SourceFiles
    NASTRANMeshWriter.C

\*---------------------------------------------------------------------------*/

#ifndef NASTRANMeshWriter_H
#define NASTRANMeshWriter_H

#include "meshWriter.H"

#include <fstream>

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

namespace fileFormats
{

/*---------------------------------------------------------------------------*\
                 Class fileFormats::NASTRANMeshWriter Declaration
\*---------------------------------------------------------------------------*/

class NASTRANMeshWriter
:
    public meshWriter
{
    // Private Member Functions

        //- No copy construct
        NASTRANMeshWriter(const NASTRANMeshWriter&) = delete;

        //- No copy assignment
        void operator=(const NASTRANMeshWriter&) = delete;
		
		//- Write the header
		bool writeHeader(std::ofstream&) const;

        //- Write points, faces, cells
        bool writeGeometry(std::ofstream&) const;

        //- Write elements
        bool writeElements(std::ofstream&) const;
		
		//- Write property section and close the file
		bool writeDataAndClose(std::ofstream&) const;

public:

    // Static data members

        //- Write binary (default ascii)
        static bool binary;

        //- Write with compression (default false)
        static bool compress;

        //- Prefix patches with 'BND_' before writing (default true)
        static bool prefixBoundary;


    // Constructors

        //- Prepare for writing, optionally with scaling.
        //  Treats a zero or negative scale factor as unity scaling.
        NASTRANMeshWriter(const polyMesh&, const scalar scaleFactor = 1.0);


    //- Destructor
    virtual ~NASTRANMeshWriter() = default;


    // Member Functions

        // Write

            //- Write volume mesh
            virtual bool write
            (
                const fileName& meshName = fileName::null
            ) const;

};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fileFormats
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
