# for simulation
import numpy as np
from scipy.interpolate import interp1d
from scipy import integrate

def integ_func_test(theta, vec_o2rc_x, vec_o2rc_y, x, y): # wrong
    return (x-theta)+vec_o2rc_x*y -vec_o2rc_y

def integ_func_test(x, y, theta, vec_o2rc_x, vec_o2rc_y): # true
    return (x-theta)+vec_o2rc_x*y -vec_o2rc_y

def rot_M(theta):   
    # input: 
    # rotation angle
    # output: 
    # rotation matrix of theta, from local frame to world frame 
    M = np.array([[np.cos(theta), -np.sin(theta)], [np.sin(theta), np.cos(theta)]])
    return M

def d_rot_M(theta, dot_theta):   
    # input: 
    # rotation angle, diviation of the rotation angle
    # output: 
    # diviation of the rotation matrix of theta, from local frame to world frame 
    d_M = dot_theta * np.array([[-np.sin(theta), -np.cos(theta)], [np.cos(theta), -np.sin(theta)]])
    return d_M

def dd_rot_M(theta, dot_theta, ddot_theta):   
    # input: 
    # rotation angle, diviation of the rotation angle
    # output: 
    # diviation of the rotation matrix of theta, from local frame to world frame 
    dd_M = dot_theta * dot_theta * np.array([[-np.cos(theta), np.sin(theta)], [-np.sin(theta), -np.cos(theta)]]) + \
           ddot_theta * np.array([[-np.sin(theta), -np.cos(theta)], [np.cos(theta), -np.sin(theta)]])
    return dd_M

def sigmoid_adap(x):
    x = 10*x
    sig = 1 / (1 + np.exp(-x))
    sig_adap = sig *2 - 1
    return sig_adap

def integ_func_fx(x, y, theta, vec_o2rc_x, vec_o2rc_y, d_theta):
    vec_x = - np.sin(theta) * x - np.cos(theta) * y + vec_o2rc_y
    return sigmoid_adap(vec_x * d_theta)

def integ_func_fy(x, y, theta, vec_o2rc_x, vec_o2rc_y, d_theta):
    vec_y = np.cos(theta) * x - np.sin(theta) * y - vec_o2rc_x
    return sigmoid_adap(vec_y * d_theta)

def integ_func_m(x, y, theta, vec_o2rc_x, vec_o2rc_y, d_theta):
    vec_x = - np.sin(theta) * x - np.cos(theta) * y + vec_o2rc_y
    vec_x = sigmoid_adap(vec_x * d_theta)
    vec_y = np.cos(theta) * x - np.sin(theta) * y - vec_o2rc_x
    vec_y = sigmoid_adap(vec_y * d_theta)
    vec_x_O = vec_x * np.cos(theta) + vec_y * np.sin(theta)
    vec_y_O = - vec_x * np.sin(theta) + vec_y * np.cos(theta)
    integ_m = x * vec_y_O - y * vec_x_O
    return integ_m

def integ_func_fx_coulomb(x, y, theta, vec_o2rc_x, vec_o2rc_y):
    vec_x = np.cos(theta) * x - np.sin(theta) * y - vec_o2rc_x
    vec_norm = x**2 + y**2 + vec_o2rc_x**2 + vec_o2rc_y**2 - 2*vec_o2rc_x*(np.cos(theta)*x - np.sin(theta)*y) \
               - 2*vec_o2rc_y*(np.sin(theta)*x + np.cos(theta)*y)
    vec_norm = np.sqrt(vec_norm)
    return vec_x / vec_norm

def integ_func_fy_coulomb(x, y, theta, vec_o2rc_x, vec_o2rc_y):
    vec_y = np.sin(theta) * x + np.cos(theta) * y - vec_o2rc_y
    vec_norm = x**2 + y**2 + vec_o2rc_x**2 + vec_o2rc_y**2 - 2*vec_o2rc_x*(np.cos(theta)*x - np.sin(theta)*y) \
               - 2*vec_o2rc_y*(np.sin(theta)*x + np.cos(theta)*y)
    vec_norm = np.sqrt(vec_norm)
    return vec_y / vec_norm

def integ_func_m_coulomb(x, y, theta, vec_o2rc_x, vec_o2rc_y):
    vec_x = np.cos(theta) * x - np.sin(theta) * y - vec_o2rc_x
    vec_y = np.sin(theta) * x + np.cos(theta) * y - vec_o2rc_y
    xx = np.cos(theta) * x - np.sin(theta) * y
    yy = np.sin(theta) * x + np.cos(theta) * y  
    vec_norm = x**2 + y**2 + vec_o2rc_x**2 + vec_o2rc_y**2 - 2*vec_o2rc_x*(np.cos(theta)*x - np.sin(theta)*y) \
               - 2*vec_o2rc_y*(np.sin(theta)*x + np.cos(theta)*y)
    vec_norm = np.sqrt(vec_norm)
    integ_m = ( xx*vec_x + yy*vec_y ) / vec_norm
    return integ_m

def boundary_2dInteg_rect(rect):
    # input:
    # rect = np.array([[0,4],[3,-1.],[10.,3], [7, 5]])  # the sorted corner points of the contact surface 
    # tri2 = np.array([[10,10],[50,31.5],[14,50]])
    xmin = np.amin(rect[:,0])
    ind_xmin = np.argwhere(rect[:,0] == xmin).flatten().tolist()
    xmax = np.amax(rect[:,0])
    ind_xmax = np.argwhere(rect[:,0] == xmax).flatten().tolist()

    if np.size(ind_xmin) > 2 or np.size(ind_xmax) > 2 :
        print("The integrated area is not a rectangle")
        y_down = None
        y_up = None
    elif np.size(ind_xmin) == 2 or np.size(ind_xmax) == 2:
        y_up = np.amax(rect[:,1])
        y_down = np.amin(rect[:,1])
    else:
        rect = np.roll(rect,-2*ind_xmin[0])   # the most left corner point is the first one in array

        # check xmax == np.amax(rect[2,0])  # x_max is the second point
        if rect[1,1] > rect[3,1]:
            y_up = lambda x : interp1d(rect[0:3,0],rect[0:3,1])(x)
            # print('rect[0:3,0]: ', rect[0:3,0])
            rect_ = np.roll(rect,-2)   # the most left corner point is the last one in array
            y_down = lambda x : interp1d(np.flip(rect_[1:4,0]),np.flip(rect_[1:4,1]))(x)
            # print('rect[1:4,0]: ', rect_[1:4,0])
        else:
            y_down = lambda x : interp1d(rect[0:3,0],rect[0:3,1])(x)
            rect_ = np.roll(rect,-2)   # the most left corner point is the last one in array
            y_up = lambda x : interp1d(np.flip(rect_[1:4,0]),np.flip(rect_[1:4,1]))(x)
    return xmin, xmax, y_down, y_up

def print_goal_info(goal_x, goal_y, rel_goal_x, rel_goal_y, start_state, exp_nr, goal_from_launch):
    save_path = "/home/susan/Documents/mocap_experiment/data/exp_" + str(exp_nr) 
    dict_info = {}
    dict_info["goal_x"] = goal_x
    dict_info["goal_y"] = goal_y
    dict_info["rel_goal_x"] = rel_goal_x
    dict_info["rel_goal_y"] = rel_goal_y
    dict_info["start_state_x"] = start_state[5]
    dict_info["start_state_y"] = start_state[6]
    dict_info["goal_from_launch"] = goal_from_launch

    print("dict_info", dict_info)

    with open(save_path + "/goal_info_trajectory_" + str(exp_nr) + ".txt", 'w') as f:
        for key, value in dict_info.items():
            f.write(str(key) + ' >>> '+ str(value) + '\n\n')

def fullState2generalState(full_state, pr, index):
    # full_state = [robot_pos_w_x, robot_pos_w_y, theta_r, v_r, d_theta_r, obj_pos_w_x, obj_pos_w_y, theta_o, vx_o, vy_o, d_theta_o]
    obj_pos_w_x = full_state[index.obj_pos_w_x] 
    obj_pos_w_y = full_state[index.obj_pos_w_y]
    theta_o = full_state[index.theta_o]
    vx_o = full_state[index.vx_o]
    vy_o = full_state[index.vy_o]
    d_theta_o = full_state[index.d_theta_o]
    robot_pos_w_x = full_state[index.robot_pos_w_x]
    robot_pos_w_y = full_state[index.robot_pos_w_y]
    theta_r = full_state[index.theta_r]
    v_r = full_state[index.v_r]
    vx_r = np.cos(theta_r) * v_r
    vy_r = np.sin(theta_r) * v_r
    d_theta_r = full_state[index.d_theta_r]

    d = - np.sin(theta_o) * (robot_pos_w_x -obj_pos_w_x) + np.cos(theta_o) * (robot_pos_w_y-obj_pos_w_y)
    phi = theta_o - theta_r
    d_d = - np.cos(theta_o) *d_theta_o* (robot_pos_w_x -obj_pos_w_x) - np.sin(theta_o) * (vx_r -vx_o) \
            -np.sin(theta_o) *d_theta_o* (robot_pos_w_y-obj_pos_w_y) + np.cos(theta_o) * (vy_r-vy_o)
    d_phi = d_theta_o - d_theta_r

    generalized_state = np.array([robot_pos_w_x, robot_pos_w_y, theta_r, v_r, d_theta_r, phi, d, d_phi, d_d])
    return generalized_state

def generalState2fullState(generalized_state, pr, index):
    # generalized_state = [x_r, y_r, theta_r, v_r, d_theta_r, fai, d, d_fai, d_d]
    x_r =generalized_state[0]
    y_r =generalized_state[1]
    theta_r =generalized_state[2]
    v_r =generalized_state[3]
    d_theta_r =generalized_state[4]
    phi =generalized_state[5]
    d =generalized_state[6]
    d_fai =generalized_state[7]
    d_d =generalized_state[8]   
    d_x_r = np.cos(theta_r)*v_r
    d_y_r = np.sin(theta_r)*v_r

    # parameters
    r_r = pr.rob_size  
    [W_o, L_o] = pr.obj_size

    # position of the object in the world frame
    W_p_o =  np.array([x_r + d*np.sin(phi + theta_r) + np.cos(phi + theta_r)*(W_o/2 + r_r),\
                    y_r - d*np.cos(phi + theta_r) + np.sin(phi + theta_r)*(W_o/2 + r_r)])
    # velocity of the object in the world frame
    d_W_p_o = np.array([d_x_r + d_d*np.sin(phi + theta_r) + d*np.cos(phi + theta_r)*(d_fai + d_theta_r) - np.sin(phi + theta_r)*(d_fai + d_theta_r)*(W_o/2 + r_r),\
                        d_y_r - d_d*np.cos(phi + theta_r) + d*np.sin(phi + theta_r)*(d_fai + d_theta_r) + np.cos(phi + theta_r)*(d_fai + d_theta_r)*(W_o/2 + r_r) ])
    theta_o = theta_r + phi
    d_theta_o = d_theta_r + d_fai

    pre_robot_state =generalized_state[0:5]
    pre_object_state = np.array([W_p_o[0], W_p_o[1], theta_o, d_W_p_o[0], d_W_p_o[1], d_theta_o])

    full_state = np.concatenate([pre_robot_state, pre_object_state], 0)
    return full_state


if __name__ == "__main__":
    rect = np.array([[3,-1.],[10.,3],[7, 5],[0,4]])
    xmin, xmax, y_down, y_up = boundary_2dInteg_rect(rect)
    xr = 1
    yr = 2
    px = 0.1    # N_obj/A
    m = integrate.dblquad(integ_func_fx, xmin, xmax, y_down, y_up, args=(xr,yr,px))
