#!/usr/bin/env python

import rospy
from controllers.PID.PID import PID
import numpy as np
from scipy.spatial.transform import Rotation as R
from geometry_msgs.msg import PoseStamped
from geometry_msgs.msg import PoseWithCovarianceStamped
from geometry_msgs.msg import Twist
from visualization_msgs.msg import Marker
from geometry_msgs.msg import Point
from controllers.PID.DynamicPush import *


def distPoints(x1, y1, x2, y2):
    return np.sqrt((x1-x2)**2 + (y1-y2)**2)

def pointsOnLineWDistPoint(x1, y1, x2, y2, d):
    m = (y2 - y1) / (x2 - x1)
    b = y1 - m * x1

    p1 = x1 + d / np.sqrt(1 + m**2)
    p2 = m * p1 + b 
    p3 = x1 - d / np.sqrt(1 + m**2)
    p4 = m * p3 + b

    return p1, p2, p3, p4

def rotationDifference(angle, theta_robot):
    err_th = angle - theta_robot

    if (err_th > np.pi):
        err_th = - (2 * np.pi - err_th)
    if (err_th < -np.pi):
        err_th = 2 * np.pi + err_th

    return err_th

def pointOnLineWDistPointOuter(x1, y1, x2, y2, d):
    p1, p2, p3, p4 = pointsOnLineWDistPoint(x1, y1, x2, y2, d)

    if distPoints(p1, p2, x2, y2) > distPoints(p3, p4, x2, y2):
        p_0 = p1
        p_1 = p2
    else:
        p_0 = p3
        p_1 = p4

    return p_0, p_1

def getVectorAngle(x, y):
    th = np.arctan2(y,x)

    if np.isnan(th) is True:
        th=0
    return th

def rotatePoint(point_x, point_y, angle):

    newX = point_x * np.cos(angle) - point_y * np.sin(angle)
    newY = point_x * np.sin(angle) + point_y * np.cos(angle)

    return newX, newY

def angle3Points(x1, y1, x2, y2, x3, y3):
    a12 = np.arctan2(y1-y2, x1-x2)
    if np.isnan(a12) is True:
        a12=0

    a32 = np.arctan2(y3-y2, x3-x2)
    if np.isnan(a32) is True:
        a32=0

    alfa = a32-a12
    if alfa < (-2*np.pi):
        alfa = alfa + 2*np.pi
    elif alfa> 2*np.pi:
        alfa = alfa - 2* np.pi 
    else:
        pass
    return alfa

def getNullTwist():
    cmd = Twist()
    cmd.linear.x = 0.0
    cmd.linear.y = 0.0
    cmd.linear.z = 0.0
    cmd.angular.x = 0.0
    cmd.angular.y = 0.0
    cmd.angular.z = 0.0

    return cmd

def getGaussianVal(x, sigma, mu):
    r = np.exp(- (x-mu)**2 / (2* sigma**2))
    if np.isnan(r) is True:
        r = 1.0
    return r



