import numpy as np 
from dataclasses import dataclass 


# General problem setup
@dataclass
class Problem:
    # workspace 
    # sim 
    ws_x = [-2.0, 2.2]              # m 
    ws_y = [-2.0, 2.40]              # m
    # real experiment
    # ws_x = [-3.2, 3.2]            # m 
    # ws_y = [-1.2, 1.2]            # m

    # robot control bound
    robot_maxAcc = 0.8              # m/s^2
    robot_minAcc = -25
    robot_maxOmegaAcc = 0.8        # rad/s^2
    robot_minOmegaAcc = -25
    max_F_push = 100.0              # N

    # robot/object size, start and goal
    rob_size = 0.27                 # m (radius of the cylinder)
    obj_size = [0.386, 0.585]          # m (W*L) on the x, y direction with regard to the object frame, height 0.278 m 
    # obj_size = [0.32, 1.2]        # m (W*L) on the x, y direction with regard to the object frame
    obj_mass = 2.9     # kg
    obj_I_or = 1/12 * obj_mass * \
                    (obj_size[0]**2 + obj_size[1]**2)   # moment of inertia (rotation center is 
                                                        # the center of the object) (for rectangle)
    mu_g = 0.28                     # friction coefficient of the ground-object contact surface
    mu_p = 0.0                     # friction coefficient of the robot-object contact surface
    grav_acc = 9.8                 # gravity acceleration

    # bound
    robot_minVel = 0.01
    robot_maxVel = 0.30            # m/s
    robot_maxOmega = 0.4           # rad/s 
    d_max = obj_size[1]/2
    phi_max = np.pi
    d_maxVel = 0.3
    phi_maxVel = 0.4

    # system target
    obj_pos_goal = [0., 1.5]        # m
    obj_theta_goal = [np.deg2rad(0.0)]# rad
    
    # General planning settings
    dt = 0.1                        # sampling time, s
    N = 30                          # horizon length
    T = N*dt                        # horizon time 
    nx = 9                          # state dimension 
    nx_dae = 11
    nu = 2                          # control dimension
    nz = 0                          # dimension of the algebraic variables
    nh = 0                          # number of inequality constraint functions
    nparam = 0                      # parameter dimension
    
    # MPC cost terms weights, can be real time param
    w_navi_error = 10.
    w_d_error = 0.
    w_phi_error = 0.

    w_px_error = 1.0
    w_py_error = 1.0
    w_theta_error = 0.0
    w_vel = 0.1
    w_omega = 0.1
    w_acc = 0.01
    w_omega_acc = 0.01
    w_f_push = 0.01

    # Feedback control gains
    k_rho = 1.0
    k_alpha = 8.0
    k_phi = -1.5
    

# General vector index
@dataclass
class Index:
    # control vector, u = [acc, omega_acc]
    u_acc_r = np.s_[0]              # 0
    u_omega_acc_r = np.s_[1]        # 1

    # state vector, q = [x_r, y_r, theta_r, v_r, d_theta_r, fai, d, d_fai, d_d]
    rob_state = np.s_[0:5]          # 0, 1, 2, 3, 4
    obj_state = np.s_[5:9]          # 5, 6, 7, 8 

    x_r = np.s_[0]                  # 0
    y_r = np.s_[1]                  # 1
    theta_r = np.s_[2]              # 2
    v_r = np.s_[3]                  # 3
    d_theta_r = np.s_[4]            # 4
    phi = np.s_[5]                  # 5
    d = np.s_[6]                    # 6
    d_phi = np.s_[7]                # 7
    d_d = np.s_[8]                  # 8

    # state vector for dae, x = [robot_pos_w_x, robot_pos_w_y, theta_r, v_r, d_theta_r, obj_pos_w_x, obj_pos_w_y, theta_o, vx_o, vy_o, d_theta_o]
    robot_pos_w_x = np.s_[0]        # 0
    robot_pos_w_y = np.s_[1]        # 1
    theta_r = np.s_[2]              # 2
    v_r = np.s_[3]                  # 3
    d_theta_r = np.s_[4]            # 4
    obj_pos_w_x = np.s_[5]          # 5
    obj_pos_w_y = np.s_[6]          # 6
    theta_o = np.s_[7]              # 7
    vx_o = np.s_[8]                 # 8
    vy_o = np.s_[9]                 # 9
    d_theta_o = np.s_[10]           # 10


    # param vector, customized for different formulation
    p_goal_pos_x = np.s_[0]
    p_goal_pos_y = np.s_[1]
    p_goal_theta = np.s_[2]
    p_initial_state = np.s_[3:12]


@dataclass
class Mpc_model:
    # MPC
    dt = 0             # sampling time
    N  = 0             # horizon length
    nx = 0             # number of equality constraints, x
    nu = 0             # number of control inputs, u
    ns = 0             # number of slacks, s
    np = 0             # number of real-time params on each stage, 
    # bound 
    xl = []
    xu = []
    ul = []
    uu = []
    sl = []
    su = []