import os
import sys
import casadi as cd
import numpy as np
from scipy import integrate
from acados_template import AcadosOcp, AcadosOcpSolver, AcadosModel

from general_problem_setup import Problem, Index
import utils.utils as utils

def cylinder_pushing_dynamics(x, u, p):
    params = Problem()
    # state = [x_r, y_r, theta_r, v_r, d_theta_r, phi, d, d_phi, d_d]
    # q = [x_r, y_r, theta_r, phi, d]
    x_r = x[0]
    y_r = x[1]
    theta_r = x[2]
    v_r = x[3]
    d_theta_r = x[4]
    phi = x[5]
    d = x[6]
    d_phi = x[7]
    d_d = x[8] 

    # control 
    acc_r = u[0]                  # 0
    acc_theta_r = u[1]            # 1

    # parameters
    r_r = params.rob_size  
    [W_o, L_o] = params.obj_size
    m_o = params.obj_mass
    I_o = params.obj_I_or
    mu_g = params.mu_g
    mu_p = params.mu_p
    grav_acc = params.grav_acc

    # for the robot
    d_x_r = np.cos(theta_r)*v_r
    d_y_r = np.sin(theta_r)*v_r

    # for the object
    theta_o = theta_r + phi
    d_theta_o = d_theta_r + d_phi

    cos_theta_o = np.cos(theta_o)
    sin_theta_o = np.sin(theta_o)
    sin_phi = np.sin(phi)
    cos_phi = np.cos(phi)
    
    # position of the object in Robot frame
    R_p_o =  np.array([ d*sin_phi + cos_phi*(W_o/2 + r_r),\
                       -d*cos_phi + sin_phi*(W_o/2 + r_r)])
    # velocity of the object in Robot frame
    d_R_p_o = np.array([d_d*sin_phi - sin_phi*(W_o/2 + r_r)*d_phi +d*cos_phi*d_phi,\
                        -d_d*cos_phi + cos_phi*(W_o/2 + r_r)*d_phi +d*sin_phi*d_phi])
    # velocity of the object in World frame
    d_W_p_o = np.array([d_x_r + d_d*sin_theta_o + d*cos_theta_o*(d_phi + d_theta_r) - sin_theta_o*(d_phi + d_theta_r)*(W_o/2 + r_r),\
                        d_y_r - d_d*cos_theta_o + d*sin_theta_o*(d_phi + d_theta_r) + cos_theta_o*(d_phi + d_theta_r)*(W_o/2 + r_r) ])
    d_x_o = d_W_p_o[0]
    d_y_o = d_W_p_o[1]

    ## get Friction force
    # we have the push force and the friction force between the ground and the object as the
    # external force in domain x
    # calculate the friction force and moment
    # v1
    inte_f = np.array([0.0, 0.0])
    inte_m = 0.0
    pos_corner_o = np.array([[W_o/2.0, L_o/2.0], \
                            [W_o/2.0, L_o/-2.0], \
                            [W_o/-2.0, L_o/-2.0], \
                            [W_o/-2.0, L_o/2.0]])   # position of the corners in the object frame
    # if d_theta_o == 0:
    #     F_fg = inte_f
    #     F_fg[0] = - mu_g * m_o * grav_acc * utils.sigmoid_adap(d_x_o) 
    #     F_fg[1] = - mu_g * m_o * grav_acc * utils.sigmoid_adap(d_y_o) 
    #     M_fg = 0.0 # under uniform mass distribution
    # else:
    a = d_x_o/d_theta_o
    b = d_y_o/d_theta_o
    for i in range(4):  # for the object with four legs
        O_x = pos_corner_o[i, 0]
        O_y = pos_corner_o[i, 1]
        sig_v_O_x = np.array([utils.sigmoid_adap(-d_theta_o*(O_y*cos_theta_o + O_x*sin_theta_o - a)), \
                        utils.sigmoid_adap(d_theta_o*(O_x*cos_theta_o - O_y*sin_theta_o + b))])
        inte_f = inte_f + sig_v_O_x

        O_sig_v_O_x = [sig_v_O_x[0] * cos_theta_o + sig_v_O_x[1] * sin_theta_o, \
                    - sig_v_O_x[0] * sin_theta_o + sig_v_O_x[1] * cos_theta_o]
        inte_m = inte_m + (O_x * O_sig_v_O_x[1] - O_y * O_sig_v_O_x[0])
    F_fg = -mu_g * m_o * grav_acc / 4 * np.array([inte_f[0], inte_f[1]])
    M_fg = -mu_g* m_o * grav_acc / 4 * inte_m 
        
    # v2
    # lam = 1.1491 # RECTENGULAR + 0.5*0.8
    # if d_x_o*d_x_o + d_y_o*d_y_o + (lam*d_theta_o)*(lam*d_theta_o) ==0:
    #     F = np.array([0., 0., 0., 0., 0., 0.0])
    # else:
    #     F_fg = -mu_g * m_o * grav_acc * np.array([d_x_o,d_y_o,lam*d_theta_o])/ \
    #         np.sqrt(d_x_o*d_x_o + d_y_o*d_y_o + (lam*d_theta_o)*(lam*d_theta_o))

    #     # the friction force between the ground and the object expressed in the
    #     # object frame
    #     # O_F_fg = cd.dot(utils.rot_M(-theta_o),  F_fg.T)
    #     O_F_fg_x = F_fg[0]*cos_theta_o + F_fg[1]*sin_theta_o
    #     O_F_fg_y = F_fg[1]*cos_theta_o - F_fg[0]*sin_theta_o
    #     F = np.array([0, 0, 0, O_F_fg_x, O_F_fg_y, F_fg[2]])   

    # the friction force between the ground and the object expressed in the
    # robot frame
    R_F_fg = np.dot(utils.rot_M(-theta_r),  F_fg.T)

    F = np.array([R_F_fg[0], R_F_fg[1], M_fg]) \
        - 2*m_o*np.array([-d_theta_r*d_R_p_o[1], d_theta_r*d_R_p_o[0], 0.]) \
        + m_o*np.array([d_theta_r*d_theta_r*R_p_o[0], d_theta_r*d_theta_r*R_p_o[1], 0.]) \
        - m_o*np.array([-acc_theta_r*R_p_o[1], acc_theta_r*R_p_o[0], 0.]) \
        - m_o*np.array([acc_r, 0., 0.]) 

    ## get T
    T_1_1 = d*cos_phi - sin_phi*(W_o/2 + r_r); 
    T_1_2 = sin_phi;        

    T_2_1 = d*sin_phi + cos_phi*(W_o/2 + r_r); 
    T_2_2 = - cos_phi

    Tij = np.array([[T_1_1, T_1_2],\
                    [T_2_1, T_2_2],\
                    [1.,     0.]])

    ## get M
    M = np.diag([m_o, m_o, I_o])

    ## get g
    g_4 = -(W_o/2 + r_r)*cos_phi*d_phi*d_phi + d_d*cos_phi*d_phi - d*sin_phi*d_phi*d_phi + d_d*cos_phi*d_phi
    g_5 = -(W_o/2 + r_r)*sin_phi*d_phi*d_phi + d_d*sin_phi*d_phi + d*cos_phi*d_phi*d_phi + d_d*sin_phi*d_phi

    g = np.array([g_4,g_5,0]).T
    
    ## get Q
    # # The force exerted by the robot to the object
    # F_ro = m_r * np.dot(utils.rot_M(-phi),  np.array([dd_x_r, dd_y_r]).T)   # doubted
    # # 1. the push force between the robot and the object
    # F_p_ro = F_ro[0]
    # # 2. the friction force between the robot and the object 
    # F_f_ro = mu_p * F_p_ro * utils.sigmoid_adap(d_d)

    # Q = np.array([0, 0, 0, 0, F_f_ro])
    Q = np.array([0., 0.])

    # calculate the unknowns  
    bar_Q = Q + np.dot(Tij.T, (F-np.dot(M, g)))

    dd_q = np.dot(np.linalg.inv(Tij.T.dot(M).dot(Tij)), bar_Q)

    # state = [x_r, y_r, theta_r, v_r, d_theta_r, phi, d, d_phi, d_d]
    d_state = np.array([d_x_r, \
                            d_y_r, \
                            d_theta_r, \
                            acc_r, \
                            acc_theta_r, \
                            d_phi, \
                            d_d, \
                            dd_q[0], \
                            dd_q[1]
                            ])

    return d_state
