#!/usr/bin/env python
import numpy as np
import rospy
import gym
import myenv
from timeit import default_timer as timer

from geometry_msgs.msg import TwistStamped, Twist, Pose

# from MPPI_vel import MPPI
from State_Estimator import State_Estimator
import sys
from controllers.mpc.free_push_mpc_controller_casadi import Free_Push_mpc_controller
from general_problem_setup import Problem, Index
from utils.utils import print_goal_info, fullState2generalState

import sys
from pathlib import Path

FILE_THIS = Path(__file__).resolve()
PARENT = FILE_THIS.parent
GPARENT = FILE_THIS.parents[1]

class tiago_Control:
    def __init__(self):
        self.pr = Problem()
        self.index = Index()

        # ros publisher for control
        self.pub_tiago_control = rospy.Publisher("/nav_vel", Twist, queue_size=1) 

        # Initializing robot mpc casadi
        self.mpc_controller = Free_Push_mpc_controller()
        recompile = True
        solver_build_name = 'free_push_mpc_controller_casadi'    
        self.mpc_controller.generate_solver(recompile, solver_build_name)

        self.obj_goal = self.pr.obj_pos_goal

    def get_null_twist(self):
        cmd = Twist()
        cmd.linear.x = 0.0
        cmd.linear.y = 0.0
        cmd.linear.z = 0.0
        cmd.angular.x = 0.0
        cmd.angular.y = 0.0
        cmd.angular.z = 0.0
        return cmd

    def pub_control_action(self, robot_control_current):
        cmd = self.get_null_twist()
        cmd.linear.x = robot_control_current[0]
        cmd.angular.z = robot_control_current[1]
        self.pub_tiago_control.publish(cmd)


def run_control():
    print("Starting Control...")

    # Initialize a ros node
    rospy.init_node('mpc_control', anonymous=False)

    # Create a tiago robot object
    tiago = tiago_Control()

    # visualization
    vis_env = gym.make('cylinder_robot_pushing_recBox-v3')
    vis_env.init_path_candidates_both(1)

    # Create state estimation object 
    # mode = rospy.get_param('mode') # simulation or mocap
    mode = "mocap"
    state_estimator = State_Estimator(mode)
    # Get state from the state estimator
    full_state = state_estimator.get_state()
    system_state_current = fullState2generalState(full_state, tiago.pr, tiago.index)
    # show current state
    vis_env.set_state(full_state[0:5], full_state[5:11])
    # show current goal
    vis_env.init_goal_pos(tiago.obj_goal)
    vis_env.render()

    # Specify the control node frequency
    hz = 10
    rate = rospy.Rate(hz)
    rospy.sleep(0.5)

    while not rospy.is_shutdown():
        # Get state from the state estimator
        full_state = state_estimator.get_state()
        system_state_current = fullState2generalState(full_state, tiago.pr, tiago.index)

        # update visualization
        vis_env.set_state(full_state[0:5], full_state[5:11])

        # Set state to the controller
        tiago.mpc_controller.set_system_state_current(system_state_current)
        # Set goal position
        tiago.mpc_controller.set_obj_pos_theta_goal(tiago.obj_goal, 0)
        # run mpc
        start = timer()
        tiago.mpc_controller.run_mpc()
        end = timer()
        # print("Control Processing time: " + str(end - start))
        # retrieve info
        mpc_feasible = tiago.mpc_controller.mpc_feasible
        print(mpc_feasible)
        action = tiago.mpc_controller.robot_control_current
        # pub control signal
        if np.size(tiago.mpc_controller.stop) < 4:
            tiago.pub_control_action(action)
        print("Vel action: ", action)

         # visualization of the planned trajectory
        if not mpc_feasible:
            tiago.mpc_controller.system_state_plan[:, 0, 5] = np.ones(tiago.pr.N+1)* full_state[5]
            tiago.mpc_controller.system_state_plan[:, 0, 6] = np.ones(tiago.pr.N+1)* full_state[6]
        vis_env.show_paths_candidates_both(tiago.mpc_controller.system_state_plan)
        vis_env.render()
        rate.sleep()

if __name__ == '__main__':
    rospy.sleep(1.0)

    run_control()
