function [x,t] = sniptool(x,fs,tstart,tend)
                
if and(iscell(x),ismatrix(x)) == 1
    for j = 1:size(x,2)
        % define beginning conditions
        totalRows = [];
        ls = length(tstart{j});
        le = length(tend{j});
        if ls ~= le
            disp('start time and end time do not have the same vector length') 
        elseif isempty(and(tstart{j},tend{j})) == 1
            disp('no sections to cut out')  
        elseif tstart{j}(1) == 0 & tend{j}(1) == 0
            disp('no sections to cut out')
        end
        for m = 1:ls
            tend{j}(m) = min(length(x{1,j})/fs(j),tend{j}(m));
            rows2remove = (fs(j)*tstart{j}(m)+1:fs(j)*tend{j}(m));
            totalRows = [totalRows rows2remove];
        end
        x{1,j}(totalRows,:) = [];
    end

elseif iscell(x) == 0 && ismatrix(x) == 1
    totalRows = [];
    ls = length(tstart);
    le = length(tend);
    if ls ~= le
        disp('start time and end time do not have the same vector length') 
    elseif tstart == 0 & tend == 0
        disp('no sections to cut out')    
    end
    for m = 1:ls
        tend(m) = min(length(x)/fs,tend(m));
        rows2remove = (fs*tstart(m)+1:fs*tend(m));
        totalRows = [totalRows rows2remove];
    end
    x(totalRows,:) = [];
    t = linspace(0,(length(x)-1)/fs,length(x));
else
    disp('Check if the input is in the right format')
end

end
      

