function [x,t,fs] = preprocessing(datafiles,fileNames)

% input for pre-processing (sniptool, outlier removal and detrend)
%============================//============================
signals = ["vooras_rechts"];   % Default choice
% signals = ["vooras_links"];
% signals = ["vooras_rechts"];
% signals = ["torsie_voor"];
% signals = ["torsie_achter"];
% signals = ["achteras_links"];
% signals = ["achteras_rechts"];
% signals = ["chassisbalk_links"];
%signals = ["Distance"];
g = 1; % set g = 1 if strain is used. set g = 9.81 if acceleration data is used
Measurement = 'Strain';
unit = [char(181),'m/m']; % strain
Amp_time = [Measurement ' [',unit,']'];
Amp_freq = ['Energy [(',unit,')^{2}/Hz]'];

% inputdata belonging to 30569
tstart{1} = [0];                tend{1} = [1];    % Feld und Wald
tstart{2} = [0];                tend{2} = [1]; % Millbrook Offroad
tstart{3} = [0];                tend{3} = [1];
tstart{4} = [0];                tend{4} = [1];
tstart{5} = [0];                tend{5} = [1];
tstart{6} = [0];                tend{6} = [1];
tstart{7} = [0];                tend{7} = [1];
tstart{8} = [0];                tend{8} = [1];    % Feld und Wald
tstart{9} = [0];                tend{9} = [1]; % Millbrook Offroad
tstart{10} = [0];                tend{10} = [1];
tstart{11} = [0];                tend{11} = [1];
tstart{12} = [0];                tend{12} = [1];
tstart{13} = [0];                tend{13} = [1];
tstart{14} = [0];                tend{14} = [1];
tstart{15} = [0];                tend{15} = [1];
tstart{16} = [0];                tend{16} = [1];
tstart{17} = [0];                tend{17} = [1];

% Threshold outlier removal 30614
thl = [-1000 -1000 -1000 -1000 -1000 -1000]; thh = [1000 1000 1000 1000 1000 1000];

%% PROCESSING DATA
% create zeros matrices and cell arrays to increase computational speed
fs = zeros(1,size(datafiles,2));
data = cell(1,size(datafiles,2));
t = cell(1,size(datafiles,2));
tv = cell(2,size(datafiles,2));
pxx = cell(1,size(datafiles,2));
f = cell(1,size(datafiles,2));
df = zeros(1,size(datafiles,2));

% load data
%Select which data is used

for k = 1:size(datafiles,2)
    raw{k} = load(datafiles(k));
    
    fs(k) = raw{k}.Sample_rate;
    fs_vel(k) = 20;
    %length(raw{k}.Data1_time_Velocity_Z)/raw{k}.Data1_time_Velocity_Z(end);
    %raw{k}.SR_Velocity;
    
    % create data cell array with signal
    for j = 1:size(signals,2)
        % acceleration vector divided to go from m/s^2 to g.
        data{1,k}(:,j) = double(raw{1,k}.(sprintf('Data1_%s',signals(j))))/g;
    end
    
end

% snip unwanted entries
fprintf('Start pre-processing signal \n');
% is the data is presented in an array or matrix the notation should be if
% the form of 'tstart = [a b]; tend = [c d]'
% If the data is presented in a cell format the data should be presented in
% the form of a cell array i.e. 'tstart{i} = [a b]; tend{i} = [c d]'

% cut out unwanted sections
[x] = sniptool(data,fs,tstart,tend);
% B           = 200; % 5 times the cutoff frequency of 40Hz for resampling
B           = 500; % 12 times the cutoff frequency of 40Hz for resampling
f_resample  = fs/B;% resample factor

% Resample to reduce data size without affecting measurements
for j=1:size(datafiles,2)
    x{1,j}=resample(x{1,j},1,f_resample(j));
    fs(j)=fs(j)/f_resample(j);
end

%% Section for filtering and plotting

for j = 1:size(datafiles,2)  
   
    % detrend the data with a high pass filter and afterwards detrend the
    % data with an offset
    % create a high pass filter to remove the noise from lower frequencies
    filterorder = 8;
    cutoff = 1; %Hz
    hp = designfilt('highpassiir','FilterOrder',filterorder,...
    'HalfPowerFrequency',cutoff*0.9,'SampleRate',fs(j));
    x{1,j} = filtfilt(hp,x{1,j});
  
    % detrend signal by removing the offset in the data
    x{1,j} = x{1,j} - mean(x{1,j},1); 
     
    % outlier removal with threshold
    for i=1:size(signals,2)
        idx{i,j} = find(x{1,j}(:,i) > thh(i) | x{1,j}(:,i) < thl(i));
    end
    
    x{1,j}(cat(1,idx{:,j}),:) = [];
    
    % set time vector
    %t{1,j} = linspace(0,(length(data{1,j})-1)/fs(j),length(data{1,j}))';
    t{1,j} = linspace(0,(length(x{1,j})-1)/fs(j),length(x{1,j}))';
    
end