function [S, N] = limiting_RFM(X, fs)

% Rainflow counting original time signal and make from-to RFM
[c,hist,rmr,rmm,idx] = rainflow(X,fs);

% Define peaks and valleys in stead of mean and range
T = array2table(c,'VariableNames',{'Count','Range','Mean','Start','End'});
A = table2array(T);
PKS = A(:,3)+ A(:,2);
VLS = A(:,3)- A(:,2);
     
% RFM in from-to values
figure(1); fig=1;
h=histogram2(PKS,VLS,1000);
rfm             =   h.Values;
FromBinEdges    =   h.XBinEdges + 0.5* h.BinWidth(1);
ToBinEdges      =   h.YBinEdges + 0.5* h.BinWidth(2);
FromBinCenter   =   FromBinEdges(1:end-1);
ToBinCenter     =   ToBinEdges(1:end-1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Create isolines and plot from-to diagram
Nc  =   sum(sum(rfm));                  %Total number of rainflow cycles
f = [0.1 0.3 0.5 0.7 0.9 0.99 0.999];   %Fraction you want isolines to be plotted (10% to 99.9%)
Nc_f = Nc*f;                            %Desired number of RFM cycles to fall within isoline

for i = 1:length(f);                                   % Find for each isoline the correct level
    X_pos = logspace(-1,log10(max(max(rfm))),1000);     % Possible levels
    for j=1:length(X_pos)                              %Check  each level for desired number of RFM cycles
        N_des = sum(sum(rfm(rfm>X_pos(j))));           % Calculate number of RFM cycles are 
        if N_des <= Nc_f(i)                            % If desired number of cycles is low enough save level
            N_def(i) = X_pos(j);
            break
        end
    end
end

% figure(3)
% contourf(ToBinCenter,FromBinCenter,rfm,[N_def])
% axis([-300 200 -150 300])
% set(h,'LineStyle','none')
close(1)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Method to get from-to RFM with equal bins
Xedges      = floor(min(PKS)):0.5:ceil(max(PKS));
Yedges      = floor(min(VLS)):0.5:ceil(max(VLS));
[RFM]       = histcounts2(PKS,VLS,Xedges,Yedges);
Xcentre     =   Xedges + 0.5* mean(diff(Xedges));
Ycentre     =   Yedges + 0.5* mean(diff(Yedges));
% Xcentre     =   Xedges +  mean(diff(Xedges));
% Ycentre     =   Yedges +  mean(diff(Yedges));
Xcentre     =   Xcentre(1:end-1);
Ycentre     =   Ycentre(1:end-1);
%[E]      = histcounts2(PKS,VLS,Xedges,Yedges,'Normalization','probability');



Yedges2=Yedges(Yedges<0);
for k=1:length(Yedges2);
    
    % Use y-range with same stepsize as original RFM and calculate
    % upcrossing spectrum for valleys
    id_neg = [VLS] < Yedges2(k);
    n_neg(k) = sum(id_neg);
end

Xedges2=Xedges(Xedges>=0);
for k=1:length(Xedges2);
    
    %For double sided upcrossing spectrum
    id_pos = [PKS] >= Xedges2(k);
    n_pos(k) = sum(id_pos);
end
r = min([floor(min(PKS));floor(min(VLS))]):0.5:max([ceil(max(PKS));ceil(max(VLS))]);
n = [n_neg n_pos];
n1=n;
n1(n1==0)=eps;

% figure(70)
% plot(Xedges2,n_pos,'r-',Yedges2,n_neg,'b-',r,n1,'k-')
% set(gcf,'color','w');
% set(gca, 'YScale', 'log')
% axis([-400 400 1e-2 1e6])
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%Oude methode hieronder
%In threshold increments of 0.1 find upcrossing spectrum
% range_y = 0:mean(diff(ToBinCenter)):450;  
% for k=1:length(range_y);
%     
%     % Use y-range with same stepsize as original RFM and calculate
%     % upcrossing spectrum for valleys
%     id_neg = VLS < -range_y(k);
%     n_neg(k) = sum(id_neg);
% end
% 
% range_x = 0:mean(diff(FromBinCenter)):450;  
% for k=1:length(range_x);
%     
%     %For double sided upcrossing spectrum
%     id_pos = PKS >= range_x(k);
%     n_pos(k) = sum(id_pos);
% end
% 
% r = [flip(-range_y) range_x(2:end)];
% n = [flip(n_neg) n_pos(2:end)];
% n1=n;
% n1(n1==0)=eps;

% figure(70)
% plot(r,n)
% set(gcf,'color','w');
% set(gca, 'YScale', 'log')
% axis([-400 400 1e-2 1e6])
% legend('double','single')


%%%%%%%%%%%%%%%% Find threshold based on rule of thumb
n_pos(1:120)=0;  %Remove non damaging content
n_neg(1:120)=0;  %Remove non damaging content

%%%%%%%%%% Find threshold based on fractions
% threshold_pos    = find((cumsum(n_pos)/sum(n_pos))>frac(1));      %Find position of values that contain lower 1% exceedances
% threshold_neg    = find((cumsum(n_neg)/sum(n_neg))>frac(2));      %Find position of values that contain lower 1% exceedances
% % threshold_pos     = find(0.05*range(sum(n_pos_RFM~=0))>r);
% % threshold2_neg     = find(-0.05*range(sum(n_neg_RFM~=0))>r);
% 
% % u1          = range(threshold1(end));
% u_pos      = range_x(threshold_pos(1));               %first  position  is correct threshold
% u_neg      = range_y(threshold_neg(1));              %first  position  is correct threshold
% n_t_pos             = n_pos(threshold_pos(1));                  %Find number of upcrossing at threshold for extrapolation 
% n_t_neg             = n_neg(threshold_neg(1));

%%%%%%%%%% Find threshold from rule of thumb (5% from max upcrossing value)
u_max               = 0.05*max(n);                      % 5 percent of max number of upcrossings
threshold_neg       = sum(cumsum(n)<0.05*max(n));          % position of threshold
threshold_pos       = sum(cumsum(n)<sum(n)-0.05*max(n));   % position of threshold
u_pos               = r(threshold_pos);                    % threshold
u_neg               = abs(r(threshold_neg));               % threshold
n_t_pos             = n(threshold_pos);                    %Find number of upcrossing at threshold for extrapolation
n_t_neg             = n(threshold_neg);                    %Find number of upcrossing at threshold for extrapolation
% 

id_t_pos    =   find(r>u_pos);             %find values above pos threshold
id_t_neg    =   find(r<-u_neg);             %find values below neg threshold
dn_pos=n(find(r>u_pos));                                    %only use cycle counts where range is above pos threshold
dn_neg=n(find(r<-u_neg));                                    %only use cycle counts where range is below neg threshold
x_pos=[]; x_neg=[];


%%%%%%%%%%%%%%%% Construct array of observed cycle counts
for k=1:length(dn_pos)
    x_p = repmat(r(id_t_pos(k)),[ceil(abs(dn_pos(k))) 1])-u_pos;
    x_pos=[x_pos;x_p];
end
for k=1:length(dn_neg)
    x_n = repmat(abs(r(id_t_neg(k))),[ceil(abs(dn_neg(k))) 1])-u_neg;
    x_neg=[x_neg;x_n];
end

%%%%%%%%%%%%%%%% Parametric fit on exceedances
[parp,~]        = gpfit(x_pos)             %Fit to dataset positive
[parn,~]        = gpfit(sort(abs(x_neg)))             %Fit to dataset positive

range_ext_pos        = [u_pos:mean(diff(r)):500];      % New range for extrapolation
range_ext_neg        = [-500:mean(diff(r)):-u_neg];      % New range for extrapolation
% range_ext_pos        = r(id_t_pos);
% range_ext_neg        = r(id_t_neg);
% range_ext_pos        = [u_pos:1:ceil(max(r2(id_t_pos)))];      % New range for extrapolation
% range_ext_neg        = [-u_neg:1:-ceil(min(r2(id_t_neg)))];      % New range for extrapolation

%%%%%%%%%%%%%% Extrapolate upcrossing spectrum
b = 1/-parp(1); b1 = 1/-parn(1);          % Does not change 

for k=1:length(range_ext_pos)
%     N_new_pos(k)=n_t_pos*exp(-(range_ext_pos(k)-u_pos)/parp(2)); %Exponential

    a(k) = 1-(-parp(1)*(range_ext_pos(k)-u_pos)/parp(2));        %GPD old
    N_new_pos(k)=real(n_t_pos*(a(k)^b));                              %GPD old

end
for k=1:length(range_ext_neg)
%     N_new_neg(k)=n_t_neg*exp(-(range_ext_neg(k)+u_neg)/parn(2));   %Exponential

    a1(k) = 1-(-parn(1)*sort((abs(range_ext_neg(k)))-u_neg)/parn(2));         %GPD
    N_new_neg(k)=n_t_neg*(a1(k)^b1);                              %GPD
end


%%%%%%%%%%%% Plot Extrapolated upcrossing spectrum
figure(65)
set(gcf,'color','w');
plot(range_ext_neg, N_new_neg,'r-',range_ext_pos, N_new_pos,'b-',r, n1,'k-')
set(gca, 'YScale', 'log')
title('Level upcrossing spectrum')
xlabel(['Load level [' , char(181),'m/m]'])
ylabel('Upcrossings')
legend('','')
axis([-500 500 1e-4 10e5])

%%%%%%%%%%%%%%%%%%%%%%%%%% Define extrapolated upcrossing spectrum
id1=max(find(r<=-u_neg));
id2=min(find(r>=u_pos));
r2 = [range_ext_neg r(id1:id2) range_ext_pos];
n2 = real([real(N_new_neg) n(id1:id2) real(N_new_pos)]);

midpoint = find(r2==0);
S=[];N=[];
for i=0:length(r2(midpoint:end-1))
    S(i+1)=abs(r2(midpoint-i))+r2(midpoint+i);
    if i>0
        S(i+1)=abs(r2(midpoint-i))+r2(midpoint+i)-S(i);
        %S(i) = abs(r2(length(n2)/2)+i)
        N(i+1) = n2(midpoint-i)+n2(midpoint+i);
    end
end

figure(67)
set(gcf,'color','w');
plot(S,N,'k-')
axis([0 600 1e-2 10e7])
set(gca, 'YScale', 'log')
title('Level upcrossing spectrum')
xlabel(['Load level [' , char(181),'m/m]'])
ylabel('Upcrossings')
legend('','')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Cumulative RFM:
for i=1:length(N_new_pos)
    for j=1:length(N_new_neg)
        RFM_cum(i,j) = (N_new_pos(i)*N_new_neg(j))/(N_new_pos(i)+N_new_neg(j));
    end
end

%%%%%% Limiting RFM
for i=1:size(RFM_cum,1)-1
    for k=2:size(RFM_cum,2)
       G_rfm(i,k-1) = RFM_cum(i+1,k-1) - RFM_cum(i,k-1) - RFM_cum(i+1,k) + RFM_cum(i,k);
    end
end
G_rfm(G_rfm<0)=eps;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%% NEW
P_neg=N_new_neg/sum(N_new_neg);   %probabilty of number of opcrossings being on load level u
% P_neg=N_new_neg/sum(n2);   %probabilty of number of opcrossings being on load level u
mu_neg = (P_neg.*N_new_neg);%/(length(X)/fs);
P_pos=N_new_pos/sum(N_new_pos);   %probabilty of number of opcrossings being on load level u
% P_pos=N_new_pos/sum(n2);   %probabilty of number of opcrossings being on load level u
mu_pos = (P_pos.*N_new_pos);%/(length(X)/fs); % E(Nt)/T

% FIGURES:
H_rfm = G_rfm; H_rfm(G_rfm<1e-5)=NaN;

rfm2=rfm; rfm2(end-100:end,1:100)=0;
B1=[]; B1=smoothdata(rfm2,1,'gaussian',60);
rfm_smooth=[];rfm_smooth=smoothdata(B1,2,'gaussian',60);

B2=[]; B2=smoothdata(RFM,1,'gaussian',20);
RFM_smooth=[];RFM_smooth=smoothdata(B2,2,'gaussian',20);

% figure(70)
% set(gcf,'color','w');
% contourf(range_ext_neg(1:end-1),range_ext_pos(1:end-1),H_rfm)
% hold on
% plot(VLS,PKS,'r.')
% axis([-500 150 -150 500])
% xlabel(['To [', char(181),'m/m]'])
% ylabel(['From [', char(181),'m/m]'])
% xline(-u_neg,'r-','u_m_i_n');
% yline(u_pos,'r-','u_m_a_x');

% figure(71)
% plot(r2, n2,'k-')
% set(gca, 'YScale', 'log')
% title('Level upcrossing spectrum')
% xlabel(['Load level [' , char(181),'m/m]'])
% ylabel('Upcrossings')
% axis([-450 450 1e-2 10e5])

% figure(72)
% set(gcf,'color','w');
% contourf(range_ext_neg(1:end-1),range_ext_pos(1:end-1),G_rfm,[1e-5 1e-4 1e-3 1e-2 1e-1 1 10 100 1000])

% figure(73)
% set(gcf,'color','w');
% subplot(2,2,1)
% contourf(ToBinCenter,FromBinCenter,rfm,[1e-5 1e-4 1e-3 1e-2 1e-1 1 10 1e2 1e3 1e4 1e5]);
% title('Original rainflow count')
% subplot(2,2,2)
% contourf(Ycentre,Xcentre,RFM,[1e-5 1e-4 1e-3 1e-2 1e-1 1 10 1e2 1e3 1e4 1e5]);
% title('Rainflow from PKS/VLS')
% subplot(2,2,3)
% contourf(ToBinCenter,FromBinCenter,rfm_smooth,[1e-5 1e-4 1e-3 1e-2 1e-1 1 10 1e2 1e3 1e4 1e5]);
% title('Smoothened original rainflow')
% subplot(2,2,4)
% contourf(Ycentre,Xcentre,RFM_smooth,[1e-5 1e-4 1e-3 1e-2 1e-1 1 10 1e2 1e3 1e4 1e5]);
% title('Smoothened rainflow from PKS/VLS')


% figure(74)
% set(gcf,'color','w');
% contourf(ToBinCenter,FromBinCenter,rfm_smooth,[1e-5 1e-4 1e-3 1e-2 1e-1 1 10 100 1000]);%,'LineColor', 'none')
% hold on
% contourf(range_ext_neg(1:end-1),range_ext_pos(1:end-1),H_rfm,[1e-5 1e-4 1e-3 1e-2 1e-1 1 10 100 1000])
% hold on
% plot(VLS,PKS,'r.')
% axis([-450 200 -200 400])
% xlabel(['To [', char(181),'m/m]'])
% ylabel(['From [', char(181),'m/m]'])
% xline(-u_neg,'r-','u_m_i_n');
% yline(u_pos,'r-','u_m_a_x');

% Smoothen the bulk of the distribution
rfm2=rfm; rfm2(end-120:end,1:120)=0;
B1=[]; B1=smoothdata(rfm2,1,'gaussian',60);
rfm_smooth=[];rfm_smooth=smoothdata(B1,2,'gaussian',60);
figure(74)
set(gcf,'color','w');
contourf(ToBinCenter,FromBinCenter,rfm_smooth,logspace(-5,3,16));%,'LineColor', 'none')
hold on
contourf(range_ext_neg(1:end-1),range_ext_pos(1:end-1),H_rfm,logspace(-5,3,16))
hold on
plot(VLS,PKS,'r.')
axis([-450 200 -200 450])
xlabel(['To [', char(181),'m/m]'])
ylabel(['From [', char(181),'m/m]'])
xline(-u_neg,'r-','u_m_i_n');
yline(u_pos,'r-','u_m_a_x');

end


