
function [u_MRL] = Threshold_selection(x,fs)

N_u=[];
e_n=[];

u_max = floor(floor(max(abs(x)))/10)*10;        % Round off maximum threshold to check
u_min = 0;                                      % Define minimum threshold to check
%u = linspace(u_min,ceil(max(x)),ceil(max(x))+1);
u = linspace(u_min,200,51);%(u_max-u_min)/10);        %Define possible thresholds to check

for i = 1:length(u) 
    
    % Only peaks seperated by minpeakdistance
    [pks,t_pos] = findpeaks(x,fs,'MinPeakHeight',u(i),'MinPeakDistance',0.1);
    [vls,t_neg] = findpeaks(-x,fs,'MinPeakHeight',u(i),'MinPeakDistance',0.1);
    N_u(i) = length(pks)+length(vls);               %Number of total exceedances
    e_n(i) = (1/N_u(i))*(sum(pks)+sum(abs(vls)));   %Determine empirical estimates 
       
    SEM(i) = std(e_n)/sqrt(N_u(i));               % Standard Error
    ts = tinv([0.025  0.975],length(x)-1);                % T-Score
    CI(i,:) = e_n(i) + ts*SEM(i);                      % Confidence Intervals
    
    %All values exceeding u
%     Exc = x(x>u(i) | x<-u(i)); % Identify values above and below threshold
%     N_u2(i) = length(Exc);
%     e_n2(i) = (1/N_u2(i))*sum(abs(Exc)); 
    
    if isempty(pks)~=1 & isempty(vls)~=1
        [par_pos,par_pos_ci] = gpfit(pks-u(i));
        [par_neg,par_neg_ci] = gpfit(vls-u(i));
        xi_pos(i) = par_pos(1);
        xi_neg(i) = par_neg(1);
        parp_ci(i,:)=par_pos_ci(:,1)';
        parn_ci(i,:)=par_neg_ci(:,1)';
    end
    
end


%Plot empirical thresholds, good threshold is straight line in plot

figure(19)
set(gcf,'color','w');
hold on
plot(u,e_n,'b-',u,CI(:,1)','b:',u,CI(:,2)','b:')%,u,e_n2,'k-')
xlabel(['Threshold for extreme loads [' , char(181),'m/m]'])
ylabel(['Mean excess [' , char(181),'m/m]'])

for k =1:10
xline(u(k*floor(length(u)/10)),'k:',num2str(N_u(k*floor(length(u)/10))));
% xline(u(k*5+2),'k-',num2str(N_u2(k*5+2)));
end
%legend('Original time history','95% CI')

figure(21)
set(gcf,'color','w');
subplot(2,1,1)
plot(u(1:length(xi_pos)),xi_pos,'b-',...
    u(1:length(xi_pos)),parp_ci(:,1),'b:',u(1:length(xi_pos)),parp_ci(:,2),'b:')
%legend('Positive exceedances','95% CI')
xlabel(['Threshold [' , char(181),'m/m]'])
ylabel('MLE of shape parameter')
axis([0 160 -1 1])
subplot(2,1,2)
plot(u(1:length(xi_neg)),xi_neg,'r-',...
    u(1:length(xi_neg)),parn_ci(:,1),'r:',u(1:length(xi_neg)),parn_ci(:,2),'r:')
%legend('Negative exceedances','95% CI')
xlabel(['Threshold [' , char(181),'m/m]'])
ylabel('MLE of shape parameter')
axis([0 160 -1 1])
set(gcf,'color','w');

u_MRL = 78;

end
