function [xcoords,cycles] = RFM_to_load_spectra(X, fs)

% Calcualate RFM
for j=1:size(X,2)
samples = [];
[c,hist{j},edges{j},~,~] = rainflow(X{j},fs); %Save rainflow data
cycles{j} = sum(hist{j},2);

% Create range values from RFM to rescale histogram into equal no of bins
for i = 1:size(hist{j},1)-1      %Check all strain ranges
        section_sample = repmat((edges{j}(i)+edges{j}(i+1))/2,[ceil(cycles{j}(i)) 1]);    % make array of range samples
        samples = [samples;section_sample];                                               % Store values
end
sample{j} = samples;

% Define desired bin edges
new_edges = linspace(0,500,501);

% Rescale RFM to equal no of bins per sample
figure(j)
fig=j;
h=histogram(sample{j},new_edges);
ycoords{j} = h.Values;
edgecoords  = h.BinEdges; 
xcoords{j}  =   h.BinEdges + 0.5* h.BinWidth;
xcoords{j}  = xcoords{j}(1:end-1);
close(fig)

end

% Normalize all spectra
cycles{1}   =   movmean(ycoords{1},3);
cycles{2}   =   movmean(ycoords{2}/(length(sample{2})/length(sample{1})),3);
cycles{3}   =   movmean(ycoords{3}/(length(sample{3})/length(sample{1})),3);
cycles{4}   =   movmean(ycoords{4}/(length(sample{4})/length(sample{1})),3);

% cycles{1}   =   ycoords{1};
% cycles{2}   =   ycoords{2};
% cycles{3}   =   ycoords{3};
% cycles{4}   =   ycoords{4};

% figure(50)
% set(gcf,'color','w');
% plot(xcoords{1}, movmean(ycoords{1},3),'k-',...
%     xcoords{2}, movmean(ycoords{2}/(length(sample{2})/length(sample{1})),3),'b-',...
%     xcoords{4}, movmean(ycoords{4}/(length(sample{4})/length(sample{1})),3),'m-')
% set(gca, 'YScale', 'log')
% legend('Original','10x POT','validation')
% axis([0 500 1e-2 10e5])
% ylabel('Number of cycles [-]')
% xlabel(['Strain range ', '[' , char(181),'m/m]'])
% % 
% figure(51)
% set(gcf,'color','w');
% plot(Strain{1},cycles{1},'k-',...
%     Strain{2},cycles{2}/10,'b-',...
%     Strain{4},cycles{4}/10,'m-')
% set(gca, 'YScale', 'log')
% legend('Original','10x POT','validation')
% axis([0 500 1e-2 10e5])
% ylabel('Number of cycles [-]')
% xlabel(['Strain range ', '[' , char(181),'m/m]'])

end