function [D,E,T_FL] = PSDtoDamage(Sxx_onesided,freq_onesided,targetsize,m,T,A,D_ref)

%Resize all data
G = Sxx_onesided;                           % Define magnitude
f = freq_onesided;                          % Define frequencies
if targetsize >= 1;
    G_k = imresize(G, [targetsize 1]);      % Resize to prevent memory issues
    f_k = imresize(f, [1 targetsize]);
else
    G_k = G;    % resize to prevent memory issues
    f_k = f;
end

w_k = f_k*2*pi;
dw_k = mean(diff(w_k));
df_k = mean(diff(f_k));

%Plot resized vs regular 
figure(30)
set(gcf,'color','w');
subplot(2,1,1)
plot(f_k,10*log10(G_k))
title('Resampled one sided spectrum')
xlabel('f (Hz)')
ylabel('|P(f)|')
axis([0 200 -60 10])
subplot(2,1,2)
plot(f,10*log10(G))
axis([0 200 -60 10])
title('Original one sided spectrum')
xlabel('f (Hz)')
ylabel('|P(f)|')



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculate spectral moments
    M_0     =   f_k.^0 * G_k * df_k;
    M_075   =   f_k.^0.75 * G_k * df_k;
    M_1     =   f_k.^1 * G_k * df_k;
    M_15     =  f_k.^1.5 * G_k * df_k;
    M_2     =   f_k.^2 * G_k * df_k;
    M_4      =  f_k.^4 * G_k * df_k;
    M_SM     =  f_k.^(2/m) * G_k * df_k;
    M_SM2    =  f_k.^(2/m+2) * G_k * df_k;

% Same calculations using radians
    Mw_0     =   w_k .^ 0 * G_k * dw_k;
    Mw_075   =   w_k.^0.75 * G_k * dw_k;
    Mw_1     =   w_k.^1 * G_k * dw_k;
    Mw_15     =   w_k.^1.5 * G_k * dw_k;
    Mw_2     =   w_k.^2 * G_k * dw_k;
    Mw_4     =   w_k.^4 * G_k * dw_k;
    Mw_SM     =  w_k.^(2/m) * G_k * dw_k;
    Mw_SM2     =  w_k.^(2/m+2) * G_k * dw_k;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculate parameters 
sigma_s     =   sqrt(M_0);%21.2414;%5; % 5.2415;   %overall RMS level of original stress signal
E_zero      =   sqrt(M_2/M_0);            %Expected rate of zero upcrossings
E_P         =   sqrt(M_4/M_2);            %Expected rate of peaks
alpha2      =   M_2 / sqrt(M_0*M_4);     %Irregularity factor


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculate damage

D_NB(1) = E_zero*T*A^-1*(sqrt(2*M_0)^m)*gamma(0.5*m+1); %Try 2 ways to determine E_zero

% Other narrowband options found in literature

% D_NB(2) = ((E_zero*T)/A)*(2*sqrt(2)*sigma_s)^m*gamma(0.5*m+1); %Try 2 ways to determine E_zero
% D_NB(4) = ((T/(2*pi)*sqrt(Mw_2/Mw_0))/A)*(2*sqrt(2)*sigma_s)^m * gamma(0.5*m+1);
% D_NB(9) = ((E_zero*T)/A)*(2*sqrt(2)*5)^m*gamma(0.5*m+1); %Try 2 ways to determine E_zero
% 
% D_NB(3) = (T*2^(3*m/2)/(2*pi*A))*gamma(m/2+1)*((1/(2*pi))*Mw_0)^((m-1)/2)*sqrt(((1/(2*pi))*Mw_2));
% D_NB(5) = E_P*T*A^-1*(sqrt(2*Mw_0)^m)*gamma(0.5*m+1); %Try 2 ways to determine E_P
% D_NB(6) = ((E_P*T)/A)*(2*sqrt(2)*sigma_s)^m*gamma(0.5*m+1); %Try 2 ways to determine E_P
% D_NB(7) = E_P*A^-1*(sqrt(2*M_0)^m)*gamma(1+0.5*m);
% D_NB(8) = E_zero*T*A^-1*(sqrt(2*Mw_0)^m)*gamma(0.5*m+1); %Try 2 ways to determine E_zero
% 
% D_NB(10) = (T*2^(3*m/2)/(2*pi*A))*gamma(m/2+1)*((1/(2*pi))*M_0)^((m-1)/2)*sqrt(((1/(2*pi))*M_2));
% D_NB(11) = ((T/(2*pi)*sqrt(M_2/M_0))/A)*(2*sqrt(2)*sigma_s)^m * gamma(0.5*m+1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Wirsching and Light
a       =   0.926 - 0.033*m;
b       =   1.587*m - 2.323;
epsilon  =   sqrt(1-alpha2^2);
c_WL = a + (1-a) * (1-epsilon) ^ b;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Dirlik
% x_m     =   (Mw_1/Mw_0)*sqrt(Mw_2/Mw_4);
x_m     =   (M_1/M_0)*sqrt(M_2/M_4);
G1      =   (2*(x_m-alpha2^2))/(1+alpha2^2);
R       =   (alpha2-x_m-G1^2)/(1-alpha2-G1+G1^2);
G2      =   (1-alpha2-G1+G1^2)/(1-R);
G3      =   1-G1-G2;
Q       =   (1.25*(alpha2-G3-G2*R))/G1;

D_DK    =   T*((E_P* M_0^(m/2))/A)*(G1*Q^m*gamma(1+m)+(sqrt(2)^m)*gamma(1+m/2)*(G2*abs(R)^m+G3));
% AA      =   G1*(Q^m)*gamma(1+m)+(sqrt(2)^m)*gamma(1+m/2)*(G2*(abs(R)^m)+G3);
% D_dk    =   T*(A^-1)*E_P*(M_0^(m/2))*AA;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Ortiz & Chen
b_k         =   sqrt((M_2*M_SM)/(M_0*M_SM2));
% b_k         =   sqrt((Mw_2*Mw_SM)/(Mw_0*Mw_SM2));
c_OC    =   (b_k^m)/alpha2;  

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Larsen and Lutes Single Moments method
c_SM    = (M_SM^(m/2))/((sigma_s^m)*E_zero);
% c_SM(2)  = (M_SM^(m/2))/((sigma_s^m)*E_zero(2));


%D_SM = (T/A)*(2*sqrt(2))^m*(M_SM^(m/2))*gamma(0.5*m+1);
D_SM = (T/A)*sqrt(2)^m*(M_SM^(m/2))*gamma(0.5*m+1);
% D_SM = T*(2^(3*m/2)/(2*pi*A))*Mw_SM^(m/2)*gamma(m/2+1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Benasciutti & Tovo
a1      =   M_1/(sqrt(M_0*M_2));
a2      =   alpha2;

% Benasciutti en Tovo 2 (alpha75 method)
c_a75    = (M_075/sqrt(M_0*M_15))^2;        % alpha 75 method


% b       =   ((a1-a2)*(1.112*(1+a1*a2-(a1+a2))*exp(2.11*a2)+(a1-a2)))/a2;
% b       =   ((a1-a2)*(1.112*(1+a1*a2-(a1+a2))*exp(2.11*a2)+(a1-a2)))/(a2-1)^2;
b1       =   min([(a1-a2)/(1-a1) 1]); 
b2       =   ((a1-a2)*(1.112*(1+a1*a2-(a1+a2))*exp(2.11*a2)+(a1-a2)))/(1-a2)^2;
b3      = (c_a75 - a2^2)/(1-a2^2);
% b       = (a1-a2)/(1-a1);
c_BT1    =   (b1 + (1-b1)* a2^(m-1));%*a2;
c_BT2    =   (b2 + (1-b2)* a2^(m-1));%*a2;
c_BT3    =   (b3 + (1-b3)* a2^(m-1));%*a2;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Zhao & Baker
aa = 8 - 7 * a2;
bb = 1.1;
if a2 >= 0.9
    bb = 1.1 + 9*(a2 - 0.9);
end
eta = (1-a2)/(1-sqrt(2/pi)*gamma(1+1/bb)*aa^(-1/bb));
D_ZB2 =T*E_P*A^-1*M_0^(m/2)*(eta*aa^(-m/bb)*gamma(1+m/bb)+(1-eta)*2^(m/2)*gamma(1+m/2));
D_ZB = T*(E_P/A)*M_0^(m/2)*(eta*aa^(-m/bb)*gamma(1+m/bb)+(1-eta)*2^(m/2)*gamma(1+m/2));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% ceta = [c_WL, c_OC ,c_SM,c_a75, c_BT1,  c_BT2, c_BT3];  %All methods
ceta = [c_OC ,c_SM,c_a75, c_BT3];                       %Selected methods on this application
D = [D_NB.*ceta';D_DK;D_ZB];
f = D_ref/mean(D);
format long

% Display fatigue life, damage and error to ME 
T_FL = (T/3600)*(1./(D*f));
D = D*f;
E = (D-D_ref)/D_ref*100;

% D_spec = (D_NB.*ceta')/4.8e-4;
%D_spec = (D_NB.*ceta')/5.07e-5;
%D_spec = [D_NB D_SM D_DK]
end