function[B, f1, x_PSD, t_PSD] = PSD_extrapolation(x, fs, N_ext)

%%%%%%%%% Define length of signal and total time of signal
l = length(x);                           % number of samples
T = l/fs;                                % Length of required time signal

%% %%%%%% Method 1: FFT, both double and single sided PSD
xdft = fft(x);                           % fourier transform
Sxx = (1/(fs*l)) * abs(xdft).^2;         % double sided spectrum
Sxx_onesided = Sxx(1:l/2+1);             % single sided spectrum
Sxx_onesided(2:end-1) = 2*Sxx_onesided(2:end-1);             % single sided spectrum
df = fs/l;                               % frequency steps in plot
freq = -fs/2+df:df:fs/2;                 % create double sided frequency vector
f1 = 0:fs/length(x):fs/2;                % one sided freq vector

%B = smoothdata(10*log10(Sxx_onesided),'gaussian',10000); % Smoothen Single sided spectrum
B = smoothdata(Sxx_onesided,'gaussian',10000); % Smoothen Single sided spectrum
%% %%%%% Method 2: FFT, to check first method 
% xdf = fft(x);                           % fourier transform
% xdf = xdf(1:l/2+1);                   % only use single sided spectrum
% Sxx1 = (1/(fs*l)) * abs(xdf).^2;       % double sided spectrum
% Sxx1(2:end-1) = 2*Sxx1(2:end-1);

%% %%%%%%%%% Method 3, periodogram
% [Sxx2]=periodogram(x);

%% %%%%%%%% Method 4, pwelch
% % [Sxx3,f3] = pwelch(x);
% P = 2^12;
% [Sxx3,f3] = pwelch(x,100,[],P);
% Sxx_3 = Sxx3;                       % Copy signal for calculating double sided spectrum
% Sxx_3(2:end-1) = Sxx_3(2:end-1)/2;  % Divide single sided spectrum by 2 to get double sided spectrum and maintain equal power
% Sxx_31 = flip(Sxx_3(2:end));        % Mirror values for full spectrum and remove first value
% SXX3 = [Sxx_3 ;Sxx_31];               % Combine arrays for spectrum
% F3 = [-flip(f3(2:end)); f3];

%% %%%%%%% Method 5, periodogram with 95% conf bounds.
% [Sxx4,f4,pxxc] = periodogram(x,rectwin(l),l,fs,...
%     'ConfidenceLevel',0.95);

%% %%%%%% Method 6, covariance method
% [Sxx5 ,f5] = pcov(x,64,f1,fs);
% Sxx_5 = Sxx5;                       % Copy signal for calculating double sided spectrum
% Sxx_5(2:end-1) = Sxx_5(2:end-1)/2;  % Divide single sided spectrum by 2 to get double sided spectrum and maintain equal power
% Sxx_51 = flip(Sxx_5(2:end));        % Mirror values for full spectrum and remove first value
% SXX = [Sxx_5 Sxx_51];               % Combine arrays for spectrum

%% %%% Plot both double sided spectra
% figure(44)
% plot(freq,movmean(10*log10(Sxx),1000),'r-',...
%     freq,10*log10(SXX),'k-')
% 
% figure(22)
% plot(f1,movmean(10*log10(Sxx_onesided),1000),'r-',...
%     f1,movmean(10*log10(Sxx1),1000),'m-',...
%     f3*(250/pi),10*log10(Sxx3),'g-',...
%     f4,movmean(10*log10(Sxx4),1000),'k-.',...
%     f5,10*log10(Sxx5),'b-')
% legend('fft','FFT','Pwelch','Periodo','pcov')





% figure(22)
% plot(f1,B,'r-',...
%     f5,10*log10(Sxx5),'b-')
% legend('Smoothened fft','pcov')

% figure(22)
% plot(f1,movmean(10*log10(Sxx_onesided),2000),'r-',...
%     f5,10*log10(Sxx5),'b-')
% legend('fft','FFT','Pwelch','Periodo','pcov')
%% Create required time vector from PSD

x_PSD = []; t_PSD = [];

% if N_ext~=0; % Only extrapolate if needed
%     for i=1:N_ext*floor(length(x)/length(SXX3))
%         [timeseries, time] = TimeseriesFromPSD(SXX3, fs, length(SXX3)/fs);  %create timeseries from PSD
%         x_PSD = [x_PSD; timeseries];
%         %t = linspace(0,time(end),length(time))
%     end
%     t_PSD = linspace(0,length(x_PSD)/fs,N_ext*floor((length(x)/length(SXX3)))*length(SXX3));
%     %t_PSD = linspace(0,N_ext*time(end),N_ext*length(time));
%     
% else
%     %[timeseries, time] = TimeseriesFromPSD(Sxx, fs, T);  %create timeseries from PSD
%     x_PSD = [];%timeseries;
%     t_PSD = [];%time;
%     
% end

if N_ext~=0; % Only extrapolate if needed
    %B1 = smoothdata(10*log10(Sxx),'gaussian',10000); % Smoothen double sided spectrum
    for i=1:N_ext
        [timeseries, time] = TimeseriesFromPSD(Sxx, fs, T);  %create timeseries from PSD
        x_PSD = [x_PSD; timeseries];
        %t = linspace(0,time(end),length(time))
    end
    t_PSD = linspace(0,N_ext*time(end),N_ext*length(time));
    
else
    %[timeseries, time] = TimeseriesFromPSD(Sxx, fs, T);  %create timeseries from PSD
    x_PSD = [];%timeseries;
    t_PSD = [];%time;
    
end


end
