function [X,Exc_2] = EVT(x,fs,N_t,u_MRL)

%This function extrapolates the signal x with sample rate fs by modifying
% extreme values above and below the threshold u.


%% Identify peaks and valleys in the signal
[pks,t_pos] = findpeaks(x,fs,'MinPeakHeight',u_MRL,'MinPeakDistance',0.05);
[vls,t_neg] = findpeaks(-x,fs,'MinPeakHeight',u_MRL,'MinPeakDistance',0.05);

id_pos = t_pos*fs;                        % Find positions of positive exceedances
id_neg = t_neg*fs;                        % Find positions of negative exceedances

%% Fit exponential distribution 
Z_pos = pks-u_MRL;     % Positive exceedances
Z_neg = vls-u_MRL;     % Negative exceedances
Exc_x_pos = unique(Z_pos);
Exc_x_neg = unique(Z_neg);

Exc = [t_pos Z_pos;t_neg -Z_neg];   % Save times and exceedances
[~,idx] = sort(Exc(:,1));           % Save sorting order based on time data
Exc_2 = Exc(idx,:);                 % Put exceedances in correct time order
m_pos = mean(Z_pos);                % Calculate mean of pos exceedances
m_neg = mean(Z_neg);                % Calculate mean of neg exceedances

%F_pos = 1-exp(-(Z_pos)/m_pos);                   % Cumulative distribution of exceedances
%F_neg = 1-exp(-(abs(Z_neg))/m_neg); 

% GPD fit to exceedances
[par_pos,parmci] = gpfit(Z_pos);
[par_neg,parmci] = gpfit(Z_neg);
y2_pos_gpd        = gpcdf(Exc_x_pos,par_pos(1),par_pos(2),0);
y2_pos1_gpd       = gppdf(Exc_x_pos,par_pos(1),par_pos(2),0);
y2_pos1_gpd_plot  = gppdf([0:200],par_pos(1),par_pos(2),0); % For plotting
y2_neg_gpd        = gpcdf(Exc_x_neg,par_neg(1),par_neg(2),0);
y2_neg1_gpd       = gppdf(Exc_x_neg,par_neg(1),par_neg(2),0);
y2_neg1_gpd_plot       = gppdf([0:200],par_neg(1),par_neg(2),0); % For plotting

%Construct exponential distribution
pd_pos = makedist('exponential',m_pos);     %Make exponential distribution for exceedance
pd_neg = makedist('exponential',m_neg);     %Make exponential distribution for exceedance
y_pos = cdf(pd_pos,Exc_x_pos);                 
y_neg = cdf(pd_neg,Exc_x_neg);
y_pos1 = pdf(pd_pos,Exc_x_pos);
y_pos1_plot = pdf(pd_pos,[0:200]); % for plotting
y_neg1 = pdf(pd_neg,Exc_x_neg);

%Construct Weibull distribution
pd_pos_wb = fitdist(Z_pos,'weibull');     %Make weibull distribution for exceedances
pd_neg_wb = fitdist(Z_neg,'weibull');     %Make weibull distribution for exceedance
y_pos_wb = cdf(pd_pos_wb,Exc_x_pos);                 
y_neg_wb = cdf(pd_neg_wb,Exc_x_neg);
y_pos1_wb = pdf(pd_pos_wb,Exc_x_pos);
y_neg1_wb = pdf(pd_neg_wb,Exc_x_neg);

%Construct Generalized pareto distribution
pd_pos_gpd = fitdist(Z_pos,'GeneralizedPareto');     %Make weibull distribution for exceedances
pd_neg_gpd = fitdist(Z_neg,'GeneralizedPareto');     %Make weibull distribution for exceedance
y_pos_gpd = cdf(pd_pos_gpd,Exc_x_pos);                 
y_neg_gpd = cdf(pd_neg_gpd,Exc_x_neg);
y_pos1_gpd = pdf(pd_pos_gpd,Exc_x_pos);
y_neg1_gpd = pdf(pd_neg_gpd,Exc_x_neg);

%Apply adaptive kernel density estimation
[y_aKDE_pos,x_aKDE_pos,optw_pos,~,~,confb95_pos,~] = ssvkernel(Z_pos,[0:1:200]);
[y_aKDE_neg,x_aKDE_neg,optw_neg,~,~,confb95_neg,~] = ssvkernel(Z_neg,[0:1:200]);

%% Calculate MSE to determine final threshold
% MSE_pos(1) = mean(([0;ecdf(Z_pos)] - [y_pos]).^2);
% MSE_pos(2) = mean(([0;ecdf(Z_pos)] - [y_pos_wb]).^2);
% MSE_pos(3) = mean(([0;ecdf(Z_pos)] - [y_pos_gpd]).^2);
% 
% MSE_neg(1) = mean(([0;ecdf(Z_neg)] - [y_neg]).^2);
% MSE_neg(2) = mean([0;ecdf(Z_neg)] - [y_neg_wb]).^2);
% MSE_neg(3) = mean(([0;ecdf(Z_neg)] - [y_neg_gpd]).^2);

MSE_pos(1) = mean((ecdf(Z_pos) - [0; y_pos]).^2);
MSE_pos(2) = mean((ecdf(Z_pos) - [0; y_pos_wb]).^2);
MSE_pos(3) = mean((ecdf(Z_pos) - [0; y_pos_gpd]).^2)

MSE_neg(1) = mean((ecdf(Z_neg) - [0; y_neg]).^2);
MSE_neg(2) = mean((ecdf(Z_neg) - [0; y_neg_wb]).^2);
MSE_neg(3) = mean((ecdf(Z_neg) - [0; y_neg_gpd]).^2)

method_neg=find(min(abs(MSE_neg))==MSE_neg);
method_pos=find(min(abs(MSE_pos))==MSE_pos);

if method_neg == 1
    disp('Optimal fit is for neg exceedances is exponential')
elseif method_neg == 2
    disp('Optimal fit is for neg exceedances is Weibull')
elseif method_neg == 3
    disp('Optimal fit is for neg exceedances is GPD')
end

if method_pos == 1
    disp('Optimal fit is for pos exceedances is exponential')
elseif method_pos == 2
    disp('Optimal fit is for pos exceedances is Weibull')
elseif method_pos == 3
    disp('Optimal fit is for pos exceedances is GPD')
end

%% Plots
% figure(23)
% ecdf(Z_pos)
% hold on
% plot(Exc_x_pos,y_pos,'r-',Exc_x_pos,y_pos_wb,'k--',Exc_x_pos,y_pos_gpd,'b:')%,Exc_x_pos,y2_pos_gpd,'b-')%,Z_pos,F_pos,'r*')
% set(gca, 'XScale', 'log')
% legend('data','Exp fit','Wbl fit','GPD fit')%,'GPD fit2')
% title('CDF of positive exceedances fur u = 150')
% xlabel(['x [', char(181),'m/m]' ])
% ylabel('F(x)')
% xlim([3e-1 200])
% % xlim([120 360])
% % ylim([0.991 1.001])
% set(gcf,'color','w');
% % % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% figure(24)
% ecdf(Z_neg)
% hold on
% plot(Exc_x_neg,y_neg,'r-',Exc_x_neg,y_neg_wb,'k--',Exc_x_neg,y_neg_gpd,'b:')%,Exc_x_neg,y2_neg_gpd,'b-')%,abs(Z_neg),F_neg,'r*')
% set(gca, 'XScale', 'log')
% legend('data','Exp fit','Wbl fit','GPD fit')%,'GPD fit2')
% title('CDF of negative exceedances for u = 150')
% xlabel(['x [', char(181),'m/m]' ])
% ylabel('F(x)')
% xlim([3e-1 150])
% % xlim([120 300])
% % ylim([0.995 1.001])
% set(gcf,'color','w');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% figure(25)
% plot(Exc_x_pos,y_pos1,'r-',Exc_x_pos,y_pos1_wb,'k-',Exc_x_pos,y_pos1_gpd,'b:',x_aKDE_pos,y_aKDE_pos,'b-')
% % plot(Exc_x_pos,y_pos1,'r-',Exc_x_pos,y_pos1_wb,'k-',Exc_x_pos,y_pos1_gpd,'b:')%,Exc_x_pos,y2_pos1_gpd,'b-')
% set(gca, 'XScale', 'log')
% legend('Exp','Wbl','GPD','aKDE')%,'GPD2')
% title('PDF of positive exceedances above threshold')
% xlabel(['x [', char(181),'m/m]' ])
% ylabel('f(x)')
% set(gcf,'color','w');
% % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% figure(26)
% plot(Exc_x_neg,y_neg1,'r-',Exc_x_neg,y_neg1_wb,'k-',Exc_x_neg,y_neg1_gpd,'b:',x_aKDE_pos,y_aKDE_pos,'b-')%,Exc_x_neg,y2_neg1_gpd,'b-')
% set(gca, 'XScale', 'log')
% legend('Exp','Wbl','GPD','aKDE')%,'GPD2')
% title('PDF of negative exceedances above threshold')
% xlabel(['x [', char(181),'m/m]' ])
% ylabel('f(x)')
% set(gcf,'color','w');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

x1=1:length(ecdf(Z_pos));
x2=1:length(ecdf(Z_neg));

figure(27)
subplot(2,1,1)
plot(x1,(ecdf(Z_pos) - [0; y_pos]).^2,'k-',...
    x1,(ecdf(Z_pos) - [0; y_pos_wb]).^2,'b-',...
    x1,(ecdf(Z_pos) - [0; y_pos_gpd]).^2,'r-')
yline(0,'k-');
legend('Exp','Wbl','GPD')%,'GPD2')
title('Squared Error for positive exceedances for u = 150')
xlabel('Exceedance number [-]')
ylabel(['Error ', '[' , char(181),'m/m]'])
subplot(2,1,2)
plot(x2,(ecdf(Z_neg) - [0; y_neg]).^2,'k-',...
    x2,(ecdf(Z_neg) - [0; y_neg_wb]).^2,...
    'b-',x2,(ecdf(Z_neg) - [0; y_neg_gpd]).^2,'r-')
yline(0,'k-');
legend('Exp','Wbl','GPD')%,'GPD2')
title('Squared Error for negative exceedances for u = 150')
xlabel('Exceedance number [-]')
ylabel(['Error ', '[' , char(181),'m/m]'])
set(gcf,'color','w');


%% Create new extrapolated time signal
% Assign and empty required arrays and copy original signal for 3 time
% extrapolation
X=[]; x_ext_pos=[]; x_ext_neg=[]; 
x_ext_pos_wb=[]; x_ext_neg_wb=[];
x_ext_pos_gpd=[]; x_ext_neg_gpd=[];  
x1 = x;                    

% Extrapolate N_t times
for n=1:N_t
    %Draw randomly from created distributions to generate new values
    if method_pos == 1          %exponential distribution
        % make new values and replace old with new
        x_ext_pos = (exprnd(pd_pos.mu,1,length(id_pos))+ u_MRL);
        x(floor(id_pos))= x_ext_pos;
        
        % Loop for smoothing peak value into signal
        for i=1:9
            x(floor(id_pos-i))= x(floor(id_pos-10))+ (x_ext_pos'-x(floor(id_pos-10)))*(1-i/10);  %Smooth 4 values left of peak
            x(floor(id_pos+i))= x(floor(id_pos+10))+ (x_ext_pos'-x(floor(id_pos+10)))*(1-i/10);  %Smooth 4 values right of peak

        end
  
        
    elseif method_pos ==2       %weibull distribution
        % make new values and replace old with new
        x_ext_pos_wb = (wblrnd(pd_pos_wb.a,pd_pos_wb.b,[length(id_pos) 1])+ u_MRL);
        x(floor(id_pos))= x_ext_pos_wb;
        
        % Loop for smoothing peak value into signal
        for i=1:9
            x(floor(id_pos-i))= x(floor(id_pos-10))+ (x_ext_pos_wb-x(floor(id_pos-10)))*(1-i/10);  %Smooth 4 values left of peak
            x(floor(id_pos+i))= x(floor(id_pos+10))+ (x_ext_pos_wb-x(floor(id_pos+10)))*(1-i/10);  %Smooth 4 values right of peak
        end
        
    elseif method_pos ==3               %generalized pareto distr
        % make new values and replace old with new
        x_ext_pos_gpd = (gprnd(pd_pos_gpd.k,pd_pos_gpd.sigma,pd_pos_gpd.theta,[length(id_pos) 1])+ u_MRL);
        x(floor(id_pos))= x_ext_pos_gpd;                          %Replace old with new positive peaks
        
        % Replace old values with new
        for i=1:9
            x(floor(id_pos-i))= x(floor(id_pos-10))+ (x_ext_pos_gpd-x(floor(id_pos-10)))*(1-i/10);  %Smooth 4 values left of peak
            x(floor(id_pos+i))= x(floor(id_pos+10))+ (x_ext_pos_gpd-x(floor(id_pos+10)))*(1-i/10);  %Smooth 4 values right of peak
        end
    end
        
        
        %Draw randomly from created distributions to generate new values
    if method_neg == 1          %exponential distribution
        % make new values and replace old with new
        x_ext_neg = (-exprnd(pd_neg.mu,1,length(id_neg))- u_MRL);
        x(floor(id_neg))= x_ext_neg;
        
        % Loop for smoothing peak value into signal
        for i=1:9
            x(floor(id_neg-i))= x(floor(id_neg-10))+ (x_ext_neg'-x(floor(id_neg-10)))*(1-i/10);  %Smooth 4 values left of valleys
            x(floor(id_neg+i))= x(floor(id_neg+10))+ (x_ext_neg'- x(floor(id_neg+10)))*(1-i/10);  %Smooth 4 values right of valleys
        end
        
    elseif method_neg ==2       %weibull distribution
        % make new values and replace old with new
        x_ext_neg_wb = (-wblrnd(pd_neg_wb.a,pd_neg_wb.b,[length(id_neg) 1])- u_MRL);
        x(floor(id_neg))= x_ext_neg_wb;
        
        % Loop for smoothing peak value into signal
        for i=1:9
            x(floor(id_neg-i))= x(floor(id_neg-10))+ (x_ext_neg_wb-x(floor(id_neg-10)))*(1-i/10);  %Smooth 4 values left of valleys
            x(floor(id_neg+i))= x(floor(id_neg+10))+ (x_ext_neg_wb-x(floor(id_neg+10)))*(1-i/10);  %Smooth 4 values right of valleys
        end
             
    elseif method_neg ==3               %generalized pareto distr
        % make new values and replace old with new
        x_ext_neg_gpd = (-gprnd(pd_neg_gpd.k,pd_neg_gpd.sigma,pd_neg_gpd.theta,[length(id_neg) 1])- u_MRL);
        x(floor(id_neg))= x_ext_neg_gpd;
        
        % Replace old values with new
        for i=1:9
            x(floor(id_neg-i))= x(floor(id_neg-10))+ (x_ext_neg_gpd-x(floor(id_neg-10)))*(1-i/10);  %Smooth 4 values left of valleys
            x(floor(id_neg+i))= x(floor(id_neg+10))+ (x_ext_neg_gpd-x(floor(id_neg+10)))*(1-i/10);  %Smooth 4 values right of valley
        end
    end
    
    if n<6
        % Plot section of original samples with extrapolated extreme values
        T1 = (1700*fs:1750*fs);
%         figure(111)
%         plot(T1,x(T1))
%         ylim([-200 200])
%         title('Time history extrapolation')
%         xlabel('Time [s]')
%         ylabel(['Strain ', '[' , char(181),'m/m]'])
%         hold on
    end
    
    X = [X;x];  % Save POT extrapolated signal x
    x=x1;       % Load original sample for new extrapolation
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Post-processing figure
% figure(111)
% hold  on
% plot(T1,x1(T1),'k-')
% yline(78,'k:','u_m_a_x');
% yline(-78,'k:','u_m_i_n');
% set(gcf,'color','w');
% legend('EVT extrapolation 1','EVT extrapolation 2','EVT extrapolation 3','EVT extrapolation 4','EVT extrapolation 5','Original signal')


% Calculations for Asymptotic Normality Assumption by parameter transformation
% [nll,bcov] = gplike(par_pos, Z_pos);
% stdErr1 = sqrt(diag(bcov));
% replEsts1 = bootstrp(1000,@gpfit,Z_pos); %Bootstrap to check if gpd parameter assumption is correct
% 
% [nll,acov] = gplike(par_neg, Z_neg);
% stdErr2 = sqrt(diag(acov));
% replEsts2 = bootstrp(1000,@gpfit,Z_neg); %Bootstrap to check if gpd parameter assumption is correct
% 
% figure(28)
% set(gcf,'color','w');
% subplot(2,1,1)
% h=probplot('exponential',Z_pos);
% %set(h,'Color','k','LineStyle','-');
% % set(hl1,'linestyle','--','color','k');
% set(h(1),'marker','x','Color','b');
% title('Exponential Probability Plot for positive exceedances')
% xlabel(['Exceedances [', char(181),'m/m]' ])
% legend('Fit','Data')

% % Only when an exponential prob distr is best
% subplot(2,1,2)
% q = qqplot(exprnd(pd_pos.mu,1,10000),Z_pos);
% set(q(1),'marker','x');
% set(q(3),'linestyle','--','color','k');
% legend([q(3) q(1)],'Fit','Data')
% axis([0 300 0 300])
% % % 
% % 
% figure(29)
% set(gcf,'color','w');
% h = histogram(Exc_x_pos,20, 'Normalization', 'pdf');
% hold on
% plot([0:200],y_pos1_plot,'r-',x_aKDE_pos,y_aKDE_pos,'k-')
% legend('Empirical','GPD fit','aKDE fit')
% title('Positive exceedences')
% xlabel(['x(x>u) [', char(181),'m/m]' ])
% ylabel('f(x)')
% axis([0 150 0 0.06])
% % % 
% figure(30)
% title('Positive exceedances')
% set(gcf,'color','w');
% subplot(2,1,1);
% hist(replEsts1(:,1));
% xlabel('k estimate')
% ylabel('Bootstrap number [-]')
% subplot(2,1,2);
% hist(replEsts1(:,2));
% xlabel('Sigma estimate')
% ylabel('Bootstrap number [-]')
% 
% figure(31)
% title('Negative exceedances')
% set(gcf,'color','w');
% subplot(2,1,1);
% hist(replEsts2(:,1));
% xlabel('k estimate')
% ylabel('Bootstrap number [-]')
% subplot(2,1,2);
% hist(replEsts2(:,2));
% xlabel('Sigma estimate')
% ylabel('Bootstrap number [-]')
% 
% figure(32)
% title('Positive exceedances')
% set(gcf,'color','w');
% subplot(2,1,1);
% b=qqplot(replEsts1(:,1));
% set(b(1),'marker','x');
% set(b(3),'linestyle','--','color','k');
% legend([b(3) b(1)],'Fit','Data')
% xlabel('X quantiles')
% ylabel('Y Quantiles')
% subplot(2,1,2);
% d=qqplot(log(replEsts1(:,2)));
% set(d(1),'marker','x');
% set(d(3),'linestyle','--','color','k');
% legend([d(3) d(1)],'Fit','Data')
% xlabel('X quantiles')
% ylabel('Y Quantiles')
% % 
% figure(33)
% title('Negative exceedances')
% set(gcf,'color','w');
% subplot(2,1,1);
% b=qqplot(replEsts2(:,1));
% set(b(1),'marker','x');
% set(b(3),'linestyle','--','color','k');
% legend([b(3) b(1)],'Fit','Data')
% xlabel('X quantiles')
% ylabel('Y Quantiles')
% subplot(2,1,2);
% d=qqplot(log(replEsts2(:,2)));
% set(d(1),'marker','x');
% set(d(3),'linestyle','--','color','k');
% legend([d(3) d(1)],'Fit','Data')
% xlabel('X quantiles')
% ylabel('Y Quantiles')

% figure(34)
% set(gcf,'color','w');
% h = histogram(Exc_x_neg,20, 'Normalization', 'pdf');
% hold on
% plot([0:200],y2_neg1_gpd_plot,'r-',x_aKDE_neg,y_aKDE_neg,'k-')
% title('Negative exceedences')
% legend('Empirical','GPD fit','aKDE fit')
% xlabel(['x(x<u) [', char(181),'m/m]' ])
% ylabel('f(x)')
% axis([0 150 0 0.06])


end






