function [D_rel_raw,D_tot,S,N] = cyclestodamage(S,N,s_range,n_range,E); 

    
for j = 1:length(N)
    id = (N{j}<=0);              % Identify position where no cycles are known
    N{j}(id)=[];%eps;%[];
    S{j}(id)=[]; % remove zero's from data 
end

% Only use for N_EVT_ext = 50;
% figure(545)
% set(gcf,'color','w');
% plot(S{1}, N{1},'k-',...
%      S{2}, N{2},'b-',...
%      S{4}, N{4},'m-','LineWidth',1.1)
% set(gca, 'YScale', 'log')
% legend('Original','50x POT','validation')
% axis([0 500 1e-2 2e4])
% ylabel('Number of cycles [-]')
% xlabel(['Strain range ', '[' , char(181),'m/m]'])

figure(52)
set(gcf,'color','w');
plot(S{1}, N{1},'k-',...
    S{2},N{2},'b-',...
    S{3},N{3},'r-',...
    S{4},N{4},'m-',...
    a,b,'g-','LineWidth',1.1)
set(gca, 'YScale', 'log')
legend('Original','10x POT','10x PSD','validation','Lim RFM')
axis([0 500 1e-2 2e4])
ylabel('Number of cycles [-]')
xlabel(['Strain range ', '[' , char(181),'m/m]'])

for j=1:length(N);

          s{j} = (S{j}.*E)./1e12;                          % sigma = epsilon * elasticity modulus 
          s{j}  =   s{j}/2;                                % Damage is from amplitude and not range
          D_raw{j}= N{j}./interp1(s_range,n_range,s{j});   % Damage per cycle increment in signal
          Di_raw{j}   = cumsum(D_raw{j});             % raw cumulative damage calculation per increment
          D_tot(j)   = Di_raw{j}(end); 
end

for k=1:length(D_raw)
D_rel_raw{k} = Di_raw{k}./ D_tot(4);   % Mileage extrapolation and normalize
end

% figure(70)
% plot(N{1},s{1},N{2},s{2},N{4},s{4})
% axis([1e-2 1e12 1e0 s_range(end)+50])
% set(gca, 'XScale', 'log')
% xlabel('Number of cycles to failure [-]')
% ylabel('Stress [Mpa]')

figure(72) 
set(gcf,'color','w');
p=plot(S{1},D_rel_raw{1},'k-',...
       S{2},D_rel_raw{2},'b-',...
       S{3},D_rel_raw{3}*1e-15,'g-',...
       S{4},D_rel_raw{4},'m-','LineWidth',1.1);
axis([0 500 0 1.1])
xlabel(['Strain range ', '[' , char(181),'m/m]'])
ylabel('Normalized cumulative damage [-]')
legend('Original','POT','Lim RFM','Val')
yline(1,'--k','HandleVisibility','off')


end 