#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Nov 17 14:12:28 2023
Predict Relative Front Wheel Load (RFWL, i.e., load distribution) during wheelchair propulsion
@author: L.H.A. Heringa & M.P. van Dijk
"""

import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
from keras.layers import Dense, LSTM, Dropout, GaussianNoise
from keras.callbacks import EarlyStopping, ModelCheckpoint
from keras.metrics import MeanAbsoluteError
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
from keras.optimizers import Adam
from sklearn.utils import shuffle
from keras.utils.vis_utils import plot_model as pm
from datetime import datetime
from keras.models import load_model


# Run functions
def standardize(signal):
    size_temp = np.asarray(signal.shape)
    size = size_temp[0].item()
    standarized_signal =np.zeros((size,3))
    i = 0
    while i < 3:
        z_score = (signal[:,i]-mean[i])/std[i]
        standarized_signal[:,i] = z_score
        i = i + 1
    return standarized_signal

def load(x_data, num_steps):
    #x_data = data.iloc[:,[2,3,4]].to_numpy()
 
    X = list() #reshape the 2d data into 3d sliding window shape

    for i in range(x_data.shape[0]):
        end_ix = i + num_steps # compute a new (sliding window) index
        
        if end_ix >= x_data.shape[0]: # if index is larger than the size of the dataset, stop
            break
        seq_X = x_data[i:end_ix] # Get a sequence of data for x
        X.append(seq_X)
        
    x_array = np.array(X)
    return x_array


# Load model
model = '/Users/mvandijk3/Documents/PhD WheelPower/Objective 7 PredictForce/Data en scripts/python goed/Thesis_L.Heringa/Python - machine learning/5.Test Final model/final_lstm.h5'

# Load model
df_full = pd.read_csv(r'/Users/mvandijk3/Documents/PhD WheelPower/Objective 6_WRR/Paper7_WheelchairTennis/SprintData_22-Nov-2023.csv')

df = df_full[["samples","time","v_wc", "a_wc", "trunk_acc_3"]]

df = df_full[["samples","time","v_wc", "a_wc", "trunk_acc_3"]]
mean = np.mean(df, axis=0)
std = np.std(df, axis=0)

df_new = df.to_numpy()
mean = np.mean(df_new, axis=0)
std = np.std(df_new, axis=0)
df_new = standardize(df_new[:,2:5])

# Run and plot LSTM model
num_steps = 20
X = load(df_new,num_steps)
lstm = load_model(model)
y = lstm.predict(X)
plt.plot(y)

# Add force output to initial dataset
RFWL_Output = pd.DataFrame(y)

df_full_new = df_full[num_steps:df_full.shape[0]]
df_full_new['RFWL_Output'] = y

# Export dataset to csv
df_full_new.to_csv('/Users/mvandijk3/Documents/PhD WheelPower/Objective 6_WRR/Paper7_WheelchairTennis/force_output_withfeatures_csv_20231122.csv')


