from DefAnalysisLib import *
import cv2 as cv
from timeit import default_timer as timer
from ast import literal_eval
import numpy as np
import copy


if __name__ == '__main__':

    base_cfg = Utils.cfg()
    print('Start')
    algolist = ['all of the below','defectSegGradThresholding', 'cellStdThresholding', 'imgProjection', 'otsuThresholding', 'adaptiveThresholding',
                'gaborFilterSegmentation', 'morphologicalSegmentation']
    print('The following algorithms can be analysed:\n#  algorithm\n')
    for i in range(len(algolist)):
        print('{}: {}'.format(i, algolist[i]))
    print('\n')

    algolist = [algolist[num] for num in list(map(int,(input('Enter your defectdetectionalgorithms of choice: ').split(',')))) if num != 0]
    print('\n')


    if len(algolist) == 0:
       # algolist = ['defectSegGradThresholding', 'cellStdThresholding',
       #             'imgProjection', 'otsuThresholding', 'adaptiveThresholding',
        #            'gaborFilterSegmentation', 'morphologicalSegmentation']

        algolist = ['defectSegGradThresholding',
                    'imgProjection', 'adaptiveThresholding',
                    'morphologicalSegmentation']

    images = {}
    configData = configHandler('config.ini', 'r')



    labeledImg = readImagesdWithLabelData(configData)

    labeledImg = Utils.addNoise(labeledImg, configData)


    allDefects = extractAllDefcropedImg(configData, labeledImg)


    images = extractAllDefImgs(labeledImg, configData)


    #Preprocessing
    preProcImgs = imgPreProcessing(images, configData)

    print('Length: ', len(preProcImgs), '\n')

    print('Beginning Error Detection...\n')
    reports = []
    for c, algo in enumerate(algolist):

        print('...with {} and...\n'.format(algo))
        start = timer()
        temp = vars()[algolist[c]]
        threshMatDict, rep = imgDictToImgWrapper(preProcImgs, vars()[algo], configData, timing=True)

        threshMatDict = imgDictToImgWrapper(threshMatDict, maskThresholding, configData)
        calctime = timer() - start
        rep["calctime"] =  calctime
        bondBoxDict = imgDictToImgWrapper(threshMatDict, mergeDefectAreas, configData)
        ovlp = segmentComp(labeledImg, bondBoxDict, configData)

        vars()[algo] = utils.DefDet(configData, algo, allDefects, images, labeledImg, preProcImgs, bondBoxDict, ovlp, threshMatDict, rep)
        reports.append(vars()[algo])
        vars()[algolist[c]] = temp

        if literal_eval(configData['Defect Segmentation: gridBasedAlgoHandler']['doGridBased']) == True:
            print('...with grid based {} and...\n'.format(algo))
            start = timer()

            grid_threshMatDict, grid_rep = gridBasedAlgoHandler(preProcImgs, vars()[algolist[c]], configData, timing=True)
            grid_threshMatDict = imgDictToImgWrapper(grid_threshMatDict, maskThresholding, configData)

            grid_bondBoxDict = imgDictToImgWrapper(grid_threshMatDict, mergeDefectAreas, configData)
            grid_ovlp = segmentComp(labeledImg, grid_bondBoxDict, configData)
            grid_calctime = timer() - start
            grid_rep["calctime"] =  calctime


            vars()[algo] = utils.DefDet(configData, 'grid ' + algo, allDefects, images, labeledImg, preProcImgs, grid_bondBoxDict, grid_ovlp, grid_threshMatDict, grid_rep)
            reports.append(vars()[algo])

        else: pass


    print('done.')

    img_text, all_plots, names, newreport, comparison, f = report(reports)


    print('End!')

def preparation(cfg):

    images = {}
    configData = cfg.base_config #non variable (base) config

    #load input data, add noise etc

    labeledImg = readImagesdWithLabelData(configData)
    labeledImg = Utils.addNoise(labeledImg, configData)
    allDefects = extractAllDefcropedImg(configData, labeledImg)
    images = extractAllDefImgs(labeledImg, configData)

    #Preprocessing
    preProcImgs = imgPreProcessing(images, cfg)
    print('Length: ', len(preProcImgs), '\n')

    return(images, labeledImg, allDefects, preProcImgs)

def choose_algo():
    """
    Function allows for manual choosing of defect detection algorithms
    """

    print('Start')
    algolist = ['all of the below','defectSegGradThresholding', 'cellStdThresholding', 'imgProjection', 'otsuThresholding', 'adaptiveThresholding',
                'gaborFilterSegmentation', 'morphologicalSegmentation']
    print('The following algorithms can be analysed:\n#  algorithm\n')
    for i in range(len(algolist)):
        print('{}: {}'.format(i, algolist[i]))
    print('\n')

    algolist = [algolist[num] for num in list(map(int,(input('Enter your defectdetectionalgorithms of choice: ').split(',')))) if num != 0]
    print('\n')


    if len(algolist) == 0:
       # algolist = ['defectSegGradThresholding', 'cellStdThresholding',
       #             'imgProjection', 'otsuThresholding', 'adaptiveThresholding',
        #            'gaborFilterSegmentation', 'morphologicalSegmentation']

        algolist = ['defectSegGradThresholding',
                    'imgProjection', 'adaptiveThresholding',
                    'morphologicalSegmentation']
    return(algolist)

def pointer(name):
    functions = {'defectSegGradThresholding': DefectSegmentation.defectSegGradThresholding,
                 'cellStdThresholding': DefectSegmentation.cellStdThresholding,
                 'imgProjection': DefectSegmentation.imgProjection,
                 'otsuThresholding': DefectSegmentation.otsuThresholding,
                 'adaptiveThresholding': DefectSegmentation.adaptiveThresholding,
                 'gaborFilterSegmentation': DefectSegmentation.gaborFilterSegmentation,
                 'morphologicalSegmentation': DefectSegmentation.morphologicalSegmentation,
                 }
    return(functions[name])

def defect_detection(cfg, allDefects, images, labeledImg, preProcImgs):
    """
    Function takes input images, labels and Utils.cfg instances and evaluates their performance

    @param cfg: instance of Utils.cfgm contains all settings for evaluating
    @param allDefects (dict):  contains the defect types and positions
    @param images (dict):  contains their images
    @param labeledImg (dict): contains images with errors labeled and positions
    @param preProcImgs (dict): contains images preprocessed images

    returns:

    """



    reports = []
    configData = cfg.base_config


    if literal_eval(configData['Defect Segmentation: gridBasedAlgoHandler']['doGridBased']) == False:
        algo = vars(DefectSegmentation)[cfg.algo_name]
        print("std", cfg.algo_name)
        start = timer()

        threshMatDict, rep = imgDictToImgWrapper(preProcImgs, algo, configData, timing=True)

        threshMatDict = imgDictToImgWrapper(threshMatDict, maskThresholding, configData)
        calctime = timer() - start
        rep["calctime"] =  calctime
        bondBoxDict = imgDictToImgWrapper(threshMatDict, mergeDefectAreas, configData)
        ovlp = segmentComp(labeledImg, bondBoxDict, configData)


        report = Utils.DefDet(cfg, cfg.algo_name, allDefects, images, labeledImg, preProcImgs, bondBoxDict, ovlp, threshMatDict, rep)
        report.report_on(cfg.criterion)


    if literal_eval(configData['Defect Segmentation: gridBasedAlgoHandler']['doGridBased']) == True:
        algo_name = cfg.algo_name[5:]
        #cfg.algo_name = algo_name 
        algo = vars(DefectSegmentation)[algo_name]

        start = timer()

        grid_threshMatDict, grid_rep = gridBasedAlgoHandler(preProcImgs, algo, configData, timing=True)
        grid_threshMatDict = imgDictToImgWrapper(grid_threshMatDict, maskThresholding, configData)

        grid_bondBoxDict = imgDictToImgWrapper(grid_threshMatDict, mergeDefectAreas, configData)
        grid_ovlp = segmentComp(labeledImg, grid_bondBoxDict, configData)
        grid_calctime = timer() - start
        grid_rep["calctime"] =  grid_calctime
        report = Utils.DefDet(cfg, algo_name, allDefects, images, labeledImg, preProcImgs, grid_bondBoxDict, grid_ovlp, grid_threshMatDict, grid_rep)
        report.report_on(cfg.criterion)



    else: pass

    return report

def find_best(reports, mode = 'topAlgorithms'):
    """
    Function to find the best performing version of all the tested configurations and algorithms

    @param reports: instances of Utils.defdet(), contains all the necessary data
    @param (str) mode: 'topAlgorithms' --> find the best of each algorithm respectivly, singleBest --> find the overall best

    returns: list with all the best.

    """

    players = {}
    winners = {} #best performing measured in passed criterion
    criteria = {'calctimes': "low",
                'defPosAcc': "high",
                'falseNeg': {"rate": ["low", 1], "num": ["low", 2]},
                'falsePos': {"area": ["low", 2], "rate": ["low", 1], "num": ["low", 1]},
                'detAcc': "high",
                'defExcssAcc': {"mean": ["high", 0], "std": ["low", 1]},
                'defOvlpAcc': {"mean": ["high", 0], "std": ["low", 1]},
                 }

    #loop over all the reports
    for defdet in reports:
        criterion = defdet.cfg.criterion

        #get the current value and the algorithms name
        if isinstance(criterion, str): #check if assesment criterion is single value or nested value

            current = np.average( list(defdet.rep[criterion].values()) )
            target_property = criteria[criterion] #is a higher or lower value better?
        if isinstance(criterion, list):
            target_property = criteria[criterion[0]][criterion[1]][0]
            #get the values nested in lists and dictionary
            current = [entry[criteria[ criterion[0] ][criterion[1]][1]] for entry in defdet.rep[criterion[0]].values() if isinstance(entry, float) == False]

            current = np.average(current[:-1])

        if mode == "topAlgorithms":
            name = defdet.cfg.algo_name
        if mode == 'singleBest':
            name = "Best"

        if name in list(players.keys()):

            if (target_property == 'low' and players[name] >= current) == True: #lowest?
                players[name] = copy.copy(current)
                winners[name] = defdet

            elif (target_property == "high" and players[name] <= current) == True: #highest?
                players[name] = copy.copy(current)
                winners[name] = defdet

        else:

            players[name] = copy.copy(current)
            winners[name] = defdet

    return(winners)
