# Run system commands
from subprocess import run
# Remove files
from os import remove
# Turn directories into zips
from shutil import make_archive, rmtree, copytree

archiveName = "javabip-meets-vercors-artefact"
archivePath = archiveName + ".zip"
compiledPath = "compiled"
artefactAbstractPath = "artefactAbstract.txt"
temporaryPath = "/tmp/artefactScratchFolder"

# Remove a pre-existing archive if it exists
# Don't want to accidentally merge zips or something
try:
    remove(archivePath)
except FileNotFoundError:
    print("artefact zip not present; moving on")

# Remove the compiled files if they exist
# Intermediate compilation files not meant to be included in final artefact
try:
    rmtree(compiledPath)
except FileNotFoundError:
    print("compiled files folder not present; moving on")

try:
    rmtree(temporaryPath)
except FileNotFoundError:
    pass

# Remove sha256sum text from artefact abstract.
# This is to ensure the artefact does not contain a random checksum
# After zipping we add it back in
with open(artefactAbstractPath, "r") as f:
    artefactAbstract = f.read()

checksumIndex = artefactAbstract.find("SHA256")
if checksumIndex == -1:
    print("SHA256 not found in artefactAbstract.txt; appending checksum to end")
    checksumIndex = len(artefactAbstract)
else:
    # If we find the sha256 checksum, remove it from the string
    # This is easy because it's always a line at the end starting with "SHA256"
    artefactAbstract = artefactAbstract[:checksumIndex]

with open(artefactAbstractPath, "w") as f:
    f.write(artefactAbstract)

# Copy everything to a temporary scratch folder. This is needed because otherwise the input folder and output location overlap
# This will cause the final zip file to also be added _to the zip_. By having the scratch space be someplace else this is avoided
copytree("./", temporaryPath)

# Package whole dir into zip
make_archive(archiveName, "zip", temporaryPath)

# Get sha256sum 
sha256Process = run(["sha256sum", archivePath], capture_output=True)
# Do stripping and splitting here because format of sha256sum is "checksum space space filename newline"
sha256 = sha256Process.stdout.decode("utf8").strip().split("  ")[0]

# Print checksum for completeness
print(sha256)

with open(artefactAbstractPath, "w") as f:
    f.write(artefactAbstract + f"SHA256 checksum of zip file: {sha256}")

print("artefactAbstract.txt now also contains the hash of the zip. Don't forget to copy it!'")
