#!/usr/bin/env bash

# exit when any command fails
set -e

# print all executed commands
set -x

mkdir -p binaries

# Echo maven version
mvn --version
# Echo java version
java -version

cd compiled

# JavaBDD
cd javabdd/JavaBDD
mvn install
cd ../../

# JavaBIP Core
cd javabip-core
mvn install
cd ..

# JavaBIP engine
cd javabip-engine
mvn install
cd ..

cd ..

# Casino case study: broken
cd casinoCaseStudyBroken
mvn package
mvn assembly:single
cp target/*.jar ../binaries
rm -rf target/
cd ..

# Casino case study: adjusted
cd casinoCaseStudyAdjusted
mvn package
mvn assembly:single
cp target/*.jar ../binaries
rm -rf target/
cd ..
