#!/usr/bin/env bash

rm -rf sources
mkdir sources

cd sources

git clone https://github.com/lsafina/javabdd.git
cd javabdd/
rm -rf .git/
cd ..

git clone https://github.com/lsafina/javabip-core.git
cd javabip-core
git checkout fase
rm -rf .git/
cd ..

git clone https://github.com/lsafina/javabip-engine.git
cd javabip-engine
git checkout fase
rm -rf .git/
cd ..

git clone https://github.com/utwente-fmt/vercors.git vercors-javabip
cd vercors-javabip
git checkout ast-javabip
rm -rf .git/
# Little blurb needed because vercors won't compile without a functional .git folder and a commit -.-
# We also do not want to commit the original .git repo. Because it is huge
git config --global user.email a@b.com
git config --global user.name "a b"
git init
touch temp.txt
git add temp.txt
git commit -m "initial commit"
cd ..

cd ..

rm -rf casinoCaseStudyBroken
rm -rf casinoCaseStudyAdjusted
cp -r sources/vercors-javabip/examples/concepts/javabip/casinoBroken casinoCaseStudyBroken
cp -r sources/vercors-javabip/examples/concepts/javabip/casinoAdjusted casinoCaseStudyAdjusted

git diff --no-index casinoCaseStudyBroken casinoCaseStudyAdjusted > casinoCaseStudyDiff.txt

rm -rf compiled
cp -r sources compiled

pandoc README.md -o README.pdf
pandoc AUTHORS_README.md -o AUTHORS_README.pdf

