from multiprocessing import Pool
import os
import pandas as pd
import datetime
import pickle

import pyNetLogo
from SALib.sample import saltelli

def initializer(modelfile):
    '''initialize a subprocess
    
    Parameters
    ----------
    modelfile : str
    
    '''
    
    # we need to set the instantiated netlogo
    # link as a global so run_simulation can
    # use it
    global netlogo
    
    netlogo = pyNetLogo.NetLogoLink(gui=False)
    netlogo.load_model(modelfile)


def run_simulation(experiment):
    '''run a netlogo model
    
    Parameters
    ----------
    experiments : dict
    
    '''
    
    #Set the input parameters
    for key, value in experiment.items():
        if key == 'random-seed':
            #The NetLogo random seed requires a different syntax
            netlogo.command('random-seed {}'.format(value))
        else:
            #Otherwise, assume the input parameters are global variables
            netlogo.command('set {0} {1}'.format(key, value))

    netlogo.command('setup')  

    counts = netlogo.repeat_report(['number_of_values',
                                    'variance_importance_of_values',
                                    'number_of_technologies',
                                    'number_of_unacceptable_technologies',
                                    'number_of_moral_problems',
                                    'number_of_perceived_moral_problems',
                                    'number_of_unperceived_moral_problems',
                                    'number_of_moral_problems_emerged',
                                    'number_of_moral_problems_discovered_through_threshold',
                                    'number_of_moral_problems_discovered_through_values',
                                    'severity_of_moral_problems',
                                    'average_duration_problem_solving',
                                    'moral_revolution_occured',
                                    'count_moral_revolutions',
                                    'count_lock_in_situations',
                                    'average_duration_lock_in',
                                    'total_duration_lock_in',
                                    'variance_duration_lock_in',
                                    'average_count_values_when_moral_revolution',
                                    'average_count_moral_problems_when_moral_revolution',
                                    'average_count_new_values_when_moral_revolution',
                                    'average_count_new_moral_problems_when_moral_revolution',
                                    
    
                                        ], 20000)

    results = pd.Series([counts['number_of_values'].values.mean(),
                         counts['number_of_values'].values.var(),
                         counts['variance_importance_of_values'].values.var(),
                         counts['number_of_technologies'].values.mean(),
                         counts['number_of_technologies'].values.var(),
                         counts['number_of_unacceptable_technologies'].values.mean(),
                         counts['number_of_unacceptable_technologies'].values.var(),
                         counts['number_of_moral_problems'].values.mean(),
                         counts['number_of_perceived_moral_problems'].values.mean(),
                         counts['number_of_unperceived_moral_problems'].values.mean(),
                         counts['number_of_moral_problems_emerged'].iat[-1],
                         counts['number_of_moral_problems_discovered_through_threshold'].iat[-1],
                         counts['number_of_moral_problems_discovered_through_values'].iat[-1],
                         counts['severity_of_moral_problems'].values.sum(),
                         counts['average_duration_problem_solving'].iat[-1],
                         counts['moral_revolution_occured'].iat[-1],
                         counts['count_moral_revolutions'].iat[-1],
                         counts['count_lock_in_situations'].iat[-1],
                         counts['average_duration_lock_in'].iat[-1],
                         counts['total_duration_lock_in'].iat[-1],
                         counts['variance_duration_lock_in'].iat[-1],
                         counts['average_count_values_when_moral_revolution'].iat[-1],
                         counts['average_count_moral_problems_when_moral_revolution'].iat[-1],
                         counts['average_count_new_values_when_moral_revolution'].iat[-1],
                         counts['average_count_new_moral_problems_when_moral_revolution'].iat[-1],

    
                             ],
                             index=['average_number_of_values', 
                                    'variance_number_of_values',
                                    'variance_importance_of_values',
                                    'number_of_technologies',
                                    'variance_number_of_technologies',
                                    'number_of_unacceptable_technologies',
                                    'variance_number_of_unacceptable_technologies',
                                    'average_number_of_moral_problems',
                                    'average_number_of_perceived_moral_problems',
                                    'average_number_of_unperceived_moral_problems',
                                    'number_of_moral_problems_emerged',
                                    'number_of_moral_problems_discovered_through_threshold',
                                    'number_of_moral_problems_discovered_through_values',
                                    'total_severity_of_moral_problems',
                                    'average_duration_problem_solving',
                                    'moral_revolution_occured',
                                    'count_moral_revolutions',
                                    'count_lock_in_situations',
                                    'average_duration_lock_in',
                                    'total_duration_lock_in',
                                    'variance_duration_lock_in',
                                    'average_count_values_when_moral_revolution',
                                    'average_count_moral_problems_when_moral_revolution',
                                    'average_count_new_values_when_moral_revolution',
                                    'average_count_new_moral_problems_when_moral_revolution',
                                    ])
    
    return results

uncertainties_names = [
                'random-seed',
                
#                'Value_memory_of_society',             

#                'Openness_to_change',              
                'Propensity_value_dynamism',
                'Propensity_value_adaptation',
                'Propensity_innovation',
                
#                 'max_need_change',

                
                ]

uncertainties_bounds = [
                [1, 100000],
                
                [0, 100],
                
                [0, 100],               
                [0, 1],
                [0, 1],
                [0, 1],
                
                [0.5, 4],

                 ]


model_version = 37

experiment = "Resistance_to_change"

#settings = "high_value_memory"
#settings = "value_memory_50_high_value_memory"
#settings = "value_memory_50_OTC_20_high_value_memory"
#settings = "value_memory_50_MNC_0_high_value_memory"
#settings = "value_memory_50_high_MR_threshold_high_value_memory"
settings = "value_memory_50_OTC_20_new_MR_count_high_value_memory"

#runs = 32
runs = 256

if __name__ == '__main__':
    print("Start time: "+str(datetime.datetime.now()))
    #modelfile = os.path.abspath('./models/ABM_patterns_value_change_'+str(model_version)+'_'+str(experiment)+'.nlogo')
    modelfile = os.path.abspath('./models/ABM_patterns_value_change_'+str(model_version)+'.nlogo')
  
    problem = { 
      'num_vars': len(uncertainties_names),
      'names': uncertainties_names, 
      'bounds': uncertainties_bounds
    }
  
      
    param_values = saltelli.sample(problem, runs, 
                               calc_second_order=True)
#     print(param_values)
      
    # cast the param_values to a dataframe to
    # include the column labels
    experiments = pd.DataFrame(param_values,
                               columns=problem['names'])
    #pd.set_option('display.max_columns', None)
    #print(experiments)
      
    with Pool(7, initializer=initializer, initargs=(modelfile,)) as executor:
        results = []
        for entry in executor.map(run_simulation, experiments.to_dict('records')):
            #print("Step: "+str(datetime.datetime.now()))
            results.append(entry)
        results = pd.DataFrame(results)
       
    experiments.to_pickle("results/Output_file_experiments_"+str(runs)+"_runs_model_version_v"+str(model_version)+'_'+str(experiment)+'_'+str(settings))
    results.to_pickle("results/Output_file_results_"+str(runs)+"_runs_model_version_v"+str(model_version)+'_'+str(experiment)+'_'+str(settings))

    #print(results)        
    print("Experiment finished!")
    print("End time: "+str(datetime.datetime.now()))