%
%Xiang Wang, May 2021
%plot n,k vs lambda, sca, ext, abs
%clear all
%clc
diameter=1:1:1000;%nm
[p,q]=size(diameter);

for j=1:1:q
    [lambda,n,k]=refractiveindexAuNPmultisize(diameter(1,j));
    lambda_vector=lambda;
    n_matrix(j,:)=n;
    k_matrix(j,:)=k;
    j
end

load('nbulk.mat')
load('kbulk.mat')

%plot(lambda,n)
%plot(lambda,k)

nbulk=repmat(n,1000,1);
kbulk=repmat(k,1000,1);

%save('refractiveindexAusimulationdata.mat');
load('refractiveindexAusimulationdata.mat');
%%
figure(1)
[X,Y]=meshgrid(lambda_vector,diameter);
meshc(X,Y,n_matrix)
view(2)
colorbar('eastoutside')
xlabel('wavelength (nm)')
ylabel('diameter of nanoparticle (nm)')
title('refractive index n')
ylim([1,100])
figure(2)
contour(X,Y,n_matrix,'ShowText','on')
colorbar('eastoutside')
xlabel('wavelength (nm)')
ylabel('diameter of nanoparticle (nm)')
title('refractive index n')
ylim([1,100])
figure(3)
[X,Y]=meshgrid(lambda_vector,diameter);
meshc(X,Y,n_matrix)
view(2)
colorbar('eastoutside')
xlabel('wavelength (nm)')
ylabel('diameter of nanoparticle (nm)')
title('refractive index n')
ylim([101,400])
figure(4)
contour(X,Y,n_matrix,'ShowText','on')
colorbar('eastoutside')
xlabel('wavelength (nm)')
ylabel('diameter of nanoparticle (nm)')
title('refractive index n')
ylim([101,400])

figure(5)
[X,Y]=meshgrid(lambda_vector,diameter);
meshc(X,Y,k_matrix)
view(2)
colorbar('eastoutside')
xlabel('wavelength (nm)')
ylabel('diameter of nanoparticle (nm)')
title('refractive index k')
ylim([1,20])
figure(6)
contour(X,Y,k_matrix,'ShowText','on')
colorbar('eastoutside')
xlabel('wavelength (nm)')
ylabel('diameter of nanoparticle (nm)')
title('refractive index k')
ylim([1,20])
figure(7)
[X,Y]=meshgrid(lambda_vector,diameter);
meshc(X,Y,k_matrix)
view(2)
colorbar('eastoutside')
xlabel('wavelength (nm)')
ylabel('diameter of nanoparticle (nm)')
title('refractive index k')
ylim([21,400])
figure(8)
contour(X,Y,k_matrix,'ShowText','on')
colorbar('eastoutside')
xlabel('wavelength (nm)')
ylabel('diameter of nanoparticle (nm)')
title('refractive index k')
ylim([21,400])

figure(9)
plot(lambda,n_matrix(1,:),'b');
hold on;
plot(lambda,n_matrix(10,:),'g');
hold on;
plot(lambda,n_matrix(100,:),'r');
hold on;
maker_idx = 1:100:length(lambda);
plot(lambda,n_matrix(400,:),'k.','MarkerIndices',maker_idx)
xlabel('wavelength (nm)')
title('real part of refractive index of gold NP')
legend('1nm','10nm','100nm','400nm','Location','northwest')

figure(10)
plot(lambda,k_matrix(1,:),'b');
hold on;
plot(lambda,k_matrix(10,:),'g');
hold on;
plot(lambda,k_matrix(100,:),'r');
hold on;
maker_idx = 1:100:length(lambda);
plot(lambda,k_matrix(400,:),'k.','MarkerIndices',maker_idx)
xlabel('wavelength (nm)')
title('imaginary part of refractive index of gold NP')
legend('1nm','10nm','100nm','400nm','Location','northwest')






%%
%
%refractiveindexofmedia=1.33;

lambdamax=1600;
lambdamin=400;
refractiveindexofmedia=sqrt(1+0.6961663.*(lambda./1000).^2./((lambda./1000).^2-0.00684043^2)+0.4079426.*(lambda./1000).^2./((lambda./1000).^2-0.1162414^2)+0.8974794.*(lambda./1000).^2./((lambda./1000).^2-9.896161^2));
figure(100)
plot(lambda,refractiveindexofmedia)
xlabel('Wavelength (nm)')
ylabel('Refractive index (n)')
xlim([200,2000])
title('RI fused silica')

lambdastep=1;
q=(lambdamax-lambdamin)/lambdastep+1;
diametermax=400;
diametermin=1;
diameterstep=1;
p=(diametermax-diametermin)/diameterstep+1;

Qext(1:p,1:q)=0;
Qsca(1:p,1:q)=0;
Qabs(1:p,1:q)=0;
Qb(1:p,1:q)=0;

for ii=1:1:p %diameter
    for jj=1:1:q %wavelength
        x=pi*diameter(1,ii)/lambda(1,jj)*refractiveindexofmedia(1,jj);
        m=(n_matrix(ii,jj)+i*k_matrix(ii,jj))/refractiveindexofmedia(1,jj);
        result=Mie(m,x);
        Qext(ii,jj)=result(1,4);
        Qsca(ii,jj)=result(1,5);
        Qabs(ii,jj)=result(1,6);
        Qb(ii,jj)=result(1,7);
    end
    ii
end

Qextbulk(1:p,1:q)=0;
Qscabulk(1:p,1:q)=0;
Qabsbulk(1:p,1:q)=0;
Qbbulk(1:p,1:q)=0;
for ii=1:1:p %diameter
    for jj=1:1:q %wavelength
        x=pi*diameter(1,ii)/lambda(1,jj)*refractiveindexofmedia(1,jj);
        m=(nbulk(ii,jj)+i*kbulk(ii,jj))/refractiveindexofmedia(1,jj);
        result=Mie(m,x);
        Qextbulk(ii,jj)=result(1,4);
        Qscabulk(ii,jj)=result(1,5);
        Qabsbulk(ii,jj)=result(1,6);
        Qbbulk(ii,jj)=result(1,7);
    end
    ii
end

%save('refractiveindexAusimulationdatafusedsilica400to1600.mat');
load('refractiveindexAusimulationdatafusedsilica400to1600.mat');

figure(11)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
meshc(X,Y,Qext)
view(2)
colorbar('eastoutside')
hc=colorbar;
%title(hc,'%');
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('Qext_n_a_n_o')
figure(21)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:100));
meshc(X,Y,(Qextbulk(1:100,:)-Qext(1:100,:))./Qext(1:100,:)*100)
view(2)
colorbar('eastoutside')
hc=colorbar;
title(hc,'%');
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('(Qext_b_u_l_k-Qext_n_a_n_o)/Qext_n_a_n_o')
%ylim([1,100])
%xlim([300,1000])
figure(22)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:100));
contour(X,Y,(Qextbulk(1:100,:)-Qext(1:100,:))./Qext(1:100,:)*100,[-50,-40,-30,-20,-10,0,10,50,100],'ShowText','on')
colorbar('eastoutside')
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('(Qext_b_u_l_k-Qext_n_a_n_o)/Qext_n_a_n_o')
figure(12)
%contour(X,Y,Qext,'ShowText','on')
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
contour(X,Y,Qext(1:p,:),[0.002,0.01,0.1,0.5,1,2,3,4,5,7],'ShowText','on')
colorbar('eastoutside')
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('Qext_n_a_n_o')


figure(13)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
meshc(X,Y,Qsca)
view(2)
colorbar('eastoutside')
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('Qsca_n_a_n_o')

figure(23)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:100));
meshc(X,Y,(Qbbulk(1:100,:)-Qb(1:100,:))./Qb(1:100,:)*100)
view(2)
colorbar('eastoutside')
hc=colorbar;
title(hc,'%');
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('(Qb_b_u_l_k-Qb_n_a_n_o)/Qb_n_a_n_o')

figure(24)
contour(X,Y,(Qbbulk(1:100,:)-Qb(1:100,:))./Qb(1:100,:)*100,[-50,-40,-30,-20,-10,0,10,100],'ShowText','on')
colorbar('eastoutside')
hc=colorbar;
title(hc,'%');
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('(Qb_b_u_l_k-Qb_n_a_n_o)/Qb_n_a_n_o')

figure(14)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
%contour(X,Y,Qsca,'ShowText','on')
contour(X,Y,Qsca,[0.002,0.01,0.1,0.5,1,2,3,4,5,7],'ShowText','on')
colorbar('eastoutside')
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('Qsca_n_a_n_o')

figure(15)
meshc(X,Y,Qabs)
view(2)
colorbar('eastoutside')
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('Qabs_n_a_n_o')

figure(25)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:100));
meshc(X,Y,(Qabsbulk(1:100,:)-Qabs(1:100,:))./Qabs(1:100,:)*100)
view(2)
colorbar('eastoutside')
hc=colorbar;
title(hc,'%');
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('(Qabs_b_u_l_k-Qabs_n_a_n_o)/Qabs_n_a_n_o')

figure(26)
contour(X,Y,(Qabsbulk(1:100,:)-Qabs(1:100,:))./Qabs(1:100,:)*100,[-50,-40,-30,-20,-10,0,10,50,100],'ShowText','on')
colorbar('eastoutside')
hc=colorbar;
title(hc,'%');
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('(Qabs_b_u_l_k-Qabs_n_a_n_o)/Qabs_n_a_n_o')

figure(16)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
%contour(X,Y,Qsca,'ShowText','on')
contour(X,Y,Qabs,[0.002,0.01,0.05,0.1,0.5,1,2,3,4,5,7],'ShowText','on')
colorbar('eastoutside')
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('Qabs_n_a_n_o')

figure(53)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
meshc(X,Y,Qb(1:p,:))
view(2)
colorbar('eastoutside')
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('Qb_n_a_n_o')

figure(54)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
contour(X,Y,Qb,[0.01,1,4,5,8],'ShowText','on')
colorbar('eastoutside')
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('Qb_n_a_n_o')

figure(17)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
meshc(X,Y,Qsca(1:p,:)./Qext(1:p,:))
view(2)
colorbar('eastoutside')
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('Qsca_n_a_n_o/Qext_n_a_n_o')

figure(18)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:100));
%contour(X,Y,Qsca./Qext,'ShowText','on')
contour(X,Y,Qsca(1:100,:)./Qext(1:100,:),[0.002,0.01,0.05,0.1,0.5,1,2,3,4,5,7],'ShowText','on')
colorbar('eastoutside')
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('Qsca_n_a_n_o/Qext_n_a_n_o')


figure(19)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
meshc(X,Y,Qabs(1:p,:)./Qext(1:p,:))
view(2)
colorbar('eastoutside')
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('Qabs_n_a_n_o/Qext_n_a_n_o')

figure(20)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
contour(X,Y,Qabs(1:p,:)./Qext(1:p,:),[0.1,0.2,0.5,0.9,0.99],'ShowText','on')
colorbar('eastoutside')
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('Qabs_n_a_n_o/Qext_n_a_n_o')

figure(51)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
meshc(X,Y,Qb(1:p,:)./Qext(1:p,:))
view(2)
colorbar('eastoutside')
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('Qb_n_a_n_o/Qext_n_a_n_o')

figure(52)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
%contour(X,Y,Qb(1:100,:)./Qext(1:100,:),[0.1,0.5,0.6,0.7,0.8,0.9],'ShowText','on')
contour(X,Y,Qb(1:p,:)./Qext(1:p,:),[0.1,1,1.5,1.7],'ShowText','on')
colorbar('eastoutside')
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('Qb_n_a_n_o/Qext_n_a_n_o')

figure(333)
subplot(2,2,1)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
meshc(X,Y,Qb(1:p,:))
view(2)
colorbar('eastoutside')
xlabel({'Wavelength (nm)','(a)'})
ylabel('Diameter of NP (nm)')
title('Qb_n_a_n_o')

subplot(2,2,2)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
meshc(X,Y,Qext)
view(2)
colorbar('eastoutside')
hc=colorbar;
%title(hc,'%');
xlabel({'Wavelength (nm)','(b)'})
ylabel('Diameter of NP (nm)')
title('Qext_n_a_n_o')

subplot(2,2,3)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
meshc(X,Y,Qb(1:p,:)./Qext(1:p,:))
view(2)
colorbar('eastoutside')
xlabel({'Wavelength (nm)','(c)'})
ylabel('Diameter of NP (nm)')
title('Qb_n_a_n_o/Qext_n_a_n_o')

subplot(2,2,4)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
meshc(X,Y,Qabs(1:p,:)./Qext(1:p,:))
view(2)
colorbar('eastoutside')
xlabel({'Wavelength (nm)','(d)'})
ylabel('Diameter of NP (nm)')
title('Qabs_n_a_n_o/Qext_n_a_n_o')
%%
% combine fig 22,24,26
figure(222)
subplot(1,3,1)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:100));
contour(X,Y,(Qbbulk(1:100,:)-Qb(1:100,:))./Qb(1:100,:)*100,[-50,-40,-30,-20,-10,0,10,100],'ShowText','on')
xlabel({'Wavelength (nm)','(a)'})
ylabel('Diameter of nanoparticle (nm)')
title('(Qb_b_u_l_k-Qb_n_a_n_o)/Qb_n_a_n_o')

subplot(1,3,2)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:100));
contour(X,Y,(Qextbulk(1:100,:)-Qext(1:100,:))./Qext(1:100,:)*100,[-50,-40,-30,-20,-10,0,10,100],'ShowText','on')
xlabel({'Wavelength (nm)','(b)'})
ylabel('Diameter of nanoparticle (nm)')
title('(Qext_b_u_l_k-Qext_n_a_n_o)/Qext_n_a_n_o')

subplot(1,3,3)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:100));
contour(X,Y,(Qabsbulk(1:100,:)-Qabs(1:100,:))./Qabs(1:100,:)*100,[-50,-40,-30,-20,-10,0,10,100],'ShowText','on')
xlabel({'Wavelength (nm)','(c)'})
ylabel('Diameter of nanoparticle (nm)')
title('(Qabs_b_u_l_k-Qabs_n_a_n_o)/Qabs_n_a_n_o')

%%

for j=1:1:p
    QbD(j,:)=Qb(j,:)./(j);
end
for j=1:1:p
    QextD(j,:)=Qext(j,:)./(j);
end

figure(55)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
surfc(X,Y,3/2*QbD(1:p,:)*10^6)
shading interp 
view(2)
colorbar('eastoutside')
hc=colorbar;
ylabel(hc,'mm^-^1');
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('3Qb_n_a_n_o/2D')

figure(56)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
%contour(X,Y,Qb(1:100,:)./Qext(1:100,:),[0.1,0.5,0.6,0.7,0.8,0.9],'ShowText','on')
contour(X,Y,3/2*QbD(1:p,:)*10^6,[1,100,1000,10000,50000],'ShowText','on')
colorbar('eastoutside')
hc=colorbar;
ylabel(hc,'mm^-^1');
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('3Qb_n_a_n_o/2D')

figure(57)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
surfc(X,Y,2*log(2)/3./QextD(1:p,:)*10^(-6))
%surfc(X,Y,QextD(1:p,:))
shading interp 
view(2)
colorbar('eastoutside')
hc=colorbar;
ylabel(hc,'mm');
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('2Dln2)/(3Qext)')

figure(58)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
%contour(X,Y,Qb(1:100,:)./Qext(1:100,:),[0.1,0.5,0.6,0.7,0.8,0.9],'ShowText','on')
contour(X,Y,2*log(2)/3./QextD(1:p,:)*10^(-6),[0.000002,0.000002,0.00002,0.0002,0.002],'ShowText','on')
colorbar('eastoutside')
hc=colorbar;
ylabel(hc,'mm');
xlabel('Wavelength (nm)')
ylabel('Diameter of NP (nm)')
title('2Dln2)/(3Qext)')

figure(444)
subplot(2,2,1)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
surfc(X,Y,sqrt(3/2*QbD(1:p,:)*10^6))
shading interp 
view(2)
colorbar('eastoutside')
hc=colorbar;
title(hc,'mm^-^1^/^2');
xlabel({'Wavelength (nm)','(a)'})
ylabel('Diameter of NP (nm)')
title('$ \sqrt{\mu_b}/\sqrt{\rho}$','interpreter','latex')
axis square

subplot(2,2,3)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
surfc(X,Y,2*log(2)/3./QextD(1:p,:)*10^(-6))
%surfc(X,Y,QextD(1:p,:))
shading interp 
view(2)
colorbar('eastoutside')
hc=colorbar;
title(hc,'mm');
xlabel({'Wavelength (nm)','(c)'})
ylabel('Diameter of NP (nm)')
title('$ l_{depth}\rho$','interpreter','latex')
axis square

subplot(2,2,2)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
%contour(X,Y,Qb(1:100,:)./Qext(1:100,:),[0.1,0.5,0.6,0.7,0.8,0.9],'ShowText','on')
contour(X,Y,sqrt(3/2*QbD(1:p,:)*10^6),[1,10,100],'ShowText','on')
xlabel({'Wavelength (nm)','(b)'})
ylabel('Diameter of NP (nm)')
title('$ \sqrt{\mu_b}/\sqrt{\rho}$','interpreter','latex')
axis square

subplot(2,2,4)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
%contour(X,Y,Qb(1:100,:)./Qext(1:100,:),[0.1,0.5,0.6,0.7,0.8,0.9],'ShowText','on')
contour(X,Y,2*log(2)/3./QextD(1:p,:)*10^(-6),[0.00002,0.0002,0.002],'ShowText','on')
xlabel({'Wavelength (nm)','(d)'})
ylabel('Diameter of NP (nm)')
title('$ l_{depth}\rho$','interpreter','latex')
axis square

%1201 means the position of 1550nm wavelength
%%
row=1201;
%10nm diameter
D=10;%nm
deltaz=2*log(2)*1.55^2/pi/0.060/refractiveindexofmedia(1,row)
z=0:deltaz:163*deltaz;
tho=10^(-6);
mub=tho*3/2/D*Qb(D,row)*10^3*(1-cos(0.0267))*2*pi;
mut=tho*3/2/D*Qext(D,row)*10^3;%um
figure(200)
powerenhancedb=10*log10(deltaz*mub*exp(-2*mut.*z));
plot(z,powerenhancedb)
hold on;
tho=10^(-5);
mub=tho*3/2/D*Qb(D,row)*10^3*(1-cos(0.0267))*2*pi;
mut=tho*3/2/D*Qext(D,row)*10^3;%u
powerenhancedb=10*log10(deltaz*mub*exp(-2*mut.*z));
plot(z,powerenhancedb,':')
hold on;
tho=10^(-4);
mub=tho*3/2/D*Qb(D,row)*10^3*(1-cos(0.0267))*2*pi;
mut=tho*3/2/D*Qext(D,row)*10^3;%um
powerenhancedb=10*log10(deltaz*mub*exp(-2*mut.*z));
plot(z,powerenhancedb,'-.')
hold on;
tho=10^(-3);
mub=tho*3/2/D*Qb(D,row)*10^3*(1-cos(0.0267))*2*pi;
mut=tho*3/2/D*Qext(D,row)*10^3;%um
powerenhancedb=10*log10(deltaz*mub*exp(-2*mut.*z));
plot(z,powerenhancedb,'--')
xlabel('Depth (\mum)')
ylabel('Light enhancement (dB)')
ylim([-145,-75])
legend('\rho=10^-^6','\rho=10^-^5','\rho=10^-^4','\rho=10^-^3')
legend('Location','southwest')
%legend('Location','northeastoutside')
hold off

%%
%100nm diameter
D=100;%nm
tho=10^(-6);
mub=tho*3/2/D*Qb(D,row)*10^3*(1-cos(0.0267))*2*pi;
mut=tho*3/2/D*Qext(D,row)*10^3;%um
figure(201)
powerenhancedb=10*log10(deltaz*mub*exp(-2*mut.*z));
plot(z,powerenhancedb)
hold on;
tho=10^(-5);
mub=tho*3/2/D*Qb(D,row)*10^3*(1-cos(0.0267))*2*pi;
mut=tho*3/2/D*Qext(D,row)*10^3;%um
powerenhancedb=10*log10(deltaz*mub*exp(-2*mut.*z));
plot(z,powerenhancedb,':')
hold on;
tho=10^(-4);
mub=tho*3/2/D*Qb(D,row)*10^3*(1-cos(0.0267))*2*pi;
mut=tho*3/2/D*Qext(D,row)*10^3;%um
powerenhancedb=10*log10(deltaz*mub*exp(-2*mut.*z));
plot(z,powerenhancedb,'-.')
hold on;
tho=10^(-3);
mub=tho*3/2/D*Qb(D,row)*10^3*(1-cos(0.0267))*2*pi;
mut=tho*3/2/D*Qext(D,row)*10^3;%um
powerenhancedb=10*log10(deltaz*mub*exp(-2*mut.*z));
plot(z,powerenhancedb,'--')
xlabel('Depth (\mum)')
ylabel('Light enhancement (dB)')
ylim([-115,-45])
legend('\rho=10^-^6','\rho=10^-^5','\rho=10^-^4','\rho=10^-^3')
legend('Location','southwest')
hold off

%%
%400nm diameter
D=400;%nm
tho=10^(-6);
mub=tho*3/2/D*Qb(D,row)*10^3*(1-cos(0.0267))*2*pi;
mut=tho*3/2/D*Qext(D,row)*10^3;%um
figure(202)
powerenhancedb=10*log10(deltaz*mub*exp(-2*mut.*z));
plot(z,powerenhancedb)
hold on;
tho=10^(-5);
mub=tho*3/2/D*Qb(D,row)*10^3*(1-cos(0.0267))*2*pi;
mut=tho*3/2/D*Qext(D,row)*10^3;%um
powerenhancedb=10*log10(deltaz*mub*exp(-2*mut.*z));
plot(z,powerenhancedb,':')
hold on;
tho=10^(-4);
mub=tho*3/2/D*Qb(D,row)*10^3*(1-cos(0.0267))*2*pi;
mut=tho*3/2/D*Qext(D,row)*10^3;%um
powerenhancedb=10*log10(deltaz*mub*exp(-2*mut.*z));
plot(z,powerenhancedb,'-.')
hold on;
tho=2*10^(-4);
mub=tho*3/2/D*Qb(D,row)*10^3*(1-cos(0.0267))*2*pi;
mut=tho*3/2/D*Qext(D,row)*10^3;%um
powerenhancedb=10*log10(deltaz*mub*exp(-2*mut.*z));
plot(z,powerenhancedb,'--')
xlabel('Depth (\mum)')
ylabel('Light enhancement (dB)')
ylim([-90,-40])
legend('\rho=10^-^6','\rho=10^-^5','\rho=10^-^4','\rho=2\times10^-^4')
legend('Location','southwest')
hold off



%%
figure(156)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
%contour(X,Y,Qb(1:100,:)./Qext(1:100,:),[0.1,0.5,0.6,0.7,0.8,0.9],'ShowText','on')
contour(X,Y,3/2*QbD(1:p,:)*10^6,[1,100,1000,10000,50000],'ShowText','on')
colorbar('eastoutside')
hc=colorbar;
ylabel(hc,'mm^-^1');
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('3Qb_n_a_n_o/2D')

figure(157)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
surfc(X,Y,2*log(2)/3./QextD(1:p,:)*10^(-6))
%surfc(X,Y,QextD(1:p,:))
shading interp 
view(2)
colorbar('eastoutside')
hc=colorbar;
ylabel(hc,'mm');
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('2Dln2)/(3Qext)')

figure(158)
[X,Y]=meshgrid(lambda_vector(1:q),diameter(1:p));
%contour(X,Y,Qb(1:100,:)./Qext(1:100,:),[0.1,0.5,0.6,0.7,0.8,0.9],'ShowText','on')
contour(X,Y,2*log(2)/3./QextD(1:p,:)*10^(-6),[0.000002,0.000002,0.00002,0.0002,0.002],'ShowText','on')
colorbar('eastoutside')
hc=colorbar;
ylabel(hc,'mm');
xlabel('Wavelength (nm)')
ylabel('Diameter of nanoparticle (nm)')
title('2Dln2)/(3Qext)')


%1201 means the position of 1550nm wavelength
figure(201)
%10^-6
penetrationdepth=2*log(2)/3./QextD(1:p,1201)*10^(-6)/(10^(-6));
mubvalue=3/2*QbD(1:p,1201)*10^6*(10^(-6));
yyaxis left
plot(diameter(1:p),penetrationdepth);
yyaxis right
plot(diameter(1:p),mubvalue);
legend('penetrationdepth','mubvaluelog')

figure(202)
%10^-5
penetrationdepth=2*log(2)/3./QextD(1:p,1201)*10^(-6)/(10^(-5));
mubvalue=3/2*QbD(1:p,1201)*10^6*(10^(-5));
mubvalue=10*log10(12*10^(-3)*0.0011*mubvalue);
yyaxis left
plot(diameter(1:p),penetrationdepth);
yyaxis right
plot(diameter(1:p),mubvalue);
legend('penetrationdepth','mubvaluelog')

figure(203)
%10^-4
penetrationdepth=2*log(2)/3./QextD(1:p,1201)*10^(-6)/(10^(-4));
mubvalue=3/2*QbD(1:p,1201)*10^6*(10^(-4));
mubvalue=10*log10(12*10^(-3)*0.0011*mubvalue);
yyaxis left
plot(diameter(1:p),penetrationdepth);
yyaxis right
plot(diameter(1:p),mubvalue);
legend('penetrationdepth','mubvaluelog')

figure(204)
%10^-3
penetrationdepth=2*log(2)/3./QextD(1:p,1201)*10^(-6)/(10^(-3));
mubvalue=3/2*QbD(1:p,1201)*10^6*(10^(-3));
mubvalue=10*log10(12*10^(-3)*0.0011*mubvalue);
yyaxis left
plot(diameter(1:p),penetrationdepth);
yyaxis right
plot(diameter(1:p),mubvalue);
legend('penetrationdepth','mubvaluelog')


figure(205)
subplot(2,1,1)
%10^-3
tho2=[10^(-6),2*10^(-6),3*10^(-6),4*10^(-6),5*10^(-6),6*10^(-6),7*10^(-6),8*10^(-6),9*10^(-6),10^(-5),2*10^(-5),3*10^(-5),4*10^(-5),5*10^(-5),6*10^(-5),7*10^(-5),8*10^(-5),9*10^(-5),10^(-4),2*10^(-4),3*10^(-4),4*10^(-4),5*10^(-4),6*10^(-4),7*10^(-4),8*10^(-4),9*10^(-4),10^(-3)];
[hang,lie]=size(tho2);
for i=1:lie
penetrationdepth2(i,:)=2*log(2)/3./QextD(1:p,1201)'*10^(-6)./tho2(i);
mubvalue2(:,i)=3/2*QbD(1:p,1201)*10^6*tho2(i);
mubvalue2(:,i)=10*log10(12*10^(-3)*0.0011.*mubvalue2(:,i));
end
[X,Y]=meshgrid(diameter(1:p),tho2);
surfc(X,Y,penetrationdepth2)
set(gca','yscale','log');
shading interp 
view(2)
colorbar('eastoutside')
xlabel({'Diameter of nanoparticle (nm)';'(a)'});
ylabel('Volume ratio');
hc=colorbar;
ylabel(hc,'Depth (mm)');
subplot(2,1,2)
surfc(X,Y,mubvalue2')
set(gca','yscale','log');
view(2)
shading interp 
colorbar('eastoutside')
xlabel({'Diameter of nanoparticle (nm)';'(b)'});
ylabel('Volume ratio');
hc=colorbar;
ylabel(hc,'R-enhancement (dB)');



% figure(207)
% plot(diameter(1:p),10*log10(12*10^(-3)*0.0011.*3/2*QbD(1:p,1201)*10^6*10^(-6)));
% hold on;
% plot(diameter(1:p),10*log10(12*10^(-3)*0.0011.*3/2*QbD(1:p,1201)*10^6*10^(-5)));
% hold on;
% plot(diameter(1:p),10*log10(12*10^(-3)*0.0011.*3/2*QbD(1:p,1201)*10^6*10^(-4)));
% hold on;
% plot(diameter(1:p),10*log10(12*10^(-3)*0.0011.*3/2*QbD(1:p,1201)*10^6*10^(-3)));
% hold off;


%%
Lmax=2000;
L=1:1:Lmax;
lambdacposition=1151;%position of 1550nm in lambda array
for i=1:1:400%diamter
    for j=1:1:Lmax%mm
            rhomax(i,j)=2*i*log(2)/3/Qext(i,lambdacposition)*10^(-6)/j;
    end
end

%%
musqrt=sqrt(3/2*QbD(1:p,lambdacposition)*10^6);
musqrtarray=repmat(musqrt, 1,Lmax);
mubsqrtmax=musqrtarray.*sqrt(rhomax);

figure(555)
subplot(1,2,1)
[X,Y]=meshgrid(L,diameter(1:p));
surfc(X,Y,mubsqrtmax)
set(gca','xscale','log');
shading interp 
view(2)
colorbar('eastoutside')
hc=colorbar;
title(hc,'$ \sqrt{\mu_b}max$ $ (mm^{-1/2})$','interpreter','latex')
xlabel({'Desired penetration depth (mm)';'(a)'});
ylabel('Diameter of NP (nm)');

subplot(1,2,2)
[X,Y]=meshgrid(L,diameter(1:p));
%surfc(X,Y,10.*log(rhomax))
surfc(X,Y,rhomax)
set(gca','xscale','log');
shading interp 
view(2)
colorbar('eastoutside')
hc=colorbar;
%ylabel(hc,'10log(\rho)  dB');
title(hc,'\rho');
xlabel({'Desired penetration depth (mm)';'(b)'});
ylabel('Diameter of NP (nm)');







figure(666)
[max_a,index]=max(mubsqrtmax);
%plot(L,max_a)
loglog(L,max_a)
set(gca','yscale','log');
hold on;
xlim([1,2000])
%plot(L,rhomax(224,:))
loglog(L,rhomax(224,:))
set(gca','yscale','log');
legend('Enhancement ($\sqrt{\mu_b} max$)','Volume ratio ($\rho max$)','interpreter','latex')
xlim([1,2000])
xlabel({'Desired penetration depth (mm)'});
ylim([10^(-8),100])
ylabel({'Enhancement (mm^-^1^/^2)';'Volume ratio (-)'});


%%
length2=0:10:10000;%um;10mm,0.01mm
B=60^2/1550^2/4/log(2)+1;
zi=pi*1.452*4.75^2/1.55;
C=1./(((length2/zi).^2)+1);
mub=0.118*0.001;
Omiga=0.0252;
Gamma=1;
resolution=12;%um
mufibre=2.99*10^(-8-3);
muliquid=0.02*0.001;
muNP=0.0711*0.001;
K=1;%1mA/mW

% figure(777)
% % subplot(2,2,2)
% % I1=B.*C*resolution*mub.*exp(-2*(muliquid+muNP).*length2);
% % plot(length2,I1)
% % set(gca','yscale','log');
% % xlabel({'Depth (mm)';'(b)'});
% % ylabel({'Power (mW)'});
% % grid on;
% 
% subplot(4,1,1)
% i1=K.*sqrt(I1);
% plot(length2,i1)
% set(gca','yscale','log');
% xlabel({'Depth (\mum)';'(a)'});
% ylabel({'Intensity (mA)'});
% grid on;
% 
% subplot(4,1,3)
% I2=B*Gamma*resolution*mub.*exp(-2*(mufibre+muNP).*length2);
% plot(length2,I2)
% set(gca','yscale','log');
% xlabel({'Depth (\mum)';'(c)'});
% ylabel({'Power (mW)'});
% grid on;
% 
% subplot(4,1,2)
% i2=K.*sqrt(I2);
% plot(length2,i2)
% set(gca','yscale','log');
% xlabel({'Depth (\mum)';'(b)'});
% ylabel({'Intensity (mA)'});
% grid on;
% 
% subplot(4,1,4)
% plot(length2,10*log10(I2))
% set(gca','yscale','log');
% xlabel({'Depth (\mum)';'(d)'});
% ylabel({'Power (dBm)'});
% grid on;
% 
% save('paper2.mat')

