This is the archive for Chapter 6: "Avoiding Checkpoints using a Data Cache" within the PhD thesis named "Accelerating Programmer-Friendly Intermittent Computing" by Vito Kortbeek. This archive holds the code and data for an intermittent-computing solution that utilizes cache modifications to track WAR dependencies and triggers checkpoints to avoid re-execution errors.

## Rationale
Intermittently operating embedded computing platforms powered by energy harvesting must frequently checkpoint their computation state. Using non-volatile main memory significantly reduces the checkpoint size but at the cost of increasing the checkpoint frequency to cover WAR dependencies. Additionally, non-volatile memory is significantly slower to access---while consuming more energy than its volatile counterpart---suggesting the use of a data cache. Sadly, existing data cache solutions do not fit the challenges of intermittent computing and often require additional hardware or software to detect WAR. In the thesis chapter, we extend the data cache by integrating it with WAR detection---dropping the need for an additional memory tracker. This idea forms the basis of NACHO: a data cache tailored to intermittent computing. NACHO, on average, reduces intermittent computing runtime overhead by over 70% and reduces the number of non-volatile memory writes by 86% compared to a data cache-less system and 55% compared to a state-of-the-art cache-based system.

## Archive Structure
This archive consists of the software to emulate the cache (`icemu/plugins`), and the LLVM toolchain used to compile applications for NACHO (`llvm`). The code can be built and run using the development docker container in the `docker` directory. To build all the benchmarks, execute the `run.sh` script within the `benchmarks` directory. Run the respective Jupyter Notebook in the `plotting` directory to analyze the results.