import pandas as pd
import matplotlib.pyplot as plt
from itertools import cycle
import numpy as np
import time
import datetime
from scipy.optimize import curve_fit


##################settings
colors={ 
        
        'blue'  : '#4477AA', # blue
        'cyan': '#66CCEE', # cyan
        'green': '#228833', # green
        'yellow': '#CCBB44', # yellow
        'orange': '#EE7733', # orange
        'red'   : '#EE6677', # red
        'purple': '#AA3377', # purple
        'grey': '#BBBBBB' #grey
        }
color_cycle = cycle(colors.values())

marker_styles = ['o', 's', 'D', '^', 'v', '<', '>', 'p', '*', 'h', 'H', '+', 'x', 'd', '_','|']
marker_cycle = cycle(marker_styles)

line_styles =[
     ('loosely dotted',        (0, (1, 10))),
     ('dotted',                (0, (1, 1))),
     ('densely dotted',        (0, (1, 1))),
     ('long dash with offset', (5, (10, 3))),
     ('loosely dashed',        (0, (5, 10))),
     #('dashed',                (0, (5, 5))),
     ('densely dashed',        (0, (5, 1))),

     ('loosely dashdotted',    (0, (3, 10, 1, 10))),
     ('dashdotted',            (0, (3, 5, 1, 5))),
     ('densely dashdotted',    (0, (3, 1, 1, 1))),

     ('dashdotdotted',         (0, (3, 5, 1, 5, 1, 5))),
     ('loosely dashdotdotted', (0, (3, 10, 1, 10, 1, 10))),
     ('densely dashdotdotted', (0, (3, 1, 1, 1, 1, 1)))]
line_cycle = cycle(line_styles)
################################################################################
### read the data
kb=1.38e-23
T=298
variable_name="Csalt"
df_flat = pd.read_excel("./results_flat.xlsx")
ct = datetime.datetime.now().strftime('%Y%m%d_%H%M%S') # ct stores current time
ct_str=str(ct)

shifts_flat = np.zeros(len(np.unique(df_flat[variable_name].values)))
coeffs_flat = np.zeros(len(np.unique(df_flat[variable_name].values)))

######################################################################################################
##################################### read cylindrical results
df_cyl = pd.read_excel("./results_cylindrical.xlsx")

########################### in 1 graph
breit = 8.27
long = breit
fig, ((ax1, ax4), (ax2,ax5), (ax3, ax6)) = plt.subplots(3, 2, figsize=(breit,long))

 # strain
for variable,farbe, mar in zip(np.unique(df_flat[variable_name].values), colors.values(), marker_styles):
    x = df_flat.loc[df_flat[variable_name] == variable]["pH"] # exclude case m=1
    delta1lin = df_flat.loc[df_flat[variable_name] == variable]["delta1lin"].values
    delta0lin = df_flat.loc[df_flat[variable_name] == variable]["delta0lin"].values[0]
    ax1.plot(x, delta1lin, marker=mar, label=f'$10^{{{np.log10(variable):.0f}}}$ M', color=farbe)
    ax1.axhline(delta0lin, ls='dashed', c=farbe)
ax1.set_ylabel(r"$\delta_{\mathrm{eq}}$",fontsize=16)
ax1.set_ylim(0, 0.73)
ax1.text(11, delta0lin + 0.025, r'$\delta_{\mathrm{eq}}^{\mathrm{0}}$', fontsize=14)
ax1.set_xticks(np.linspace(2, 12, 11))

#### delta p
for variable,farbe, mar in zip(np.unique(df_flat[variable_name].values),  colors.values(), marker_styles):
    x = df_flat.loc[df_flat[variable_name] == variable]["pH"] # exclude case m=1
    deltap_pro = df_flat.loc[df_flat[variable_name] == variable]["deltap_pro3"].values/1000000
    ax2.plot(x,deltap_pro,marker=mar, label=f'$10^{{{np.log10(variable):.0f}}}$ M', color=farbe)
for variable,farbe, mar in zip(np.unique(df_flat[variable_name].values),  colors.values(), marker_styles):
    x = df_flat.loc[df_flat[variable_name] == variable]["pH"] # exclude case m=1
    deltap_dep = df_flat.loc[df_flat[variable_name] == variable]["deltap_dep3"].values/1000000
    ax2.plot(x,deltap_dep,marker=mar, label=f'$10^{{{np.log10(variable):.0f}}}$ M',color=farbe)
ax2.axhline(0, ls='dashed', c='grey')
ax2.set_ylim(-15., 45.)
ax2.set_ylabel(r"$\Delta \Pi$ [MPa]", fontsize=16)
ax2.set_xticks(np.linspace(2, 12, 11))

#### work
for variable,farbe, mar in zip(np.unique(df_flat[variable_name].values), colors.values(), marker_styles):
    x = df_flat.loc[df_flat[variable_name] == variable]["pH"] # exclude case m=1
    w_chain = df_flat.loc[df_flat[variable_name] == variable]["int_bad"].values / (df_flat.loc[df_flat[variable_name] == variable]["M"].values)
    ax3.plot(x, w_chain/kb/T, marker=mar, label=f'$10^{{{np.log10(variable):.0f}}}$ M',color=farbe)
ax3.axhline(0, ls='dashed', c='grey')
legend = ax3.legend(title=r'$c_{\mathrm{s}}$:',bbox_to_anchor=(0, -0.7, 1, -0.7), loc="lower center",
                mode="expand", borderaxespad=0, ncol=2, fontsize = 11, title_fontsize=12)
ax3.set_ylabel(r"$W_{\mathrm{chain}}$ $[kT]$", fontsize=16)
ax3.set_xticks(np.linspace(2, 12, 11))

ax3.set_xlabel(r"pH", fontsize=14)
#Set x-axis labels only for the last subplot to avoid clutter
ax1.tick_params(labelbottom=False, direction="in")  # Hide x-axis labels on ax1
ax2.tick_params(labelbottom=False, direction="in") 
ax3.tick_params(direction="inout") 
# Adjust the space between plots to be zero
plt.subplots_adjust(hspace=0)

######################################
###################################################cyl ################
################################

color_cycle = cycle(colors.values())
marker_cycle = cycle(marker_styles)
line_cycle = cycle(line_styles)


 # strain
for variable,farbe, mar in zip(np.unique(df_cyl[variable_name].values), colors.values(), marker_styles):
    x = df_cyl.loc[df_cyl[variable_name] == variable]["pH"] # exclude case m=1
    delta1lin = df_cyl.loc[df_cyl[variable_name] == variable]["delta1lin"].values
    delta0lin = df_cyl.loc[df_cyl[variable_name] == variable]["delta0lin"].values[0]
    ax4.plot(x, delta1lin, marker=mar, label=f'$10^{{{np.log10(variable):.0f}}}$ M', fillstyle='none', color=farbe)
    ax4.axhline(delta0lin, ls='dashed', c=farbe)
ax4.set_ylim(0, 0.73)
ax4.text(11, delta0lin + 0.03, r'$\delta_{\mathrm{eq}}^{\mathrm{0}}$', fontsize=14)
ax4.set_xticks(np.linspace(2, 12, 11))

#### delta p
for variable,farbe, mar in zip(np.unique(df_cyl[variable_name].values),  colors.values(), marker_styles):
    x = df_cyl.loc[df_cyl[variable_name] == variable]["pH"] # exclude case m=1
    deltap_pro = df_cyl.loc[df_cyl[variable_name] == variable]["deltap_pro3"].values/1000000
    ax5.plot(x,deltap_pro,marker=mar, fillstyle='none', color=farbe)
for variable,farbe, mar in zip(np.unique(df_cyl[variable_name].values),  colors.values(), marker_styles):
    x = df_cyl.loc[df_cyl[variable_name] == variable]["pH"] # exclude case m=1
    deltap_dep = df_cyl.loc[df_cyl[variable_name] == variable]["deltap_dep3"].values/1000000
    ax5.plot(x,deltap_dep,marker=mar, fillstyle='none',color=farbe)
ax5.axhline(0, ls='dashed', c='grey')
ax5.set_xticks(np.linspace(2, 12, 11))

#### work
for variable,farbe, mar in zip(np.unique(df_cyl[variable_name].values), colors.values(), marker_styles):
    x = df_cyl.loc[df_cyl[variable_name] == variable]["pH"] # exclude case m=1
    w_chain = df_cyl.loc[df_cyl[variable_name] == variable]["int_bad"].values / (df_cyl.loc[df_cyl[variable_name] == variable]["M"].values)
    ax6.plot(x, w_chain/kb/T, marker=mar, label=f'$10^{{{np.log10(variable):.0f}}}$ M',fillstyle='none', color=farbe)
ax6.axhline(0, ls='dashed', c='grey')
ax6.set_xticks(np.linspace(2, 12, 11))

ax6.set_xlabel(r"pH", fontsize=14)
#Set x-axis labels only for the last subplot to avoid clutter
ax4.tick_params(labelbottom=False, direction="in")  # Hide x-axis labels on ax1
ax5.tick_params(labelbottom=False, direction="in") 
ax6.tick_params(direction="inout") 
legend2 = ax6.legend(title=r'$c_{\mathrm{s}}$:' ,bbox_to_anchor=(0, -0.7, 1, -0.7), loc="lower center",
                mode="expand", borderaxespad=0, ncol=2, fontsize = 11, title_fontsize=12)
# Adjust the space between plots to be zero
plt.subplots_adjust(hspace=0)

ax1.set_title("Flat", fontsize=14)
ax4.set_title("Cylindrical", fontsize=14)

ax1.tick_params(axis='both', labelsize=12)
ax2.tick_params(axis='both', labelsize=12)
ax3.tick_params(axis='both', labelsize=12)
ax4.tick_params(axis='both', labelsize=12)
ax5.tick_params(axis='both', labelsize=12)
ax6.tick_params(axis='both', labelsize=12)

plt.savefig("pH_cr_vary"+variable_name+".pdf", bbox_inches="tight")
plt.savefig("pH_cr_vary"+variable_name+".png", bbox_inches="tight")