import pandas as pd
import matplotlib.pyplot as plt
from itertools import cycle
import numpy as np
import time

# # Plot setup
colors={
        "blue"  : "#4477AA", # blue
        "cyan": "#66CCEE", # cyan
        "green": "#228833", # green
        "yellow": "#CCBB44", # yellow
        "orange": "#EE7733", # orange
        "red"   : "#EE6677", # red
        "purple": "#AA3377", # purple
        "grey": "#BBBBBB",  # grey
        }

marker_styles = ["o", "s", "D", "^", "v", "<", ">", "p", "*", "h", "H", "+", "x", "d", "|", "_"]

T=298 # temperature [K]
kb=1.380649*10**(-23) # Boltzmann_constant [J⋅K−1]
Nav= 6.02214076*10**23 # Avogadro's number [mol-1]
b = 0.6e-9
#color_cycle = cycle(colors.values())
#marker_cycle = cycle(marker_styles)
pH_values = [6,7,8,9]
lmax=501
df = pd.read_excel("comp_results_flat_Hrms.xlsx")
variable_name="pH"
geometry='flat'

# using tuple unpacking for multiple Axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(9,3))
# fig.tight_layout()

for variable in zip(pH_values):
    x = df.loc[df[variable_name] == variable]["Csalt"]
    layers = df.loc[df[variable_name] == variable]["n_layers_min"].values
    ax1.plot(x,layers,marker="D", c='grey', ls='dotted')

 
ax1.set_ylabel(r"$\delta_{\mathrm{eq}}$ [layers]", fontsize=15)
ax1.set_xlabel(r"$\varphi_{\mathrm{s}}$", fontsize=18)
ax1.text(1e-4*1.7, 70, r'6',fontsize=12)
ax1.text(1e-4*0.7, 90, r'7',fontsize=12)
ax1.text(1e-4*0.4, 140, r'8',fontsize=12)
ax1.text(1e-4*0.13, 240, r'pH=9',fontsize=12)
ax1.set_xscale("log")

for variable in zip(pH_values[:-1]):
    x = df.loc[df[variable_name] == variable]["Csalt"]
    Hrms_double = df.loc[df[variable_name] == variable]["Hrms_double"].values
    Hrms_single = df.loc[df[variable_name] == variable]["Hrms_single"].values
    ax2.plot(x,Hrms_single,marker="o",c='k') #4477AA
    ax2.plot(x,Hrms_double,marker="s",c='grey', ls='dashed')

x = df.loc[df[variable_name] == 9]["Csalt"]
Hrms_double = df.loc[df[variable_name] == 9]["Hrms_double"].values
Hrms_single = df.loc[df[variable_name] == 9]["Hrms_single"].values
ax2.plot(x,Hrms_single,marker="o", label=r"single",c='k') #4477AA
ax2.plot(x,Hrms_double,marker="s", label=r"double",c='grey', ls='dashed')
 
ax2.set_ylabel(r"$H_{\mathrm{rms}}$ [layers]", fontsize=13)
ax2.set_xlabel(r"$\varphi_{\mathrm{s}}$", fontsize=18)
ax2.text(1e-4*4, 45, r'6',fontsize=12)
ax2.text(1e-4+1e-5*2, 62, r'7',fontsize=12)
ax2.text(1e-4*0.6, 95, r'8',fontsize=12)
ax2.text(1e-4*0.13, 140, r'pH=9',fontsize=12)
ax2.set_xscale("log")
plt.subplots_adjust(wspace=0.25)
fig.savefig('Hrms_and_delta.pdf', bbox_inches='tight')


