# -*- coding: utf-8 -*-
# See older version of file for old plotting methods!!
 
import numpy as np
from scipy.interpolate import CubicSpline
import scipy as sc
from itertools import product
from itertools import cycle
#from numba import njit
import datetime
import scipy.interpolate as sc
from collections import defaultdict
from matplotlib.ticker import ScalarFormatter
import pandas as pd
import math
import matplotlib.pyplot as plt

R = 2.4e-9 #m
T=298 # temperature [K]
kb=1.380649*10**(-23) # Boltzmann_constant [J⋅K−1]
Nav= 6.02214076*10**23 # Avogadro's number [mol-1]

ct = datetime.datetime.now().strftime('%Y%m%d_%H%M%S') # ct stores current time
ct_str=str(ct)

def get_column_contents(file_path, column_name):
    # Read the file into a DataFrame
    df = pd.read_csv(file_path, sep='\t', lineterminator='\n')
    
    # Check if the column exists
    if column_name not in df.columns:
        raise ValueError(f'Column {column_name} not found in the file.')
    
    # Return the contents of the column
    return np.flip(df[column_name].values)

def format_scientific(num):
    if num == 0:
        return "0"
    power = int(math.floor(math.log10(abs(num))))
    coefficient = num / (10 ** power)
    # return f'{coefficient}' + r'$\cdot 10^{' + str(power) + '}$'
    return r'$10^{' + str(power) + '}$'


def get_data_cyl(Np, Csalt, sigma_f, sigma_p, p2_ch, ChiPS, b):

    base_path=r'./kal_files/'
    assert(b!=0.6e-9)
    assert(sigma_f==0)
    assert(sigma_p!=0)
    if sigma_f == 0 and sigma_p != 0:
        file0 = base_path+'cylindrical_charge=0_R=2.5_nm_NP='+str(Np)+'_Csalt='+str(Csalt)+'_M_Sigma='+str(sigma_p)+'_mol_nm2_ChiPS='+str(ChiPS)+'.kal'
        file1 = base_path+'cylindrical_charge='+str(p2_ch)+'_R=2.5_nm_NP='+str(Np)+'_Csalt='+str(Csalt)+'_M_Sigma='+str(sigma_p)+'_mol_nm2_ChiPS='+str(ChiPS)+'.kal'
    #print(file0)
    #print(file1)
    offset_first_layer = 8.
    sigma_p_m2=sigma_p*1e18
    M_cyl = 2.*np.pi*offset_first_layer*sigma_p_m2*b**2 #number of polymer chains
    theta_cyl = M_cyl*2.*Np
    lmin_cyl = int(np.ceil(np.sqrt((theta_cyl + np.pi*offset_first_layer*offset_first_layer)/np.pi)))
    lmax_cyl = 2*Np + offset_first_layer
    #print(Np, lmax_cyl)

    ###########################Cylindrical##################################
    
    # print(file0)
    # Load and process data for file0
    gp0_sfbox = get_column_contents(file0, 'sys : noname : grand potential')
    layers0 = get_column_contents(file0, 'lat : solution : n_layers')
    en0 = get_column_contents(file0,'sys : noname : free energy(po)')

    # Load and process data for file1
    layers1 = get_column_contents(file1, 'lat : solution : n_layers')
    gp_sfbox = get_column_contents(file1, 'sys : noname : grand potential')
    en1 = get_column_contents(file1,'sys : noname : free energy(po)')
    ## compute partial open free energy
    en_po_from_real_gp = (
            gp_sfbox
            # POLYMER
            + (get_column_contents(file1, 'mol : poly : sum n FH-MU') if sigma_p != 0 else 0)
            
            # SURFACE GROUPS
            + (get_column_contents(file1, 'mol : funcsurface : sum n FH-MU') if sigma_f != 0 else 0)
        )
    
    # compute pressure, stroke, work
    delta0 = (layers0 + offset_first_layer)/ (lmax_cyl)
    diff_energy0 = (-en0[:-1] + en0[1:])*kb*T/b
    diff_vol0 = (-(layers0[:-1] + offset_first_layer)**2 + (layers0[1:] + offset_first_layer)**2)*b**2*np.pi
    pres0 = - (diff_energy0 / diff_vol0)
    deltapress0 = (delta0[1:] + delta0[:-1]) * 0.5
    delta_interp = np.linspace(0., 1., 1000)
    line0 = sc.interp1d(deltapress0, pres0, fill_value='extrapolate')
    press0_lin = line0(delta_interp)
    
    delta1 = (layers1 + offset_first_layer)/ (lmax_cyl)
    diff_energy1 = (-en1[:-1] + en1[1:])*kb*T/b
    diff_vol1 = (-(layers1[:-1] + offset_first_layer)**2 + (layers1[1:] + offset_first_layer)**2)*b**2*np.pi
    pres1 = - (diff_energy1 / diff_vol1)
    deltapress1 = (delta1[1:] + delta1[:-1]) * 0.5
    delta_interp = np.linspace(0., 1., 1000)
    line1 = sc.interp1d(deltapress1, pres1, fill_value='extrapolate')
    press1_lin = line1(delta_interp)
    
    delta0lin = delta_interp[np.argmin(abs(press0_lin - 0.))]
    #delta0lin = delta0[en0.argmin()]

    delta1lin = delta_interp[np.argmin(abs(press1_lin - 0.))]
    #delta1lin = delta1[en1.argmin()]
    deltap_pro3 = press0_lin[np.argmin(abs(press1_lin - 0.))] - press1_lin[np.argmin(abs(press1_lin - 0.))]
    deltap_dep3 = press1_lin[np.argmin(abs(press0_lin - 0.))] - press0_lin[np.argmin(abs(press0_lin - 0.))]

    dx = 0.001
    y_heights0 = press0_lin[np.argmin(abs(press0_lin - 0.)) :  np.argmin(abs(press1_lin - 0.))]
    y_heights1 = press1_lin[np.argmin(abs(press0_lin - 0.)) :  np.argmin(abs(press1_lin - 0.))]
    d_points = delta_interp[np.argmin(abs(press0_lin - 0.)) :  np.argmin(abs(press1_lin - 0.))]
    int_bad = (np.sum(y_heights1*d_points*dx) - np.sum(y_heights0*d_points*dx))*(2*b**3*np.pi*lmax_cyl**2)
    
    x1cyl =  np.array(delta1lin)*lmax_cyl
    x0cyl = np.array(delta0lin)*lmax_cyl
    deltavolcyl = (x1cyl**2 - x0cyl**2)*np.pi*b**3
    
    index_delta0lin = int(delta0lin*lmax_cyl) - int(offset_first_layer)
    Poly_total = get_column_contents(file0, 'mol : poly : theta')
    Poly_total = Poly_total[index_delta0lin]

    
    return {
        'geometry': 'cylindrical', 
        'Np': Np,
        'Csalt': Csalt,
        'sigma_f': sigma_f,
        'sigma_p': sigma_p,
        'p2_charge': p2_ch,
        'int_bad': int_bad,
        'delta0lin': delta0lin,
        'delta1lin': delta1lin,
        'deltap_pro3': deltap_pro3,
        'deltap_dep3': deltap_dep3,
        'deltavol': deltavolcyl,
        'M': M_cyl,
        'Poly_total': Poly_total,
        # 'P1_total': P1_total,
        #'P2_total': P2_total,
        'ChiPS': ChiPS,
        # Include other relevant data as needed
    }

def main():
    b = 0.3e-9
    Np = 100
    sigma_f=0
    sigma_p =1
    p2_ch_range = [0, 0.05, 0.1, 0.25, 0.5,0.6666666666666666, 0.75, 1]
    ChiPS = 0.4
    Csalt_range = [1.0,0.1, 0.01, 0.001, 0.0001]
    geometry = "cylindrical"
    results=[]

    for Csalt in Csalt_range:
        for p2_ch in p2_ch_range:
            if geometry == 'flat':
                print("later")
            elif geometry == 'cylindrical':
                new_entry = get_data_cyl(Np, Csalt, sigma_f, sigma_p, p2_ch, ChiPS, b)
                results.append(new_entry.values())

    df = pd.DataFrame(results, columns=new_entry.keys())

    # Save to Excel
    excel_filename = 'fix_ch_results_'+geometry+'.xlsx'
    df.to_excel(excel_filename, index=False)

    print(f'Results saved to {excel_filename}')

if __name__ == '__main__':
    main()
       


    
