import pandas as pd
import matplotlib.pyplot as plt
from itertools import cycle
import numpy as np
import time

marker_styles = ["o", "s", "D", "^", "v", "<", ">", "p", "*", "h", "H", "+", "x", "d", "|", "_"]

T=298 # temperature [K]
kb=1.380649*10**(-23) # Boltzmann_constant [J⋅K−1]
Nav= 6.02214076*10**23 # Avogadro's number [mol-1]
b = 0.6e-9
pH_values = [6,7,8,9]
lmax=501
df = pd.read_excel("comp_results_flat_alpha.xlsx")
variable_name="pH"
geometry='flat'

############################################################################################################
######### dissociation degree
plt.style.use('tableau-colorblind10')
plt.figure()
for variable,mar in zip(pH_values, marker_styles):
    x = df.loc[df[variable_name] == variable]["Csalt"]
    #delta1lin = df.loc[df[variable_name] == variable]["delta1lin"].values
    alphas = df.loc[df[variable_name] == variable]["alpha diss"].values
    plt.plot(x,alphas,marker=mar)

plt.tick_params(axis='both', which='major', labelsize=15) 
plt.ylabel(r"$\alpha$", fontsize=18)
plt.xlabel(r"$\varphi_{\mathrm{s}}$", fontsize=18)
plt.text(1e-3+1e-3*3, -0.02, r'6',fontsize=12)
plt.text(1e-4*1.7, 0.1, r'7',fontsize=12)
plt.text(1e-4, 0.2, r'8',fontsize=12)
plt.text(1e-4*0.4, 0.5, r'pH=9',fontsize=12)
plt.xscale("log")
plt.savefig('alpha_comp_regimes.pdf', bbox_inches='tight')

