
clear all, close all;

% import data from csv files to plot slip length profiles for different a =
% H/L and epsilon

% in case of epsilon
a = 2;
e = [0.250 0.375 0.500];

%
figurefile = ['comsol_sliplength_a_e' '\' 'comsol_sliplength_e'];

nt = length(e);
for j = 1:nt
    filename{j} = ['comsol_sliplength_a_e/sliplength_a' num2str(a) '_e0' num2str(1000*e(j))];
    csvfile = [filename{j} '.csv'];
    M = csvread(csvfile,8,0); % start reading from cell (9,0), numbering is zero-based
    theta(j,:) = M(:,1);
    b_Rg(j,:) = M(:,2);
end

% compute slip length profile for analytical solution of Davis and Lauga
epsilon = 0.375;
theta_anal=-pi/3:1/180*pi:pi/2;
n = length(theta_anal);

% analytical model from Davis and Lauga, Phys. Fluids (2009)
for j=1:n
    f = @(s) s./(sinh(2.*s.*(pi-theta_anal(j)))+s.*sin(2.*theta_anal(j)))...
            .*(cos(2*theta_anal(j))+(s.*sin(2.*theta_anal(j)).*cosh(s.*pi)+sinh(s.*(pi-2.*theta_anal(j))))./sinh(s.*pi));
    b(j) = pi.*integral(f,0,120); % 2b/(R_g*epsilon)
end

for j = 1:nt
    b_anal(j,:) = b.*e(j); 
end

% plot figures
map=cbrewer('seq','OrRdBlGr',nt);
mm = 0;

% plot slip length
mm = mm + 1;
figure(mm)
hold on;
for j=1:nt
    h(j)=plot(theta(j,:),b_Rg(j,:),'color',map(j,:),'marker','o','LineStyle','none');
    legendentries{j} = ['\epsilon = ' num2str(e(j))];
end
for j=1:nt
    h(j)=plot(theta_anal./pi.*180,b_anal(j,:),'color',map(j,:));
end
hold off
xlim([min(theta_anal./pi.*180) 90])
box on
legend(legendentries,'location','SouthWest');
legend('boxoff');
ylabel('2b/L_g')
xlabel('\theta')
title(['Slip length as function of protrusion angle for a = H/L= ' num2str(a)])

%cleanfigure;
tikzfile = [figurefile '.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');