function VDanalysis(theta,option)
% theta = [1 5 9] or [1:4:21]; % list al protrusion angles
% if fig_on == 0 > do not display figures
% if fig_on ~= 0 > do display figures
%
% Normalisation options, e.g. option = 3
% all options are computed, but for plotting one need to be selected
% 1. [HP1] H-P (Hagen-Poiseuille) flow with u_av = 1
% 2. [HP2] H-P flow with same u_av as bubble mattress
% 3. [HP3] H-P flow with same phi_A as bubble mattress
% 4. [HP4] One-sided H-P slip flow with same slip length and u_av as bubble mattress
% 5. [HP5] One-sided H-P slip flow with same slip length and phi_A as bubble mattress

% function [X,Y,UX,UY,x,y,L,a,epsilon,theta,b,boverLg,u_av,...
%     y0_str,ux_av_str_HP,ux_av_HP,area_str_HP,phi_A_str_HP,phi_av_str_HP,phi_A_HP,cum_phi_A_str_HP, ...
%     area_str,ux_av_str,phi_A_str,phi_shear_A_str,phi_deform_A_str,phi_av_str,...
%     cum_phi_A_str,cum_phi_shear_A_str,cum_phi_deform_A_str,title_HP] ...
%     = VDimportcomsol(filename,fig_on,option)

clearvars -except theta option
close all

nt = length(theta);
for j = 1:nt
    filename{j} = ['comsol_a2_e500' '/' 'bm_' num2str(theta(j)) 'deg'];
end

for j = 1:nt
    [~,~,~,~,~,~,L(j),a(j),epsilon(j),theta(j),b(j),boverLg(j),u_av(j),...
        y0_str(:,j),ux_av_str_HP(:,j),ux_av_HP(j),area_str_HP(:,j),phi_A_str_HP(:,j),phi_av_str_HP(:,j),phi_A_HP(j),cum_phi_A_str_HP(:,j),...
        area_str(:,j),ux_av_str(:,j),phi_A_str(:,j),phi_shear_A_str(:,j),phi_deform_A_str(:,j),phi_av_str(:,j),...
        cum_phi_A_str(:,j),cum_phi_shear_A_str(:,j),cum_phi_deform_A_str(:,j),title_HP{j}] ...
        = VDimportcomsol(filename{j},0,option);
    area(j) = sum(area_str(:,j)); % total area of domain
    phi_A(j) = sum(phi_A_str(:,j)); % total dissipation in 2D domain with area A
    phi_shear_A(j) = sum(phi_shear_A_str(:,j)); % total dissipation by shear in 2D domain
    phi_deform_A(j) = sum(phi_deform_A_str(:,j)); % total dissipation by deformation in 2D domain
end

% % TEST TO ASSESS DIFFERENCE IN PHI-DISTRIBUTIONS
% for j = 1:nt
% average(j) = mean(phi_A_str(:,j));
% residuals1(:,j) = (phi_A_str(:,j) - average(j)).^2;
% SStot(j) = sum(residuals1(:,j));
% residuals2(:,j) = (phi_A_str(:,j) - phi_A_str_HP(:,j)).^2;
% SSres(j) = sum(residuals2(:,j));
% end
% Rsquared = 1 - SSres./SStot;
% 
% % TO BE TRANSPORTED
% ef3 = sqrt(phi_A./(12.*L)); % [HP3]
% b3 = (-1.*u_av./ef3 + 1)./(u_av./ef3 - 4);
% boverLg3 = (2.*a)./epsilon.*b3;

% for plotting ploty0_min >= y0_str <= ploty0_max
ploty0_min = 0;
ploty0_max = 1;
range = find(y0_str(:,1) >= ploty0_min & y0_str(:,1) <= ploty0_max);

% % correction of effective slip length for arc length of bubble and
% % effective channel height
% Lg = L(j) .* epsilon(j);
% R = Lg./(2.*sin(theta));
% Sg = 2.*theta.*R;
% Hf = 1 + R.*(cos(theta)-1);
% Hb = 2/3.*(1-Hf);

% % find maximum of dissipation function per streamtube
% % this is a local maximum, from which you know that y(max) < 0.5
% phi_A_str_y0_min = 0;
% phi_A_str_y0_max = 0.5;
% range2 = find(y0_str(:,1) >= phi_A_str_y0_min & y0_str(:,1) <= phi_A_str_y0_max);
% 
% for j = 1:nt 
% phi_A_str_max(j) = max(phi_A_str(range2,j));
% index_phi_A_str_max(j) = find(phi_A_str(range2,j) == phi_A_str_max(j));
% y_phi_A_str_max(j) = y0_str(index_phi_A_str_max(j),j);
% end

% calculation of analytical slip length function from Davis and Lauga
theta_anal=0:1/180*pi:pi/2;
n = length(theta_anal);
        
for j=1:n
    f = @(s) s./(sinh(2.*s.*(pi-theta_anal(j)))+s.*sin(2.*theta_anal(j)))...
            .*(cos(2*theta_anal(j))+(s.*sin(2.*theta_anal(j)).*cosh(s.*pi)+sinh(s.*(pi-2.*theta_anal(j))))./sinh(s.*pi));
    boverLg_anal(j) = pi.*epsilon(1).*integral(f,0,120);
end

theta = theta./pi.*180; % convert actual angles from rad to deg

map=cbrewer('seq','OrRdBlGr',nt);
mm = 0;

% plot dissipation per streamtube versus starting point of stream tube
mm = mm + 1;
figure(mm)
hold on;
for j=1:nt
    h(j)=plot(y0_str(range,j),phi_A_str(range,j),'color',map(j,:),'marker','.','MarkerSize',5);
    legendentries{j} = ['$\vartheta = ' num2str(theta(j)) '^{\circ}$'];
end
hold off
% c=get(gca,'Children'); %Get the handles for the child objects from the current axes
% set(gca,'Children',flipud(c)) %Invert the order of the objects
%legend([h(1) h(2) h(3) h(4) h(5) h(6)],legendentries);
%reorderLegend;
box on
ylim([0 0.3])
legend(legendentries,'Location','best');
legend('boxoff');
ylabel('$\tilde{\Phi}_{A,\mathrm{str}}$')
xlabel('$y_0$')
%title('Dissipation per 2D stream tube (i.e. Pa*m2/s)')

% tikzfile = ['VDanalysis_figures\phi_Astr.tikz'];
% matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');

% plot dissipation by shear per streamtube versus starting point of stream tube
mm = mm + 1;
figure(mm)
hold on;
for j=1:nt
    h(j)=plot(y0_str(range,j),phi_shear_A_str(range,j),'color',map(j,:),'marker','.');
    legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
end
hold off
box on
legend(legendentries);
legend('boxoff');
ylabel('\Phi_{A,str}^{shear}')
xlabel('y_0')
title('Dissipation by shear per 2D stream tube (i.e. Pa*m2/s)')

% plot dissipation by deformation per streamtube versus starting point of stream tube
mm = mm + 1;
figure(mm)
hold on;
for j=1:nt
    h(j)=plot(y0_str(range,j),phi_deform_A_str(range,j),'color',map(j,:),'marker','.');
    legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
end
hold off
box on
legend(legendentries);
legend('boxoff');
ylabel('\Phi_{A,str}^{deformation}')
xlabel('y_0')
title('Dissipation by deformation per 2D stream tube (i.e. Pa*m2/s)')

% plot av. dissipation per streamtube versus starting point of stream tube
mm = mm + 1;
figure(mm)
hold on;
for j=1:nt
    h(j)=plot(y0_str(range,j),phi_av_str(range,j),'color',map(j,:),'marker','.');
    legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
end
hold off
box on
legend(legendentries);
legend('boxoff');
ylabel('\Phi_{av,str}')
xlabel('y_0')
title('Average dissipation per 2D stream tube (i.e. Pa/s)')

% plot cum. dissipation per streamtube versus starting point of stream tube
mm = mm + 1;
figure(mm)
hold on;
for j=1:nt
    h(j)=plot(y0_str(range,j),cum_phi_A_str(range,j),'color',map(j,:),'marker','.');
    legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
end
hold off
box on
legend(legendentries);
legend('boxoff');
ylabel('\Sigma \Phi_{A,str}')
xlabel('y_0')
title('Cumulative dissipation per 2D stream tube (i.e. Pa*m2/s)')

% plot total dissipation versus protrusion angle
mm = mm + 1;
maptotaldiss=cbrewer('seq','OrRdBlGr',3);
figure(mm)
hold on
plot(theta,phi_A,'color',maptotaldiss(1,:),'marker','o')
%plot(theta,phi_shear_A,'color',maptotaldiss(2,:),'marker','s')
plot(theta,phi_A_HP,'color',maptotaldiss(3,:),'marker','v')
hold off
box on
xlabel('\theta [deg]')
ylabel('\Phi_{A}, \Phi_{A,HP}')
legend('\Phi_{A}','\Phi_{A}^{shear}','\Phi_{A,HP}')
legend boxoff
title('Dissipation per 2D unit (i.e. Pa*m2/s): total, for H-P')

% plot effective slip length
mm = mm + 1;
maptotaldiss=cbrewer('seq','OrRdBlGr',3);
figure(mm)
hold on
plot(theta,boverLg,'color',maptotaldiss(1,:),'marker','o')
plot(theta_anal./pi.*180,boverLg_anal,'--k')
hold off
box on
xlabel('\theta [deg]')
ylabel('2b/L_g')
legend('2b/L_g','2b/L_g (anal. eq.)')
legend boxoff
title('Effective slip length')

% compare phi_A from simulations with that computed from b
mm = mm + 1;
maptotaldiss=cbrewer('seq','OrRdBlGr',3);
figure(mm)
hold on
plot(theta,phi_A,'color',maptotaldiss(1,:),'marker','o')
plot(theta,12./a.*(b+1)./(1+4.*b),'color',maptotaldiss(3,:),'marker','v')
hold off
box on
xlabel('\theta [deg]')
ylabel('\Phi_A')
legend('Phi_A (comp.)','Phi_A (from b)')
legend boxoff

% Combined plot of b/R and Phi versus theta
%\definecolor{mycolor2}{rgb}{0.92157,0.25098,0.23137}%
%\definecolor{mycolor6}{rgb}{0.15294,0.26275,0.53725}%
mm = mm + 1;
figure(mm)
hold on
[ax,hline1,hline2] = plotyy(theta,b,theta,phi_A);
set(hline1,'LineStyle','-','Marker','o','Color',[0.92157,0.25098,0.23137]);
set(hline2,'LineStyle','-','Marker','s','Color',[0.15294,0.26275,0.53725]);
set(ax(1),'XScale','lin','ycolor','k','YTick',[-0.04:0.02:0.04]);
set(ax(2),'XScale','lin','ycolor','k','YTick',[5:0.5:7]);
ylabel(ax(1),'$\tilde{b}$');
ylabel(ax(2),'$\tilde{\Phi}$');
% hold(ax(1));
% hold(ax(2));
% plot(ax(1),theta_anal./pi.*180,boverLg_anal,'--k');
hold off
% xlim(hax(1),[1e-5 100]);
% xlim(hax(2),[1e-5 100]);
ylim(ax(1),[-0.04 0.04]);
ylim(ax(2),[5 7]);
set(gcf,'Color','w');
box on
xlabel('$\vartheta$');
legend('$\tilde{b}$','$\tilde{\Phi}$');
legend('Location','NorthWest');
legend('boxoff');

tikzfile = ['VDanalysis_figures\b_and_Phi.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');

% -------------------------------------------------------------------------
% ALL POSSIBLE FIGURES BELOW
% MANY OF THEM ARE NOT/NO LONGER RELEVANT
% FIGURES ABOVE ARE A SELECTION OF THESE
% -------------------------------------------------------------------------

% % plot dissipation per streamtube versus starting point of stream tube
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),phi_A_str(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% hold off
% box on
% legend(legendentries);
% legend('boxoff');
% ylabel('\phi_{A,str}')
% xlabel('y_0')
% title('Dissipation per 2D stream tube (i.e. Pa*m2/s)')
%
% % plot dissipation per streamtube versus starting point of stream tube
% % + top of bubble
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),phi_A_str(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% plot(Hb,phi_A_str_max,'-k')
% legendentries{j+1} = ['y_b (top of bubble)'];
% hold off
% box on
% legend(legendentries);
% legend('boxoff');
% ylabel('\phi_{A,str}')
% xlabel('y_0')
% title('Dissipation per 2D stream tube (i.e. Pa*m2/s)')
% clearvars legendentries
% 
% % plot diss. per streamtube versus starting point of stream tube for H-P flow
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),phi_A_str_HP(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% hold off
% box on
% legend(legendentries);
% legend('boxoff');
% ylabel('\phi_{A,str,HP}')
% xlabel('y_0')
% title(['Dissipation per 2D stream tube (i.e. Pa*m2/s) for ' title_HP{1}])
% 
% % plot dissipation by shear per streamtube versus starting point of stream tube
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),phi_shear_A_str(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% hold off
% box on
% legend(legendentries);
% legend('boxoff');
% ylabel('\phi_{A,str}^{shear}')
% xlabel('y_0')
% title('Dissipation by shear per 2D stream tube (i.e. Pa*m2/s)')
% 
% % plot dissipation by deformation per streamtube versus starting point of stream tube
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),phi_deform_A_str(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% hold off
% box on
% legend(legendentries);
% legend('boxoff');
% ylabel('\phi_{A,str}^{deformation}')
% xlabel('y_0')
% title('Dissipation by deformation per 2D stream tube (i.e. Pa*m2/s)')
% 
% % plot av. dissipation per streamtube versus starting point of stream tube
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),phi_av_str(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% hold off
% box on
% legend(legendentries);
% legend('boxoff');
% ylabel('\phi_{av,str}')
% xlabel('y_0')
% title('Average dissipation per 2D stream tube (i.e. Pa/s)')
% 
% % plot cum. dissipation per streamtube versus starting point of stream tube
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),cum_phi_A_str(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% hold off
% box on
% legend(legendentries);
% legend('boxoff');
% ylabel('\Sigma \phi_{A,str}')
% xlabel('y_0')
% title('Cumulative dissipation per 2D stream tube (i.e. Pa*m2/s)')
% 
% % plot cum. dissipation by shear per streamtube versus starting point of stream tube
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),cum_phi_shear_A_str(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% hold off
% box on
% legend(legendentries);
% legend('boxoff');
% ylabel('\Sigma \phi_{A,str}^{shear}')
% xlabel('y_0')
% title('Cumulative dissipation by shear per 2D stream tube (i.e. Pa*m2/s)')
% 
% % plot cum. dissipation by deformation per streamtube versus starting point of stream tube
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),cum_phi_deform_A_str(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% hold off
% box on
% legend(legendentries);
% legend('boxoff');
% ylabel('\Sigma \phi_{A,str}^{deform}')
% xlabel('y_0')
% title('Cumulative dissipation by deformation per 2D stream tube (i.e. Pa*m2/s)')
% 
% % plot dissipation per streamtube versus starting point of stream tube
% % relative to H-P flow
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),phi_A_str(range,j)./phi_A_str_HP(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% hold off
% box on
% ylim([0 2])
% legend(legendentries);
% legend('boxoff');
% ylabel('\phi_{A,str}/\phi_{A,str,HP}')
% xlabel('y_0')
% title(['Dissipation per 2D stream tube (i.e. Pa*m2/s) relative to ' title_HP{1}])
% 
% % plot dissipation by shear per streamtube versus starting point of stream tube
% % relative to H-P flow
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),phi_shear_A_str(range,j)./phi_A_str_HP(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% hold off
% box on
% ylim([0 2])
% legend(legendentries);
% legend('boxoff');
% ylabel('\phi_{A,str}^{shear}/\phi_{A,str,HP}')
% xlabel('y_0')
% title(['Dissipation by shear per 2D stream tube (i.e. Pa*m2/s) relative to ' title_HP{1}])
% 
% % plot average dissipation per streamtube versus starting point of stream tube
% % relative to H-P flow
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),phi_av_str(range,j)./phi_av_str_HP(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% hold off
% box on
% ylim([0 3])
% legend(legendentries);
% legend('boxoff');
% ylabel('\phi_{av,str}/\phi_{av,str,HP}')
% xlabel('y_0')
% title(['Average dissipation per 2D stream tube (i.e. Pa/s) relative to ' title_HP{1}])
% 
% % plot cumulative dissipation per streamtube versus starting point of stream tube
% % relative to H-P flow
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),cum_phi_A_str(range,j)./cum_phi_A_str_HP(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% hold off
% box on
% legend(legendentries);
% legend('boxoff');
% ylabel('\Sigma \phi_{A,str}/\Sigma \phi_{A,str,HP}')
% xlabel('y_0')
% title(['Cumulative dissipation per 2D stream tube (i.e. Pa*m2/s) relative to ' title_HP{1}])
% 
% % plot cumulative dissipation by shear per streamtube versus starting point of stream tube
% % relative to H-P flow
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),cum_phi_shear_A_str(range,j)./cum_phi_A_str_HP(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% hold off
% box on
% legend(legendentries);
% legend('boxoff');
% ylabel('\Sigma \phi_{A,str}^{shear}/\Sigma \phi_{A,str,HP}')
% xlabel('y_0')
% title(['Cumulative dissipation by shear per 2D stream tube (i.e. Pa*m2/s) relative to ' title_HP{1}])
% 
% % plot x-directional velocity in streamtube versus starting point of stream tube
% % relative to H-P flow
% mm = mm + 1;
% figure(mm)
% hold on;
% for j=1:nt
%     h(j)=plot(y0_str(range,j),ux_av_str(range,j)./ux_av_str_HP(range,j),'color',map(j,:),'marker','.');
%     legendentries{j} = ['\theta = ' num2str(theta(j)) ' deg'];
% end
% hold off
% box on
% legend(legendentries);
% legend('boxoff');
% ylabel('u_{x,str}/u_{x,str,HP}')
% xlabel('y_0')
% ylim([0.5 1.5])
% title(['x-Directional flow velocity relative to ' title_HP{1}])
% 
% % plot total dissipation versus protrusion angle
% mm = mm + 1;
% maptotaldiss=cbrewer('seq','OrRdBlGr',3);
% figure(mm)
% hold on
% plot(theta,phi_A./u_av.^2,'color',maptotaldiss(1,:),'marker','o')
% plot(theta,phi_shear_A./u_av.^2,'color',maptotaldiss(2,:),'marker','s')
% % plot(theta,phi_deform_A,'color',maptotaldiss(3,:),'marker','v')
% plot(theta,phi_A_HP./u_av.^2,'color',maptotaldiss(3,:),'marker','v')
% hold off
% box on
% xlabel('theta [deg]')
% % ylabel('\phi_{A}, \phi_{A}^{shear}, \phi_{A}^{deformation}')
% % legend('\phi_{A}','\phi_{A}^{shear}','\phi_{A}^{deformation}')
% ylabel('\phi_{A}, \phi_{A}^{shear}, \phi_{A,HP}')
% legend('\phi_{A}','\phi_{A}^{shear}','\phi_{A,HP}')
% legend boxoff
% title('Dissipation per 2D unit (i.e. Pa*m2/s): total, by shear, by H-P')
% 
% % plot total dissipation by deformation versus protrusion angle
% mm = mm + 1;
% maptotaldiss=cbrewer('seq','OrRdBlGr',3);
% figure(mm)
% hold on
% plot(theta,phi_deform_A,'color',maptotaldiss(3,:),'marker','v')
% hold off
% box on
% xlabel('theta [deg]')
% ylabel('\phi_{A}^{deformation}')
% legend('\phi_{A}^{deformation}')
% legend boxoff
% title('Dissipation per 2D unit (i.e. Pa*m2/s): by deformation')
% 
% % plot energy penalty for sub-optimal velocity distribution
% mm = mm + 1;
% maptotaldiss=cbrewer('seq','OrRdBlGr',3);
% figure(mm)
% hold on
% plot(theta,phi_A./phi_A_HP,'color',maptotaldiss(1,:),'marker','o')
% hold off
% box on
% xlabel('theta [deg]')
% ylabel('\phi_{A}/\phi_{A,HP}')
% legend('\phi_{A}/\phi_{A,HP}')
% legend boxoff
% title('Energy penalty for sub-optimal velocity distribution')
% 
% % plot Rsquared 
% mm = mm + 1;
% maptotaldiss=cbrewer('seq','OrRdBlGr',3);
% figure(mm)
% hold on
% plot(theta,Rsquared,'color',maptotaldiss(1,:),'marker','o')
% hold off
% box on
% xlabel('theta [deg]')
% ylabel('R^2')
% legend('R^2')
% legend boxoff
% title('R^2: calculated from \phi_A with \phi_A^{HP} as a fit')
% 
% % plot effective slip length
% mm = mm + 1;
% maptotaldiss=cbrewer('seq','OrRdBlGr',3);
% figure(mm)
% hold on
% plot(theta,boverLg,'color',maptotaldiss(1,:),'marker','o')
% plot(theta,boverLg.*(Lg./Sg),'color',maptotaldiss(2,:),'marker','s')
% plot(theta,boverLg.*(Lg./Sg).*(1./Hf).^2,'color',maptotaldiss(3,:),'marker','v')
% hold off
% box on
% xlabel('theta [deg]')
% ylabel('2b/L_g')
% legend('2b/L_g','2b/L_g*(L_g/S_g)','2b/L_g*(L_g/S_g)*(H/H_f)^2')
% legend boxoff
% title('Effective slip length')
% 
% % % plot correction factors
% % mm = mm + 1;
% % maptotaldiss=cbrewer('seq','OrRdBlGr',3);
% % figure(mm)
% % hold on
% % plot(theta,Lg./Sg,'color',maptotaldiss(1,:),'marker','o')
% % plot(theta,(1./Hf).^2,'color',maptotaldiss(2,:),'marker','s')
% % plot(theta,(Lg./Sg).*(1./Hf).^2,'color',maptotaldiss(3,:),'marker','v')
% % hold off
% % box on
% % xlabel('theta [deg]')
% % ylabel('L_g/S_g, (H/H_f)^2, (L_g/S_g)*(H/H_f)^2')
% % legend('L_g/S_g','(H/H_f)^2','(L_g/S_g)*(H/H_f)^2')
% % legend boxoff
% % title('Correction factors')
% 
% % % plot effective slip length
% % mm = mm + 1;
% % maptotaldiss=cbrewer('seq','OrRdBlGr',3);
% % figure(mm)
% % hold on
% % plot(theta,boverLg.*((1+4.*Lg)./(1+Lg))./((1+4.*Sg)./(1+Sg)),'color',maptotaldiss(2,:),'marker','s')
% % plot(theta,boverLg.*((1+4.*Lg)./(1+Lg))./((1+4.*Sg)./(1+Sg)).*(1./(1 + 3.*Lg./(Lg + 1)))./(1./(1 + 3.*Sg./(Sg + Hf))),'color',maptotaldiss(3,:),'marker','v')
% % hold off
% % box on
% % xlabel('theta [deg]')
% % ylabel('2b/L_g')
% % legend('(2b/L_g)*L_g/((1+4S_g)/(1+S_g))','(2b/L_g)*L_g/((1+4S_g)/(1+S_g))*1/(1+3S_g/(S_g + H_f))')
% % legend boxoff
% % title('Effective slip length')
% 
% % % plot correction factors
% % mm = mm + 1;
% % maptotaldiss=cbrewer('seq','OrRdBlGr',3);
% % figure(mm)
% % hold on
% % plot(theta,(Lg./(1+4.*Sg).*(1+Sg)),'color',maptotaldiss(1,:),'marker','o')
% % plot(theta,(1./(1 + 3.*Sg./(Sg + Hf))),'color',maptotaldiss(2,:),'marker','s')
% % plot(theta,(Lg./(1+4.*Sg).*(1+Sg)).*(1./(1 + 3.*Sg./(Sg + Hf))),'color',maptotaldiss(3,:),'marker','v')
% % hold off
% % box on
% % xlabel('theta [deg]')
% % ylabel('L_g/((1+4S_g)/(1+S_g)), 1/(1+3S_g/(S_g + H_f)), L_g/((1+4S_g)/(1+S_g))*1/(1+3S_g/(S_g + H_f))')
% % legend('L_g/((1+4S_g)/(1+S_g))','1/(1+3S_g/(S_g + H_f))','L_g/((1+4S_g)/(1+S_g))*1/(1+3S_g/(S_g + H_f))')
% % legend boxoff
% % title('Correction factors')
% 
% % plot effective slip length
% mm = mm + 1;
% maptotaldiss=cbrewer('seq','OrRdBlGr',3);
% figure(mm)
% hold on
% plot(theta,boverLg,'color',maptotaldiss(1,:),'marker','o')
% plot(theta,boverLg3,'color',maptotaldiss(2,:),'marker','s')
% plot(theta_anal./pi.*180,boverLg_anal,'--k')
% hold off
% box on
% xlabel('theta [deg]')
% ylabel('2b/L_g')
% legend('2b/L_g (based on u_{av}','2b/L_g (based on P)','2b/L_g (analytical model Davis & Lauga)')
% legend boxoff
% title('Effective slip length')
% 
% % plot average flow velocity
% mm = mm + 1;
% maptotaldiss=cbrewer('seq','OrRdBlGr',3);
% figure(mm)
% hold on
% plot(theta,u_av,'color',maptotaldiss(1,:),'marker','o')
% plot(theta,ux_av_HP,'color',maptotaldiss(2,:),'marker','s')
% hold off
% box on
% xlabel('theta [deg]')
% ylabel('u_{av}')
% legend('u_{av}','u_{av,HP}')
% legend boxoff
% title('Average flow velocity')
    
end