function davis_lauga_slip_v7_sander()

close all;
clear all;
%hold on
clc;
format short e

%theta_vec = linspace(0/180*pi,30/180*pi,3);
theta_vec = pi./180.*[0:3:30];

% make colormap based on length of theta_vec
nt = length(theta_vec);
map=cbrewer('seq','OrRdBlGr',nt);

n_mean = zeros(length(theta_vec),1);
resnorm = zeros(length(theta_vec),1);
std_n_mean = zeros(length(theta_vec),1);
B_vec = zeros(length(theta_vec),1);
D_vec = zeros(length(theta_vec),1);
for k =1:length(theta_vec)
    theta = theta_vec(k)
    xi_vec =  linspace(5,15,50);
    eta_vec = (linspace(theta,pi,50));

    [Xi Eta] = meshgrid(xi_vec,eta_vec);

    X = cosh(Xi)./(cosh(Xi)+cos(Eta));
    Y = sin(Eta)./(cosh(Xi)+cos(Eta));
    Psi_Farfield = 1/2*(sin(Eta)).^2./(cosh(Xi)+cos(Eta)).^2;
%close all
s = linspace(1e-9,20,10000);
Psi_Perturb = zeros(length(eta_vec),length(xi_vec));
for i = 1:length(eta_vec)
    eta = eta_vec(i);
    for j = 1:length(xi_vec)
        xi = xi_vec(j);
        f1 = -(sinh(s*(pi - eta)).*sin(eta).*(cos(2*theta) + (sinh(s.*(pi - 2*theta)) + s.*sin(2*theta).*cosh(pi*s))./sinh(pi*s)))./(sinh(2*s.*(pi - theta)) + s.*sin(2*theta));
        f2 = (sin(2*theta).*(sinh(s.*(pi - eta))*cos(eta) + s.*cosh(s*(pi - eta)).*sin(eta)))./(sinh(2*s.*(pi - theta)) + s.*sin(2*theta));
        fInt = trapz(s,(f1+f2).*cos(s*xi));
        Psi_Perturb(i,j) = -fInt./(cosh(xi)+cos(eta));
    end
end
Psi = Psi_Farfield+Psi_Perturb;
Psi = Psi.*(Psi>0);


% x = r*cos(theta)+1
% y = r*sin(theta)
% x^2+y^2 = r^2+1
% phi = atan(y/(x-1))
R = sqrt((X-1).^2+Y.^2);
[m,p] = size(R);
Phi = zeros(m,p);
for i =1:m
    for j=1:p
        if (X(i,j)-1)>0
            Phi(i,j) = atan(Y(i,j)./(X(i,j)-1));
        else
            Phi(i,j) = pi/2+atan(abs(X(i,j)-1)./Y(i,j));
        end
    end
end

%pcolor(Phi,log10(R),log10(Psi))
%colorbar
%colormap(jet)
%close all;
R_fake = R(floor(length(xi_vec)/2),:);
Psi_fake = Psi(floor(length(xi_vec)/2),:);
options = optimset('MaxFunEvals',1e5,'MaxIter',1e6,'Display','iter','TolFun',1e-9,'TolX',1e-9);
[fit_parm resnorm res] = lsqcurvefit(@myFitFn,[1.5 0],R_fake,log(Psi_fake),[],[],options);
n = real(fit_parm(1));
n_mean(k) = n;
lnA_at_phi = log(Psi(:,floor(length(eta_vec)/2)))-n*log(R(:,floor(length(eta_vec)/2)));
A = exp(lnA_at_phi);
[p,S] = polyfit(Phi(:,floor(length(eta_vec)/2)),A,6);
p1 = polyder(p);
p2 = polyder(p1);
%plot(Phi(:,25),A,'o',Phi(:,25),polyval(p,Phi(:,25))

%close all
[R,Phi] = meshgrid(logspace(-5,-3),linspace(0,pi-theta,360));
 %C = B*sin(n*phi)+D*sin((n-2)*phi)
% dCdphi = B*n*cos(n*phi)+D*(n-2)*cos((n-2)*phi)
% dC2dphi2 = -B*n^2*sin(n*phi)-D*(n-2)^2*sin((n-2)*phi);
[xGrid_num yGrid_num] = size(Phi);
C = zeros(xGrid_num,yGrid_num);
dC_dphi = zeros(xGrid_num,yGrid_num);
d2C_dphi2 = zeros(xGrid_num,yGrid_num);
for i = 1:xGrid_num
    for j = 1:yGrid_num
        C(i,j) = polyval(p,Phi(i,j));
        dC_dphi(i,j) = polyval(p1,Phi(i,j));
        d2C_dphi2(i,j) = polyval(p2,Phi(i,j));
    end
end

Uphi = -n_mean(k).*R.^(n_mean(k)-1).*C;
Ur=dC_dphi.*R.^(n_mean(k)-1);
dUr_dr = dC_dphi.*(n_mean(k)-1).*R.^(n_mean(k)-2);
dUphi_dphi = -n_mean(k)*R.^(n_mean(k)-1).*dC_dphi;
dUr_dphi = d2C_dphi2.*R.^(n_mean(k)-1);
dUphi_over_r_dr = -n_mean(k).*(n_mean(k)-2).*C.*R.^(n_mean(k)-3);
%dUphi_over_r_dr = 0;
Psi_export(:,:,k) = C.*R.^(n_mean(k));
Psi_DL(:,:,k) = Psi;
Ur_export(:,:,k) = Ur;
Uphi_export(:,:,k) = Uphi;
VD(:,:,k) = 2*((dUr_dr).^2+(1./R.*dUphi_dphi+Ur./R).^2)+(R.*dUphi_over_r_dr+1./R.*dUr_dphi).^2;
max_VD(k) = max(max(VD(:,:,k)));
Phi_Plotting(:,:,k) = Phi;
R_Plotting(:,:,k) = R;
legendentry{k}=num2str(theta_vec(k)*180/pi);
phi_supervec = linspace(5/180*pi,pi*(1-5/180)-theta);
C_vec = polyval(p,phi_supervec);

FitParmABCD(k,:) = [cos(n_mean(k)*phi_supervec') sin(n_mean(k)*phi_supervec') cos((n_mean(k)-2)*phi_supervec') sin((n_mean(k)-2)*phi_supervec')]\C_vec';

% figure 1
figure(1)
%plot(phi_supervec,C_vec,'-.')
plot(phi_supervec.*180./pi,C_vec,'color',map(k,:),'marker','none')
%pcolor(X,Y,Psi)
%colorbar
%shading interp
%colormap(jet)
%input('Hit Enter')
hold on
end
hold off
xlabel('\phi')
ylabel('C');
legend(legendentry,'Location','NorthWest');
legend('boxoff');
tikzfile = ['tikz_figures\C_phi.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');

% calculation of analytical value of lambda (Moffat exponent)
theta_analytical = linspace(min(theta_vec),max(theta_vec),31);
n_analytical = actLambda(theta_analytical);

mm = 1;
mm = mm + 1;
figure(mm)
hold on
plot(theta_vec*180/pi,n_mean,'o','Color',[0.15294,0.26275,0.53725]);
plot(theta_analytical*180/pi,n_analytical,'Color',[0.92157,0.25098,0.23137]);
%title('Exponent vs. Theta')
hold off
box on
xlabel('\vartheta')
ylabel('\lambda')
legend('\lambda num.','\lambda anal.','Location','NorthWest') 
legend('boxoff');
tikzfile = ['tikz_figures\lambda_theta.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');

% figure(2)
% theta_analytical = linspace(min(theta_vec),max(theta_vec),31);
% n_analytical = actLambda(theta_analytical);
% plot(theta_vec*180/pi,n_mean,'o',theta_analytical*180/pi,n_analytical,'--')
% title('Exponent vs. Theta')
% xlabel('Theta')
% ylabel('Moffat Exponent')

mm = mm + 1;
figure(mm)
plot(theta_vec*180/pi,100*sqrt(resnorm)/length(eta_vec),'o')
title('Percent Fit Error vs. Theta')
xlabel('Theta')
ylabel('Fit Error')

% figure(3)
% plot(theta_vec*180/pi,100*sqrt(resnorm)/length(eta_vec),'o')
% title('Percent Fit Error vs. Theta')
% xlabel('Theta')
% ylabel('Fit Error')

mm = mm + 1;
figure(mm)
plot(theta_vec*180/pi,log10(max_VD),'o','Color',[0.15294,0.26275,0.53725])
%title('Max Viscous Dissipation vs. Bubble Angle(log10)')
xlabel('\vartheta')
ylabel('log_{10} \Phi_{max}')
tikzfile = ['tikz_figures\Phimax_theta.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');

mm = mm + 1;
figure(mm)
hold on
plot(theta_vec*180/pi,log10(max_VD./max_VD(1)),'o','Color',[0.15294,0.26275,0.53725]);
plot(theta_analytical*180/pi,log10(min(min(R)).^(2.*n_analytical-3)),'Color',[0.92157,0.25098,0.23137]);
%title('Max Viscous Dissipation vs. Bubble Angle(log10)')
hold off
box on
xlabel('\vartheta')
ylabel('log_{10}[\Phi_{max}(\vartheta) / \Phi_{max}(0)]')
legend('Num.','Anal. (r^{2\lambda - 1})','Location','SouthWest') 
legend('boxoff');
tikzfile = ['tikz_figures\RatioPhimax_theta.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');

% figure(4)
% plot(theta_vec*180/pi,((max_VD)/(max_VD(1))),'o',theta_vec*180/pi,((1e-5.^(2*n_analytical-3))),'--')
% title('Max Viscous Dissipation vs. Bubble Angle')
% xlabel('Theta')
% ylabel('VD rate')

for i =1:length(theta_vec)
    mm = mm + 1;
    figure(mm)
    pcolor(log10(R_Plotting(:,:,i)),180/pi*Phi_Plotting(:,:,i),log10(VD(:,:,i)))
    shading interp
    colormap(jet)
    colorbar
    hold on
    [c1,h1]=contour(log10(R_Plotting(:,:,i)),180/pi*(Phi_Plotting(:,:,i)),Psi_export(:,:,i),'LevelList',logspace(-8,-1,10),'LevelListMode','manual');
    h1.LineColor=[1 1 1];
    h1.LineWidth=3;
    box on
    title(['\Phi for ' legendentry{i}])
    xlabel('log10(r)')
    ylabel('\phi')
    hold off
    if i == 1
        tikzfile = ['tikz_figures\surfaceplot_Phi.tikz'];
        matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');
    else
    end
end

% for i =1:length(theta_vec)
%     figure(5+i)
%     pcolor(log10(R_Plotting(:,:,i)),180/pi*Phi_Plotting(:,:,i),log10(VD(:,:,i)))
% 
%     shading interp
%     colormap(jet)
%     colorbar
%     hold on
%     [c1,h1]=contour(log10(R_Plotting(:,:,i)),180/pi*(Phi_Plotting(:,:,i)),Psi_export(:,:,i),'LevelList',logspace(-8,-1,10),'LevelListMode','manual');
%     h1.LineColor=[1 1 1];
%     h1.LineWidth=4;
%     title(['Viscous Dissipation for theta=',legendentry(i)])
%     xlabel('log10(r)')
%     ylabel('phi')
%     hold off
% end

for i=1:(4+i)
h=findobj('type','figure'); % find the handles of the opened figures
 filename=sprintf('image%d.jpg',i);
 file=fullfile(filename);
saveas(h(i),file);
end

function F = actLambda(theta)

alpha = pi-theta;
nguess = 1.5*ones(length(theta),1);
F = fsolve(@moffatSolve,nguess',[],alpha);

function G = moffatSolve(mu,alpha)

G = sin(2*(mu-1).*alpha)-(mu-1).*sin(2*alpha);
function G = davisLaugaInt(s,xi,eta,theta)

f1 = -(sinh(s*(pi - eta)).*sin(eta).*(cos(2*theta) + (sinh(s.*(pi - 2*theta)) + s.*sin(2*theta).*cosh(pi*s))./sinh(pi*s)))./(sinh(2*s.*(pi - theta)) + s.*sin(2*theta));
f2 = (sin(2*theta).*(sinh(s.*(pi - eta))*cos(eta) + s.*cosh(s*(pi - eta)).*sin(eta)))./(sinh(2*s.*(pi - theta)) + s.*sin(2*theta));
f3 = cos(s*xi);
G = (f1+f2).*f3;


function F = myFitFn(betas,R)
n = betas(1);
lnA = betas(2);
F = lnA + n*log(R);


