#Section 1: Create clean R workspace ----
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014")
Sys.setenv(LANG = "en")
options(max.print = 20000)

#Section 2: Open libraries and datasets ----
#Open packages:
Pkgs2Load <- c("readxl","tidyr", "ggplot2", "ggh4x", "emmeans", "multcomp", "glmmTMB", "DHARMa", "vegan", "dplyr")
invisible(lapply(Pkgs2Load, library, character.only = TRUE))

#Set the working directory.
setwd("[SET LOCATION]")

#Import data files
Wag <- read.csv("GB_4loc_Data_Wageningen_2019-2022.csv", row.names = 1)

Alm20 <- read.csv("GB_4loc_Data_Almere_2020.csv", row.names = 1)
Alm21 <- read.csv("GB_4loc_Data_Almere_2021-2022.csv", row.names = 1)

Val <- read.csv("GB_4loc_Data_Valthermond_2020-2021.csv", row.names = 1)


#Section 3: Prepare the data ----
#Subsection 3.1: Wageningen ----
#Subsection 3.1.1: Calculate rarefaction per field
Y2019.cab    <- specaccum(Wag[Wag$Year == "2019" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Cabbage",c(10:70)], method = "exact", )$richness[4]
Y2019.whe    <- specaccum(Wag[Wag$Year == "2019" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Wheat"  ,c(10:70)], method = "exact", )$richness[4]
Y2019.cabwhe <- specaccum(Wag[Wag$Year == "2019" & Wag$Treatment == "STRIP"                               ,c(10:70)], method = "exact", )$richness[4]

Y2020.cab    <- specaccum(Wag[Wag$Year == "2020" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Cabbage",c(10:70)], method = "exact", )$richness[4]
Y2020.whe    <- specaccum(Wag[Wag$Year == "2020" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Wheat"  ,c(10:70)], method = "exact", )$richness[4]
Y2020.cabwhe <- specaccum(Wag[Wag$Year == "2020" & Wag$Treatment == "STRIP"                               ,c(10:70)], method = "exact", )$richness[4]

Y2021.cab    <- specaccum(Wag[Wag$Year == "2021" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Cabbage"                        ,c(10:70)], method = "exact", )$richness[6]
Y2021.oat    <- specaccum(Wag[Wag$Year == "2021" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Oat"                            ,c(10:70)], method = "exact", )$richness[6]
Y2021.caboat <- specaccum(Wag[Wag$Year == "2021" & Wag$Treatment == "STRIP"     &(Wag$Crop == "Cabbage" | Wag$Crop == "Oat"),c(10:70)], method = "exact", )$richness[6]
Y2021.pot    <- specaccum(Wag[Wag$Year == "2021" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Potato"                         ,c(10:70)], method = "exact", )$richness[6]
Y2021.gra    <- specaccum(Wag[Wag$Year == "2021" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Grass"                          ,c(10:70)], method = "exact", )$richness[6]
Y2021.potgra <- specaccum(Wag[Wag$Year == "2021" & Wag$Treatment == "STRIP"     &(Wag$Crop == "Potato" | Wag$Crop == "Grass"),c(10:70)], method = "exact", )$richness[6]
Y2021.pum    <- specaccum(Wag[Wag$Year == "2021" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Pumpkin"                        ,c(10:70)], method = "exact", )$richness[6]
Y2021.bar    <- specaccum(Wag[Wag$Year == "2021" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Barley"                            ,c(10:70)], method = "exact", )$richness[6]
Y2021.pumbar <- specaccum(Wag[Wag$Year == "2021" & Wag$Treatment == "STRIP"     &(Wag$Crop == "Pumpkin" | Wag$Crop == "Barley"),c(10:70)], method = "exact", )$richness[6]

Y2022.cab    <- specaccum(Wag[Wag$Year == "2022" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Cabbage"                        ,c(10:70)], method = "exact", )$richness[5]
Y2022.oat    <- specaccum(Wag[Wag$Year == "2022" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Oat"                            ,c(10:70)], method = "exact", )$richness[5]
Y2022.caboat <- specaccum(Wag[Wag$Year == "2022" & Wag$Treatment == "STRIP"     &(Wag$Crop == "Cabbage" | Wag$Crop == "Oat"),c(10:70)], method = "exact", )$richness[5]
Y2022.pot    <- specaccum(Wag[Wag$Year == "2022" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Potato"                         ,c(10:70)], method = "exact", )$richness[6]
Y2022.gra    <- specaccum(Wag[Wag$Year == "2022" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Grass"                          ,c(10:70)], method = "exact", )$richness[6]
Y2022.potgra <- specaccum(Wag[Wag$Year == "2022" & Wag$Treatment == "STRIP"     &(Wag$Crop == "Potato" | Wag$Crop == "Grass"),c(10:70)], method = "exact", )$richness[6]
Y2022.pum    <- specaccum(Wag[Wag$Year == "2022" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Pumpkin"                        ,c(10:70)], method = "exact", )$richness[6]
Y2022.bar    <- specaccum(Wag[Wag$Year == "2022" & Wag$Treatment == "REF_SPACE" & Wag$Crop == "Barley"                            ,c(10:70)], method = "exact", )$richness[6]
Y2022.pumbar <- specaccum(Wag[Wag$Year == "2022" & Wag$Treatment == "STRIP"     &(Wag$Crop == "Pumpkin" | Wag$Crop == "Barley"),c(10:70)], method = "exact", )$richness[6]


#Subsection 3.1.2: Calculate rate of change
Y2019.c <- (Y2019.cabwhe - Y2019.cab) / Y2019.cab
Y2019.w <- (Y2019.cabwhe - Y2019.whe) / Y2019.whe

Y2020.c <- (Y2020.cabwhe - Y2020.cab) / Y2020.cab
Y2020.w <- (Y2020.cabwhe - Y2020.whe) / Y2020.whe

Y2021.c  <- (Y2021.caboat - Y2021.cab) / Y2021.cab
Y2021.o  <- (Y2021.caboat - Y2021.oat) / Y2021.oat
Y2021.po <- (Y2021.potgra - Y2021.pot) / Y2021.pot
Y2021.g  <- (Y2021.potgra - Y2021.gra) / Y2021.gra
Y2021.pu <- (Y2021.pumbar - Y2021.pum) / Y2021.pum
Y2021.b  <- (Y2021.pumbar - Y2021.bar) / Y2021.bar

Y2022.c <- (Y2022.caboat - Y2022.cab) / Y2022.cab
Y2022.o <- (Y2022.caboat - Y2022.oat) / Y2022.oat
Y2022.po <- (Y2022.potgra - Y2022.pot) / Y2022.pot
Y2022.g  <- (Y2022.potgra - Y2022.gra) / Y2022.gra
Y2022.pu <- (Y2022.pumbar - Y2022.pum) / Y2022.pum
Y2022.b  <- (Y2022.pumbar - Y2022.bar) / Y2022.bar


#Subsection 3.1.3: Merge data
WagF <- as.data.frame(c(Y2019.c,Y2019.w,
                          Y2020.c,Y2020.w,
                          Y2021.c,Y2021.o,Y2021.po,Y2021.g,Y2021.pu,Y2021.b,
                          Y2022.c,Y2022.o,Y2022.po,Y2022.g,Y2022.pu,Y2022.b))
WagF$Year <- c(rep(2019,2),rep(2020,2),rep(2021,6),rep(2022,6))
WagF$Crop <- c(rep(c("Cabbage","Wheat"),2), rep(c("Cabbage","Oat","Potato","Grass","Pumpkin","Barley"),2))
WagF$Croppair <- c(rep("CabWhe",4), rep(c("CabOat","CabOat","PotGra","PotGra","PumBar","PumBar"),2))
WagF$Location <- "Wageningen"
colnames(WagF)[1] <- "Change_strip_cropping"


#Subsection 3.1.4: Calculate average constitutive fields
Y2019.avcw <- (Y2019.cab + Y2019.whe)/2
Y2020.avcw <- (Y2020.cab + Y2020.whe)/2
Y2021.avco <- (Y2021.cab + Y2021.oat)/2
Y2021.avpg <- (Y2021.pot + Y2021.gra)/2
Y2021.avpb <- (Y2021.pum + Y2021.bar)/2
Y2022.avco <- (Y2022.cab + Y2022.oat)/2
Y2022.avpg <- (Y2022.pot + Y2022.gra)/2
Y2022.avpb <- (Y2022.pum + Y2022.bar)/2

#Subsection 3.1.5: Merge average monoculture and strip cropping data
WagAv <- as.data.frame(c(Y2019.avcw,Y2020.avcw,
                           Y2021.avco,Y2021.avpg,Y2021.avpb,
                           Y2022.avco,Y2022.avpg,Y2022.avpb,
                           Y2019.cabwhe,Y2020.cabwhe,
                           Y2021.caboat,Y2021.potgra,Y2021.pumbar,
                           Y2022.caboat,Y2022.potgra,Y2022.pumbar))
colnames(WagAv)[1] <- "Richness"
WagAv$Year <- c(rep(c(2019,2020,2021,2021,2021,2022,2022,2022),2))
WagAv$Treatment <- c(rep("Monoculture",8), rep("Strip",8))
WagAv$Croppair <- rep(c(rep("CabWhe",2), rep(c("CabOat","PotGra","PumBar"),2)),2)
WagAv$Location <- "Wageningen"


#Subsection 3.2: Almere ----
#Subsection 3.2.1: Calculate rarefaction
E2020.oat    <- specaccum(Alm20[Alm20$Block == "1" & Alm20$TRT == "mono" & Alm20$Crop == "Oat"     ,c(8:20)], method = "exact", )$richness[4]
E2020.gra    <- specaccum(Alm20[Alm20$Block == "1" & Alm20$TRT == "mono" & Alm20$Crop == "Grass"   ,c(8:20)], method = "exact", )$richness[4]
E2020.oatgra <- specaccum(Alm20[Alm20$Block == "1" & Alm20$TRT == "strip"                           ,c(8:20)], method = "exact", )$richness[4]
E2020.pot    <- specaccum(Alm20[Alm20$Block == "2" & Alm20$TRT == "mono" & Alm20$Crop == "Potato"  ,c(8:20)], method = "exact", )$richness[4]
E2020.bro    <- specaccum(Alm20[Alm20$Block == "2" & Alm20$TRT == "mono" & Alm20$Crop == "Broccoli",c(8:20)], method = "exact", )$richness[4]
E2020.potbro <- specaccum(Alm20[Alm20$Block == "2" & Alm20$TRT == "strip"                           ,c(8:20)], method = "exact", )$richness[4]
E2020.bea    <- specaccum(Alm20[Alm20$Block == "3" & Alm20$TRT == "mono" & Alm20$Crop == "Beans"   ,c(8:20)], method = "exact", )$richness[4]
E2020.cel    <- specaccum(Alm20[Alm20$Block == "3" & Alm20$TRT == "mono" & Alm20$Crop == "Celeriac",c(8:20)], method = "exact", )$richness[4]
E2020.beacel <- specaccum(Alm20[Alm20$Block == "3" & Alm20$TRT == "strip"                           ,c(8:20)], method = "exact", )$richness[4]
E2020.par    <- specaccum(Alm20[Alm20$Block == "4" & Alm20$TRT == "mono" & Alm20$Crop == "Parsnip" ,c(8:20)], method = "exact", )$richness[4]
E2020.oni    <- specaccum(Alm20[Alm20$Block == "4" & Alm20$TRT == "mono" & Alm20$Crop == "Onion"   ,c(8:20)], method = "exact", )$richness[4]
E2020.paroni <- specaccum(Alm20[Alm20$Block == "4" & Alm20$TRT == "strip"                           ,c(8:20)], method = "exact", )$richness[4]

E2021.oat    <- specaccum(Alm21[Alm21$Year == "2021" & Alm21$Block == "2" & Alm21$TRT == "mono" & Alm21$Crop == "Oat"     ,c(9:48)], method = "exact", )$richness[3]
E2021.gra    <- specaccum(Alm21[Alm21$Year == "2021" & Alm21$Block == "2" & Alm21$TRT == "mono" & Alm21$Crop == "Grass"   ,c(9:48)], method = "exact", )$richness[3]
E2021.oatgra <- specaccum(Alm21[Alm21$Year == "2021" & Alm21$Block == "2" & Alm21$TRT == "strip"                           ,c(9:48)], method = "exact", )$richness[3]
E2021.pot    <- specaccum(Alm21[Alm21$Year == "2021" & Alm21$Block == "3" & Alm21$TRT == "mono" & Alm21$Crop == "Potato"  ,c(9:48)], method = "exact", )$richness[4]
E2021.bro    <- specaccum(Alm21[Alm21$Year == "2021" & Alm21$Block == "3" & Alm21$TRT == "mono" & Alm21$Crop == "Broccoli",c(9:48)], method = "exact", )$richness[4]
E2021.potbro <- specaccum(Alm21[Alm21$Year == "2021" & Alm21$Block == "3" & Alm21$TRT == "strip"                           ,c(9:48)], method = "exact", )$richness[4]
E2021.bea    <- specaccum(Alm21[Alm21$Year == "2021" & Alm21$Block == "4" & Alm21$TRT == "mono" & Alm21$Crop == "Beans"   ,c(9:48)], method = "exact", )$richness[4]
E2021.par    <- specaccum(Alm21[Alm21$Year == "2021" & Alm21$Block == "4" & Alm21$TRT == "mono" & Alm21$Crop == "Parsnip" ,c(9:48)], method = "exact", )$richness[4]
E2021.beapar <- specaccum(Alm21[Alm21$Year == "2021" & Alm21$Block == "4" & Alm21$TRT == "strip"                           ,c(9:48)], method = "exact", )$richness[4]
E2021.cel    <- specaccum(Alm21[Alm21$Year == "2021" & Alm21$Block == "1" & Alm21$TRT == "mono" & Alm21$Crop == "Celeriac",c(9:48)], method = "exact", )$richness[4]
E2021.oni    <- specaccum(Alm21[Alm21$Year == "2021" & Alm21$Block == "1" & Alm21$TRT == "mono" & Alm21$Crop == "Onion"   ,c(9:48)], method = "exact", )$richness[4]
E2021.celoni <- specaccum(Alm21[Alm21$Year == "2021" & Alm21$Block == "1" & Alm21$TRT == "strip"                           ,c(9:48)], method = "exact", )$richness[4]

E2022.oat    <- specaccum(Alm21[Alm21$Year == "2022" & Alm21$Block == "3" & Alm21$TRT == "mono" & Alm21$Crop == "Oat"     ,c(9:48)], method = "exact", )$richness[4]
E2022.gra    <- specaccum(Alm21[Alm21$Year == "2022" & Alm21$Block == "3" & Alm21$TRT == "mono" & Alm21$Crop == "Grass"   ,c(9:48)], method = "exact", )$richness[4]
E2022.oatgra <- specaccum(Alm21[Alm21$Year == "2022" & Alm21$Block == "3" & Alm21$TRT == "strip"                           ,c(9:48)], method = "exact", )$richness[3]
E2022.pot    <- specaccum(Alm21[Alm21$Year == "2022" & Alm21$Block == "4" & Alm21$TRT == "mono" & Alm21$Crop == "Potato"  ,c(9:48)], method = "exact", )$richness[4]
E2022.bea    <- specaccum(Alm21[Alm21$Year == "2022" & Alm21$Block == "4" & Alm21$TRT == "mono" & Alm21$Crop == "Beans"   ,c(9:48)], method = "exact", )$richness[4]
E2022.potbea <- specaccum(Alm21[Alm21$Year == "2022" & Alm21$Block == "4" & Alm21$TRT == "strip"                           ,c(9:48)], method = "exact", )$richness[4]
E2022.bro    <- specaccum(Alm21[Alm21$Year == "2022" & Alm21$Block == "1" & Alm21$TRT == "mono" & Alm21$Crop == "Broccoli",c(9:48)], method = "exact", )$richness[4]
E2022.par    <- specaccum(Alm21[Alm21$Year == "2022" & Alm21$Block == "1" & Alm21$TRT == "mono" & Alm21$Crop == "Parsnip" ,c(9:48)], method = "exact", )$richness[4]
E2022.bropar <- specaccum(Alm21[Alm21$Year == "2022" & Alm21$Block == "1" & Alm21$TRT == "strip"                           ,c(9:48)], method = "exact", )$richness[4]
E2022.cel    <- specaccum(Alm21[Alm21$Year == "2022" & Alm21$Block == "2" & Alm21$TRT == "mono" & Alm21$Crop == "Celeriac",c(9:48)], method = "exact", )$richness[3]
E2022.oni    <- specaccum(Alm21[Alm21$Year == "2022" & Alm21$Block == "2" & Alm21$TRT == "mono" & Alm21$Crop == "Onion"   ,c(9:48)], method = "exact", )$richness[3]
E2022.celoni <- specaccum(Alm21[Alm21$Year == "2022" & Alm21$Block == "2" & Alm21$TRT == "strip"                           ,c(9:48)], method = "exact", )$richness[3]

#Subsection 3.2.2: Calculate rate of change
E2020.oa <- (E2020.oatgra - E2020.oat) / E2020.oat
E2020.gr <- (E2020.oatgra - E2020.gra) / E2020.gra
E2020.po <- (E2020.potbro - E2020.pot) / E2020.pot
E2020.br <- (E2020.potbro - E2020.bro) / E2020.bro
E2020.be <- (E2020.beacel - E2020.bea) / E2020.bea
E2020.ce <- (E2020.beacel - E2020.cel) / E2020.cel
E2020.pa <- (E2020.paroni - E2020.par) / E2020.par
E2020.on <- (E2020.paroni - E2020.oni) / E2020.oni

E2021.oa <- (E2021.oatgra - E2021.oat) / E2021.oat
E2021.gr <- (E2021.oatgra - E2021.gra) / E2021.gra
E2021.po <- (E2021.potbro - E2021.pot) / E2021.pot
E2021.br <- (E2021.potbro - E2021.bro) / E2021.bro
E2021.be <- (E2021.beapar - E2021.bea) / E2021.bea
E2021.pa <- (E2021.beapar - E2021.par) / E2021.par
E2021.ce <- (E2021.celoni - E2021.cel) / E2021.cel
E2021.on <- (E2021.celoni - E2021.oni) / E2021.oni

E2022.oa <- (E2022.oatgra - E2022.oat) / E2022.oat
E2022.gr <- (E2022.oatgra - E2022.gra) / E2022.gra
E2022.po <- (E2022.potbea - E2022.pot) / E2022.pot
E2022.be <- (E2022.potbea - E2022.bea) / E2022.bea
E2022.br <- (E2022.bropar - E2022.bro) / E2022.bro
E2022.pa <- (E2022.bropar - E2022.par) / E2022.par
E2022.ce <- (E2022.celoni - E2022.cel) / E2022.cel
E2022.on <- (E2022.celoni - E2022.oni) / E2022.oni

#Subsection 3.2.3: Merge data
ErfF <- as.data.frame(c(E2020.oa, E2020.gr, E2020.po, E2020.br, E2020.be, E2020.ce, E2020.pa, E2020.on,
                        E2021.oa, E2021.gr, E2021.po, E2021.br, E2021.be, E2021.ce, E2021.pa, E2021.on,
                        E2022.oa, E2022.gr, E2022.po, E2022.br, E2022.be, E2022.ce, E2022.pa, E2022.on))
ErfF$Year <- c(rep(2020,8),rep(2021,8),rep(2022,8))
ErfF$Crop <- c(rep(c("Oat","Grass","Potato","Broccoli","Beans","Celeriac","Parsnip","Onion"),3))
ErfF$Croppair <- c("OatGra","OatGra","PotBro","PotBro","BeaCel","BeaCel","ParOni","ParOni",
                   "OatGra","OatGra","PotBro","PotBro","BeaPar","CelOni","BeaPar","CelOni",
                   "OatGra","OatGra","PotBea","BroPar","PotBea","CelOni","BroPar","CelOni")
ErfF$Location <- "Almere"
colnames(ErfF)[1] <- "Change_strip_cropping"


#Subsection 3.2.4: Calculate average constitutive fields
E2020.avog <- (E2020.oat + E2020.gra)/2
E2020.avpb <- (E2020.pot + E2020.bro)/2
E2020.avbc <- (E2020.bea + E2020.cel)/2
E2020.avpo <- (E2020.par + E2020.oni)/2

E2021.avog <- (E2021.oat + E2021.gra)/2
E2021.avpb <- (E2021.pot + E2021.bro)/2
E2021.avbp <- (E2021.bea + E2021.par)/2
E2021.avco <- (E2021.cel + E2021.oni)/2

E2022.avog <- (E2022.oat + E2022.gra)/2
E2022.avpb <- (E2022.pot + E2022.bea)/2
E2022.avbp <- (E2022.bro + E2022.par)/2
E2022.avco <- (E2022.cel + E2022.oni)/2


#Subsection 3.2.5: Merge average monoculture and strip cropping data
ErfAv <- as.data.frame(c(E2020.avog,E2020.avpb,E2020.avbc,E2020.avpo,
                           E2021.avog,E2021.avpb,E2021.avbp,E2021.avco,
                           E2022.avog,E2022.avpb,E2022.avbp,E2022.avco,
                           E2020.oatgra,E2020.potbro,E2020.beacel,E2020.paroni,
                           E2021.oatgra,E2021.potbro,E2021.beapar,E2021.celoni,
                           E2022.oatgra,E2022.potbea,E2022.bropar,E2022.celoni))
colnames(ErfAv)[1] <- "Richness"
ErfAv$Year <- rep(c(rep(2020,4),rep(2021,4),rep(2022,4)),2)
ErfAv$Treatment <- c(rep("Monoculture",12), rep("Strip",12))
ErfAv$Croppair <- rep(c("OatGra","PotBro","BeaCel","ParOni",
                    "OatGra","PotBro","BeaPar","CelOni",
                    "OatGra","PotBea","BroPar","CelOni"),2)
ErfAv$Location <- "Almere"


#Subsection 3.3: Valthermond ----
#Subsection 3.3.1: Calculate rarefaction
V2020.bar    <- specaccum(Val[Val$year == "2020" & Val$field == "F",c(7:31)], method = "exact", )$richness[4]
V2020.pot    <- specaccum(Val[Val$year == "2020" & Val$field == "A",c(7:31)], method = "exact", )$richness[4]
V2020.bea    <- specaccum(Val[Val$year == "2020" & Val$field == "B",c(7:31)], method = "exact", )$richness[4]
V2020.barpot1 <- specaccum(Val[Val$year == "2020" & (Val$field == "1" | Val$field == "6" | Val$field == "9" | Val$field == "14"),c(7:31)], method = "exact", )$richness[4]
V2020.barbea1 <- specaccum(Val[Val$year == "2020" & (Val$field == "2" | Val$field == "6" | Val$field == "10" | Val$field == "14"),c(7:31)], method = "exact", )$richness[4]
V2020.potbea1 <- specaccum(Val[Val$year == "2020" & (Val$field == "1" | Val$field == "2" | Val$field == "9" | Val$field == "10"),c(7:31)], method = "exact", )$richness[4]
V2020.barpot2 <- specaccum(Val[Val$year == "2020" & (Val$field == "20" | Val$field == "23" | Val$field == "28" | Val$field == "31"),c(7:31)], method = "exact", )$richness[4]
V2020.barbea2 <- specaccum(Val[Val$year == "2020" & (Val$field == "20" | Val$field == "24" | Val$field == "28" | Val$field == "32"),c(7:31)], method = "exact", )$richness[4]
V2020.potbea2 <- specaccum(Val[Val$year == "2020" & (Val$field == "23" | Val$field == "24" | Val$field == "31" | Val$field == "32"),c(7:31)], method = "exact", )$richness[4]
V2020.all1   <- specaccum(Val[Val$year == "2020" & (Val$field == "1" | Val$field == "2" | Val$field == "6" | Val$field == "9" | Val$field == "10" | Val$field == "14"),c(7:31)], method = "exact", )$richness[4]
V2020.all2   <- specaccum(Val[Val$year == "2020" & (Val$field == "20" | Val$field == "23" | Val$field == "24" | Val$field == "28" | Val$field == "31" | Val$field == "32"),c(7:31)], method = "exact", )$richness[4]
V2020.all    <- (V2020.all1 + V2020.all2) / 2

V2021.gra    <- specaccum(Val[Val$year == "2021" & Val$field == "A",c(7:31)], method = "exact", )$richness[4]
V2021.pot    <- specaccum(Val[Val$year == "2021" & Val$field == "B",c(7:31)], method = "exact", )$richness[4]
V2021.bea    <- specaccum(Val[Val$year == "2021" & Val$field == "G",c(7:31)], method = "exact", )$richness[4]
V2021.grapot1 <- specaccum(Val[Val$year == "2021" & (Val$field == "1" | Val$field == "2" | Val$field == "9" | Val$field == "10"),c(7:31)], method = "exact", )$richness[4]
V2021.grabea1 <- specaccum(Val[Val$year == "2021" & (Val$field == "1" | Val$field == "7" | Val$field == "9" | Val$field == "15"),c(7:31)], method = "exact", )$richness[4]
V2021.potbea1 <- specaccum(Val[Val$year == "2021" & (Val$field == "2" | Val$field == "7" | Val$field == "10" | Val$field == "15"),c(7:31)], method = "exact", )$richness[4]
V2021.grapot2 <- specaccum(Val[Val$year == "2021" & (Val$field == "23" | Val$field == "24" | Val$field == "31" | Val$field == "32"),c(7:31)], method = "exact", )$richness[4]
V2021.grabea2 <- specaccum(Val[Val$year == "2021" & (Val$field == "21" | Val$field == "23" | Val$field == "29" | Val$field == "31"),c(7:31)], method = "exact", )$richness[4]
V2021.potbea2 <- specaccum(Val[Val$year == "2021" & (Val$field == "21" | Val$field == "24" | Val$field == "29" | Val$field == "32"),c(7:31)], method = "exact", )$richness[4]
V2021.all1   <- specaccum(Val[Val$year == "2021" & (Val$field == "1" | Val$field == "2" | Val$field == "7" | Val$field == "9" | Val$field == "10" | Val$field == "15"),c(7:31)], method = "exact", )$richness[4]
V2021.all2   <- specaccum(Val[Val$year == "2021" & (Val$field == "21" | Val$field == "23" | Val$field == "24" | Val$field == "29" | Val$field == "31" | Val$field == "32"),c(7:31)], method = "exact", )$richness[4]
V2021.all    <- (V2021.all1 + V2021.all2) / 2

#Subsection 3.3.2: Calculate rate of change
V2020.ba <- (V2020.all - V2020.bar) / V2020.bar
V2020.po <- (V2020.all - V2020.pot) / V2020.pot
V2020.be <- (V2020.all - V2020.bea) / V2020.bea

V2021.gr <- (V2021.all - V2021.gra) / V2021.gra
V2021.po <- (V2021.all - V2021.pot) / V2021.pot
V2021.be <- (V2021.all - V2021.bea) / V2021.bea


#Subsection 3.3.3: Merge data
ValF <- as.data.frame(c(V2020.ba, V2020.po, V2020.be,
                        V2021.gr, V2021.po, V2021.be))
ValF$Year <- c(rep(2020,3),rep(2021,3))
ValF$Crop <- c("Barley","Potato","Barley/Beans","Grass","Potato","Barley/Beans")
ValF$Croppair <- ValF$Year
ValF$Location <- "Valthermond"
colnames(ValF)[1] <- "Change_strip_cropping"

#Subsection 3.3.4: Calculate average constitutive fields
V2020.avall <- (V2020.bar + V2020.pot + V2020.bea)/3
V2021.avall <- (V2021.gra + V2021.pot + V2020.bea)/3

#Subsection 3.3.5: Merge average monoculture and strip cropping data
ValAv <- as.data.frame(c(V2020.avall, V2021.avall,
                        V2020.all, V2021.all))
colnames(ValAv)[1] <- "Richness"
ValAv$Treatment <- c(rep("Monoculture",2), rep("Strip",2))
ValAv$Year <- rep(c(2020,2021),2)
ValAv$Croppair <- rep("All", 4)
ValAv$Location <- "Valthermond"



#Subsection 3.4: Add data from locations together ----
AllF <- rbind(WagF,ErfF,ValF)
AllAv<- rbind(WagAv,ErfAv,ValAv)

#Subsection 3.5: Make dataset with only the monocultures with highest diversity per crop pair
AllF$CropYear <- paste(AllF$Croppair, AllF$Year, sep = ".")
HighF <- AllF %>% group_by(CropYear) %>% top_n(-1, Change_strip_cropping)


#Section 4: Comparison monocultures with strip cropping fields ----
#Subsection 4.1: All monocultures
AMR1 <- glmmTMB(Change_strip_cropping ~ 1 + 
                  (1|Location/Year),
                family = gaussian,
                dispformula = ~ 1,
                ziformula =~ 0,
                data = AllF, na.action = na.fail)


#Subsection 4.2: Only highest monocultures
#Subsection 4.2.1: Including double croppairs when value is equal
HMR1 <- glmmTMB(Change_strip_cropping ~ 1,
                family = gaussian,
                dispformula = ~ 1,
                ziformula =~ 0,
                data = HighF, na.action = na.fail)

#Subsection 4.2.2: Without double croppairs when value is equal
HMR2 <- glmmTMB(Change_strip_cropping ~ 1 + 
                  (1|Location/Year),
                family = gaussian,
                dispformula = ~ 1,
                ziformula =~ 0,
                data = HighF[c(1:3,5:12,14:25),], na.action = na.fail)



#Section 5: Figures for analyses
setwd("[SET LOCATION]")

#Subsection 5.1: Figure comparing strip and monoculture fields
png(filename = "Field-level richness.png", width = 4000, height = 5000, res = 1000)
ggplot() +
  geom_pointrange(aes(x = "All\nmonocultures", y = 0.15113, ymin = 0.06467, ymax = 0.23759),
                  shape = 15, size = 2.5, linewidth = 5) + 
  geom_pointrange(aes(x = "Best\nmonocultures", y = -0.008465, ymin = -0.081812, ymax = 0.064882),
                  shape = 15, size = 2.5, linewidth = 5) +
  geom_hline(yintercept = 0) +
  ylim(c(-0.1,0.25)) +
  labs(x = NULL, y = "Rate of change\nin ground beetle richness") +
  theme_bw() +
  theme(legend.position = "none", axis.title.x = element_blank() ,
        title = element_text(size = 18), 
        axis.text.x = element_text(size = 15, color = "black"),axis.text.y = element_text(size = 16, color = "black"),
        panel.grid.major.x = element_blank(), panel.grid.minor.y = element_blank())
dev.off()


#Section 6: Species response curves ----
#Subsection 6.0: Make general ggplot theme
CustomPlot = list(
  theme(plot.title = element_text(face = "italic", hjust = 0.5),
        axis.text= element_text(size = 54, colour="black"),
        axis.title = element_text(size = 60, colour = "black"),
        axis.line = element_line(colour = "black"),
        panel.background = element_rect(fill = NA, colour = "black"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank(), 
        strip.background = element_rect(colour = "black", fill = NA),
        strip.text = element_text(colour = "black"),
        legend.key = element_rect(fill = NA, colour = NA),
        legend.position = "none")
)

#Subsection 6.1: Prepare data
# Subset the data for "strip" treatment
strip_data <- specaccum(Alm21[Alm21$TRT == "strip", 9:48])
# Subset the data for "mono" treatment
mono_data <- specaccum(Alm21[Alm21$TRT == "mono", 9:48])

# Convert specaccum objects to data frames
strip_df <- data.frame(sites = strip_data$sites, richness = strip_data$richness, sd = strip_data$sd)
mono_df <- data.frame(sites = mono_data$sites, richness = mono_data$richness, sd = mono_data$sd)


#Subsection 6.2: Make figures
png(filename = "Species accumulation curve - Almere.png", width = 10000 , height = 10000, res = 500)
ggplot() +
  geom_line(data = strip_df, aes(x = sites, y = richness), col = "#7FA24D", linewidth = 3) +
  geom_ribbon(data = strip_df, aes(x = sites, ymin = richness - sd, ymax = richness + sd), fill = "#7FA24D", alpha = 0.4) +
  geom_line(data = mono_df, aes(x = sites, y = richness), col = "#895F39", linewidth = 3) + 
  geom_ribbon(data = mono_df, aes(x = sites, ymin = richness - sd, ymax = richness + sd), fill = "#895F39", alpha = 0.4) + 
  labs(y = "Cumulative number of ground beetle species", x = "Number of samples") +
  CustomPlot
dev.off()
