#Section 1: Create clean R workspace ----
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014")
Sys.setenv(LANG = "en")
options(max.print = 20000)

#Section 2: Open libraries and datasets ----
#Open packages:
Pkgs2Load <- c("readxl","tidyr", "ggplot2", "ggh4x", "plyr", "labdsv", "glmmTMB", "DHARMa", "vegan", "pairwiseAdonis")

invisible(lapply(Pkgs2Load, library, character.only = TRUE))

#Set the working directory.
setwd("[SET LOCATION]")

#Import data files
Lel <- read.csv("GB_4loc_Data_Lelystad_2019-2021.csv", row.names = 1)
Wag <- read.csv("GB_4loc_Data_Wageningen_2019-2022.csv", row.names = 1)
Alm21 <- read.csv("GB_4loc_Data_Almere_2021-2022.csv", row.names = 1)

#Section 3: Prepare the data ----
cols <- c("Year","Crop","Treatment","Location")
#Subsection 3.1: Lelystad ----
#Subsection 3.1.1: Change treatment names
Lel$Treatment <- factor(Lel$Treatment,
                           levels = c("REF_SPACE", "STRIP"),
                           labels = c("Monoculture", "Strip"))

#Subsection 3.1.2: Change data class
Lel[cols] <- lapply(Lel[cols],factor)


#Subsection 3.2: Wageningen ----
#Subsection 3.2.1: Change treatment names
Wag$Treatment <- factor(Wag$Treatment,
                           levels = c("REF_SPACE", "STRIP"),
                           labels = c("Monoculture", "Strip"))

#Subsection 3.2.2: Change data class
Wag[cols] <- lapply(Wag[cols],factor)


#Subsection 3.3: Almere ----
#Subsection 3.3.1: Change column names
colnames(Alm21)[4] <- "Treatment"
colnames(Alm21)[1] <- "ID"

#Subsection 3.3.2: Change treatment names
Alm21$Treatment <- factor(Alm21$Treatment,
                           levels = c("mono", "strip"),
                           labels = c("Monoculture", "Strip"))

#Subsection 3.3.3: Change data class
Alm21$Location <- "Almere"
Alm21[cols] <- lapply(Alm21[cols],factor)


#Subsection 3.4: Merge datasets ----
#Subsection 3.4.1: bind datasets
Total <- rbind.fill(Lel, Wag, Alm21)

#Subsection 3.4.2: Change NA's to 0
Total[is.na(Total)] <- 0

#Subsection 3.4.3: Remove unidentified genera
Total$AmarUI <- NULL
Total$BembUI <- NULL
Total$TrecUI <- NULL
Total$Unknown <- NULL

Alm21$AmarUI <- NULL
Alm21$BembUI <- NULL
Alm21$TrecUI <- NULL

#Subsection 3.4.4: Remove rare species
Total.drop <- dropspc(Total[,c(11:83)],minocc = 0.03*nrow(Total))
All <- cbind(Total[,c(2:3,8:10)], Total.drop)

Lel.drop <- dropspc(Lel[,c(11:64)],minocc = 2)
Lel <- cbind(Lel[,c(2:3,8:10)], Lel.drop)

Wag.drop <- dropspc(Wag[,c(10:70)], minocc = 0.03*nrow(Wag))
Wag <- cbind(Wag[,c(1:2,7:9)], Wag.drop)

Alm.drop <- dropspc(Alm21[,c(9:48)], minocc = 0.03*nrow(Alm21))
Alm21 <- cbind(Alm21[,c(1:4,50)], Alm.drop)

#Subsection 3.4.5: Remove samples without individuals
All <- All[rowSums(All[,6:41]) > 0,]
Lel <- Lel[rowSums(Lel[,6:16]) > 0,]
Wag <- Wag[rowSums(Wag[,6:34]) > 0,]
Alm21 <- Alm21[rowSums(Alm21[,6:29]) > 0,]


#Section 4: Permanova ----
#Subseciton 4.1: Run permanova on full dataset
All.div <- adonis2(All[,6:41] ~ Treatment*(Location/Year/Crop), data = All, method = "hellinger")
All.div

#Subsection 4.2: Run permanova on separate locations
Lel.div <- adonis2(Lel[,6:16] ~ Treatment*(Year/Crop), data = Lel, method = "hellinger")
Lel.div

Wag.div <- adonis2(Wag[,6:34] ~ Treatment*(Year/Crop), data = Wag, method = "hellinger")
Wag.div

Alm.div <- adonis2(Alm21[,6:29] ~ Treatment*(Year/Crop), data = Alm21, method = "hellinger")
Alm.div

