#Section 1: Create clean R workspace ----
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014")
Sys.setenv(LANG = "en")
options(max.print = 20000)

#Section 2: Open libraries and datasets ----
#Open packages:
Pkgs2Load <- c("readxl","tidyr", "ggplot2", "ggrepel", "ggh4x", "plyr", "labdsv", "glmmTMB", "DHARMa", "vegan", "pairwiseAdonis")

invisible(lapply(Pkgs2Load, library, character.only = TRUE))

#Set the working directory.
setwd("C:/Users/croij001/OneDrive - Wageningen University & Research/General/Projects/Collab Luuk Fogelina Carabid beetles/Data analyses/Luuk")

#Import data files
Broek <- read_xlsx("Broekemahoeve_all.xlsx")
Droef <- read_xlsx("Droevendaal_2019-2022.xlsx")
Erf21 <- read.csv2("ERF Gz5 20212022_def.csv")

#Section 3: Prepare the data ----
cols <- c("Year","Crop","Treatment","Location")
#Subsection 3.1: Broekemahoeve ----
#Subsection 3.1.1: Remove samples that were not done or not relevant
Broek <- Broek[Broek$Done != 0,]

Broek$Year <- format(Broek$Date_collection, format = "%Y")
Broek$Month <- format(Broek$Date_collection, format = "%m")

Broek <- Broek[Broek$Year == "2019" & (Broek$Treatment == "REF_SPACE" | Broek$Treatment == "STRIP") |
                Broek$Year == "2020" & (Broek$Field == "J9_1" | Broek$Field == "J10_7") |
                 Broek$Year == "2021" & Broek$Field == "J8_1",]
Broek <- Broek[Broek$Crop != "Wheat",]


#Subsection 3.1.2: Aggregate rounds
BroekY <- aggregate(Broek[,18:72], by = list(Broek$ID),  FUN = sum)
colnames(BroekY)[1] <- "ID"


#Subsection 3.1.3: Add meta-data
BroekR1 <- Broek[Broek$Month == "07",]
BroekY <- merge(BroekR1[,c(1,2,10,12,74)], BroekY, by = "ID")

#Subsection 3.1.4: Remove incomplete year series
BroekY <- BroekY[BroekY$ID != "PF-B-031",]

#Subsection 3.1.5: Change treatment names
BroekY$Treatment <- factor(BroekY$Treatment,
                           levels = c("REF_SPACE", "STRIP"),
                           labels = c("Monoculture", "Strip"))
BroekY$Location <- "Lelystad"

#Subsection 3.1.6: Change data class
BroekY[cols] <- lapply(BroekY[cols],factor)


#Subsection 3.2: Droevendaal ----
#Subsection 3.2.1: Remove samples that were not done or not relevant
Droef <- Droef[Droef$Done != 0,]

Droef$Year <- format(Droef$Date_collection, format = "%Y")
Droef$Month <- format(Droef$Date_collection, format = "%m")

Droef <- Droef[Droef$Treatment == "REF_SPACE" | Droef$Treatment == "STRIP",]
Droef <- Droef[Droef$Year == "2019" & (Droef$Field == "10" | Droef$Crop == "Potato") |
                 Droef$Year == "2020" & (Droef$Field == "10" | Droef$Field == "13" | Droef$Crop == "Pumpkin") |
                 Droef$Year == "2021" & (Droef$Field == "4" | Droef$Field == "5" | Droef$Field == "6") |
                 Droef$Year == "2022" & (Droef$Field == "4" | Droef$Field == "5" | Droef$Field == "6"),]

#Subsection 3.2.2: Change data format
Droef[,c(1:4,7:14)] <- lapply(Droef[,c(1:4,7:14)], as.factor)
Droef[,c(5:6,20:81)] <- lapply(Droef[,c(5:6,20:81)], as.numeric)

#Subsection 3.2.3: Remove incomplete rounds of wheat in 2020
Droef <- Droef[Droef$Crop != "Wheat" | 
                      Droef$Crop == "Wheat" & (Droef$Year == "2019" | 
                                                 Droef$Year == "2020" & (Droef$Round == 3 | Droef$Round == 6) |
                                                 Droef$Year == "2021" | 
                                                 Droef$Year == "2022"),]

#Subsection 3.2.4: Aggregate rounds
DroefY <- aggregate(Droef[,20:81], by = list(Droef$ID),  FUN = sum)
colnames(DroefY)[1] <- "ID"


#Subsection 3.2.5: Add meta-data
DroefR1 <- Droef[(Droef$Year == "2019" | Droef$Year == "2022") & Droef$Round == "2" |
                   (Droef$Year == "2020" | Droef$Year == "2021") & Droef$Round == "4" |
                   (Droef$Year == "2020" & Droef$Crop == "Wheat" & Droef$Round == "3"),]
DroefY <- merge(DroefR1[,c(1,2,10,12,83)], DroefY, by = "ID")


#Subsection 3.2.6: Remove incomplete year series
DroefY <- DroefY[DroefY$ID != "PF-D-364",]
DroefY <- DroefY[DroefY$ID != "PF-D-768",]


#Subsection 3.2.7: Change treatment names
DroefY$Treatment <- factor(DroefY$Treatment,
                           levels = c("REF_SPACE", "STRIP"),
                           labels = c("Monoculture", "Strip"))

DroefY$Location <- "Wageningen"

#Subsection 3.2.8: Change data class
DroefY[cols] <- lapply(DroefY[cols],factor)


#Subsection 3.3: ERF ----
#Subsection 3.3.1: Aggregate rounds
Erf21$yearserienr <- paste(Erf21$Year, Erf21$ID, sep = ".")
Erf21Y <- aggregate(Erf21[,17:60], by = list(Erf21$yearserienr),  FUN = sum)
colnames(Erf21Y)[1] <- "yearserienr"

#Subsection 3.3.2: Add meta-data
Erf21R1 <- Erf21[Erf21$Round == "2",]
Erf21R1$Location <- "ERF"
Erf21Y <- merge(Erf21R1[,c(1,8,9,114,115)], Erf21Y, by = "yearserienr")

#Subsection 3.3.3: Remove incomplete year series
Erf21Y <- Erf21Y[Erf21Y$yearserienr != "2021.17",]
Erf21Y <- Erf21Y[Erf21Y$yearserienr != "2022.13",]
Erf21Y <- Erf21Y[Erf21Y$yearserienr != "2022.20",]
Erf21Y <- Erf21Y[Erf21Y$yearserienr != "2022.24",]
Erf21Y <- Erf21Y[Erf21Y$yearserienr != "2022.29",]
Erf21Y <- Erf21Y[Erf21Y$yearserienr != "2022.31",]
Erf21Y <- Erf21Y[Erf21Y$yearserienr != "2022.35",]
Erf21Y <- Erf21Y[Erf21Y$yearserienr != "2022.40",]

#Subsection 3.3.4: Change column names
colnames(Erf21Y)[4] <- "Treatment"
colnames(Erf21Y)[1] <- "ID"

#Subsection 3.3.5: Change treatment names
Erf21Y$Treatment <- factor(Erf21Y$Treatment,
                           levels = c("mono", "strip"),
                           labels = c("Monoculture", "Strip"))

Erf21Y$Location <- "Almere"

#Subsection 3.3.6: Change data class
Erf21Y[cols] <- lapply(Erf21Y[cols],factor)


#Subsection 3.4: Merge datasets ----
#Subsection 3.4.1: bind datasets
Total <- rbind.fill(BroekY, DroefY, Erf21Y)

#Subsection 3.4.2: Change NA's to 0
Total[is.na(Total)] <- 0

#Subsection 3.4.3: Remove unidentified genera
Total$AmarUI <- NULL
Total$BembUI <- NULL
Total$TrecUI <- NULL
Total$Unknown <- NULL

Erf21Y$AmarUI <- NULL
Erf21Y$BembUI <- NULL
Erf21Y$TrecUI <- NULL

#Subsection 3.4.4: Remove rare species
Total.drop <- dropspc(Total[,c(6:76)],minocc = 0.03*nrow(Total))
All <- cbind(Total[,c(1:5)], Total.drop)

Broek.drop <- dropspc(BroekY[,c(6:50)],minocc = 2)
BroekY <- cbind(BroekY[,c(1:5)], Broek.drop)

Droef.drop <- dropspc(DroefY[,c(6:66)], minocc = 0.03*nrow(DroefY))
DroefY <- cbind(DroefY[,c(1:5)], Droef.drop)

Erf.drop <- dropspc(Erf21Y[,c(6:45)], minocc = 0.03*nrow(Erf21Y))
ErfY <- cbind(Erf21Y[,c(1:5)], Erf.drop)

#Subsection 3.4.5: Remove samples without individuals
All <- All[rowSums(All[,6:41]) > 0,]
BroekY <- BroekY[rowSums(BroekY[,6:16]) > 0,]
DroefY <- DroefY[rowSums(DroefY[,6:34]) > 0,]
ErfY <- ErfY[rowSums(ErfY[,6:29]) > 0,]


#Subsection 3.5: Make general ggplot theme
CustomPlot = list(
  theme(plot.title = element_text(face = "italic", hjust = 0.5),
        axis.text= element_text(size = 30, colour="black"),
        axis.title = element_text(size = 35, colour = "black"),
        axis.line = element_line(colour = "black"),
        panel.background = element_rect(fill = "white", colour = "black"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank(), 
        strip.background = element_rect(colour = "black", fill = NA),
        strip.text = element_text(colour = "black"),
        legend.text = element_text(size = 25),
        legend.title = element_text(size = 30),
        legend.key = element_rect(fill = NA, colour = NA)) 
)


Treatment.colors <- c("#895F39", "#7FA24D")


#Subsection 3.6: Set working directory for figures
setwd("C:/Users/croij001/OneDrive - Wageningen University & Research/General/Projects/Collab Luuk Fogelina Carabid beetles/Data analyses/Luuk/Raw figures")


#Section 4: NMDS on full dataset ----
#Subsection 4.1: Transform data
Allhell <- vegdist(All[,c(6:41)], method = "hellinger")


#Subsection 4.2: Run NMDS analyses
All_NMDS <-
  metaMDS(Allhell,
          distance = "hellinger",
          k = 2,
          maxit = 999, 
          trymax = 250,
          wascores = TRUE)


#Subsection 4.3: Plotting NMDS
png(filename = "NMDS - All.png", width = 5000, height = 3000, res = 500)
plot(All_NMDS, "sites",
     type = "n")
with(All[,c(1:5)],
     points(All_NMDS,
            display = "sites",
            col = Treatment.colors[Treatment],
            pch = c(1,6,17)[Location]))
ordihull(
  All_NMDS,
  All[,c(1:5)]$Treatment,
  display = "sites" ,
  draw = c("polygon"),
  col = NULL,
  border = Treatment.colors
)

scrs_All <- scores(All_NMDS, display = "sites", "species")
cent_All <- aggregate(scrs_All ~ Treatment, data = All, FUN = "mean")

names(cent_All)[-1] <- colnames(scrs_All)
points(cent_All[,-1],
       pch = c(8, 8),
       col = Treatment.colors,
       lwd = 3.0,
       cex = 2.0)
dev.off()


#Section 5: NMDS on Broekemahoeve ----
#Subsection 5.1: Transform data
Broek_hell <- vegdist(BroekY[,c(6:16)], method = "hellinger")


#Subsection 5.2: Run NMDS analyses
Broek_NMDS <-
  metaMDS(Broek_hell,
          distance = "hellinger",
          k = 2,
          maxit = 999, 
          trymax = 250,
          wascores = TRUE)


#Subsection 5.3: Plotting NMDS
png(filename = "NMDS - Broek.png", width = 5000, height = 3000, res = 500)
plot(Broek_NMDS, "sites",
     type = "n")
with(BroekY[,c(1:5)],
     points(Broek_NMDS,
            display = "sites",
            col = Treatment.colors[Treatment],
            pch = c(1,16,6)[Year]))
ordihull(
  Broek_NMDS,
  BroekY[,c(1:5)]$Treatment,
  display = "sites" ,
  draw = c("polygon"),
  col = NULL,
  border = Treatment.colors
)

scrs_Broek <- scores(Broek_NMDS, display = "sites", "species")
cent_Broek <- aggregate(scrs_Broek ~ Treatment, data = BroekY, FUN = "mean")

names(cent_Broek)[-1] <- colnames(scrs_Broek)
points(cent_Broek[,-1],
       pch = c(8, 8),
       col = Treatment.colors,
       lwd = 3.0,
       cex = 2.0)
dev.off()


#Section 6: NMDS on Droevendaal ----
#Subsection 6.1: Transform data
Droef_hell <- vegdist(DroefY[,c(6:34)], method = "hellinger")


#Subsection 6.2: Run NMDS analyses
Droef_NMDS <-
  metaMDS(Droef_hell,
          distance = "hellinger",
          k = 2,
          maxit = 999, 
          trymax = 250,
          wascores = TRUE)


#Subsection 6.3: Plotting NMDS
png(filename = "NMDS - Droef.png", width = 5000, height = 5000, res = 500)
plot(Droef_NMDS, "sites",
     type = "n")
with(DroefY[,c(1:5)],
     points(Droef_NMDS,
            display = "sites",
            col = Treatment.colors[Treatment],
            pch = c(1,16,6,17)[Year]))
ordihull(
  Droef_NMDS,
  DroefY[,c(1:5)]$Treatment,
  display = "sites" ,
  draw = c("polygon"),
  col = NULL,
  border = Treatment.colors
)

scrs_Droef <- scores(Droef_NMDS, display = "sites", "species")
cent_Droef <- aggregate(scrs_Droef ~ Treatment, data = DroefY, FUN = "mean")

names(cent_Droef)[-1] <- colnames(scrs_Droef)
points(cent_Droef[,-1],
       pch = c(8, 8),
       col = Treatment.colors,
       lwd = 3.0,
       cex = 2.0)
dev.off()


#Section 7: NMDS on ERF ----
#Subsection 7.1: Transform data
Erf_hell <- vegdist(ErfY[,c(6:29)], method = "hellinger")


#Subsection 7.2: Run NMDS analyses
Erf_NMDS <-
  metaMDS(Erf_hell,
          distance = "hellinger",
          k = 2,
          maxit = 999, 
          trymax = 250,
          wascores = TRUE)


#Subsection 7.3: Plotting NMDS
png(filename = "NMDS - Erf.png", width = 5000, height = 5000, res = 500)
plot(Erf_NMDS, "sites",
     type = "n")
with(ErfY[,c(1:5)],
     points(Erf_NMDS,
            display = "sites",
            col = Treatment.colors[Treatment],
            pch = c(6,17)[Year]))
ordihull(
  Erf_NMDS,
  ErfY[,c(1:5)]$Treatment,
  display = "sites" ,
  draw = c("polygon"),
  col = NULL,
  border = Treatment.colors
)

scrs_Erf <- scores(Erf_NMDS, display = "sites", "species")
cent_Erf <- aggregate(scrs_Erf ~ Treatment, data = ErfY, FUN = "mean")

names(cent_Erf)[-1] <- colnames(scrs_Erf)
points(cent_Erf[,-1],
       pch = c(8, 8),
       col = Treatment.colors,
       lwd = 3.0,
       cex = 2.0)
dev.off()

