## Agent-Based Simulation of West Asian Urban Dynamics: Impact of Refugees
## JASSS
## figure 5
## (c)2020 N. Yorke-Smith
## licensed under CC BY-NC-ND 4.0
## contact: n.yorke-smith@tudelft.nl


## adapted from https://gist.github.com/sheymann/2399659
ExportPlot <- function(gplot, filename, width=2, height=2) {
    ggsave(paste(filename, '.pdf', sep=""), gplot, width = width, height = height)
    png(file = paste(filename, '.png', sep=""), width = width * 100, height = height * 100)
    print(gplot)
    dev.off()
}

## libraries
require(ggplot2)
require(tidyr)
require(data.table)

## load data
csvdata <- read.table(file("population-runs.csv"), header=TRUE, sep=",")
dt <- data.table(csvdata)
#dt
dl <- gather(dt, timestep, popcount, X1:X601, factor_key=TRUE)
#dl
attach(dl)

## bigger graph fonts
#theme_update(text = element_text(size=200))
theme_set(
    theme_classic(base_size = 25)
)

## make 4 graphs
myplot <- ggplot(data=dl[treatment==1,], aes(x=timestep, y=popcount, group=type, colour=type)) + geom_point(size=2) + expand_limits(y=0) + scale_y_continuous(breaks=seq(0,1,0.1), name="%  population") + scale_x_discrete(breaks=c("X1","X101","X181","X201","X271","X301","X401","X501","X601"), labels=c("0","100","180","200","270","300","400","500","600"), name="months") + labs(colour = "Ethnicity") + theme(legend.justification=c(1,1), legend.position=c(1,0.5)) + theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) + theme(axis.ticks.length = unit(5, "mm"))
ExportPlot(myplot, "popcount-refugees1", width=11.69, height=8.27)

myplot <- ggplot(data=dl[treatment==2,], aes(x=timestep, y=popcount, group=type, colour=type)) + geom_point(size=2) + expand_limits(y=0) + scale_y_continuous(breaks=seq(0,1,0.1), name="%  population") + scale_x_discrete(breaks=c("X1","X101","X181","X201","X271","X301","X401","X501","X601"), labels=c("0","100","180","200","270","300","400","500","600"), name="months") + labs(colour = "Ethnicity") + theme(legend.justification=c(1,1), legend.position=c(1,1)) + theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) + theme(axis.ticks.length = unit(5, "mm"))
ExportPlot(myplot, "popcount-refugees2", width=11.69, height=8.27)

myplot <- ggplot(data=dl[treatment==3,], aes(x=timestep, y=popcount, group=type, colour=type)) + geom_point(size=2) + expand_limits(y=0) + scale_y_continuous(breaks=seq(0,1,0.1), name="%  population") + scale_x_discrete(breaks=c("X1","X101","X181","X201","X271","X301","X401","X501","X601"), labels=c("0","100","180","200","270","300","400","500","600"), name="months") + labs(colour = "Ethnicity") + theme(legend.justification=c(1,1), legend.position=c(1,1)) + theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) + theme(axis.ticks.length = unit(5, "mm"))
ExportPlot(myplot, "popcount-refugees3", width=11.69, height=8.27)

myplot <- ggplot(data=dl[treatment==4,], aes(x=timestep, y=popcount, group=type, colour=type)) + geom_point(size=2) + expand_limits(y=0) + scale_y_continuous(breaks=seq(0,1,0.1), name="%  population") + scale_x_discrete(breaks=c("X1","X101","X181","X201","X271","X301","X401","X501","X601"), labels=c("0","100","180","200","270","300","400","500","600"), name="month") + labs(colour = "Ethnicity") + theme(legend.justification=c(1,1), legend.position=c(1,1)) + theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) + theme(axis.ticks.length = unit(5, "mm"))
ExportPlot(myplot, "popcount-refugees4", width=11.69, height=8.27)

detach(dl)
