## Agent-Based Simulation of West Asian Urban Dynamics: Impact of Refugees
## JASSS
## table 9, figure 6, table 10, table 11
## (c)2020 N. Yorke-Smith
## licensed under CC BY-NC-ND 4.0
## contact: n.yorke-smith@tudelft.nl


## adapted from https://gist.github.com/sheymann/2399659
ExportPlot <- function(gplot, filename, width=2, height=2) {
    ggsave(paste(filename, '.pdf', sep=""), gplot, width = width, height = height)
    png(file = paste(filename, '.png', sep=""), width = width * 100, height = height * 100)
    print(gplot)
    dev.off()
}

## libraries
require(ggplot2)
require(tidyr)
require(data.table)

## load data
csvdata <- read.table(file("gentax-0.6.5_BEY.csv"), header=TRUE, sep=",")
dt <- data.table(csvdata)
#dt

## bigger graph fonts
#theme_update(text = element_text(size=200))
theme_set(
    theme_classic(base_size = 25)
)


## table 9
attach(dt)
dependents <- cbind(pctslums600,pctgood600,pctovercrowded600,medianPrices600,medianIncome600,lebanese600,refugees600,others600)
res.man <- manova(dependents ~ K * rnetlogoparamrefugees * regeneration, data = dt)
summary(res.man, test="Pillai")
summary.aov(res.man)


## make 12 graphs

ct <- dt[HaveRefugees=="false" & rnetlogoparamrefugees==1 & regeneration=="none", .(mean(pctslums100),mean(pctslums200),mean(pctslums400),mean(pctslums600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,0.7) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "slums-none", width=11.69, height=8.27)

ct <- dt[HaveRefugees=="true" & rnetlogoparamrefugees==2 & regeneration=="none", .(mean(pctslums100),mean(pctslums200),mean(pctslums400),mean(pctslums600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,0.7) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "slums-refugees", width=11.69, height=8.27)

ct <- dt[HaveRefugees=="true" & rnetlogoparamrefugees==3 & regeneration=="none", .(mean(pctslums100),mean(pctslums200),mean(pctslums400),mean(pctslums600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,0.7) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "slums-many", width=11.69, height=8.27)

ct <- dt[HaveRefugees=="true" & rnetlogoparamrefugees==4 & regeneration=="none", .(mean(pctslums100),mean(pctslums200),mean(pctslums400),mean(pctslums600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,0.7) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "slums-flood", width=11.69, height=8.27)

ct <- dt[HaveRefugees=="false" & rnetlogoparamrefugees==1 & regeneration=="none", .(mean(pctovercrowded100),mean(pctovercrowded200),mean(pctovercrowded400),mean(pctovercrowded600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,0.5) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "crowded-none", width=11.69, height=8.27)

ct <- dt[HaveRefugees=="true" & rnetlogoparamrefugees==2 & regeneration=="none", .(mean(pctovercrowded100),mean(pctovercrowded200),mean(pctovercrowded400),mean(pctovercrowded600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,0.5) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "crowded-refugees", width=11.69, height=8.27)

ct <- dt[HaveRefugees=="true" & rnetlogoparamrefugees==3 & regeneration=="none", .(mean(pctovercrowded100),mean(pctovercrowded200),mean(pctovercrowded400),mean(pctovercrowded600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,0.5) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "crowded-many", width=11.69, height=8.27)

ct <- dt[HaveRefugees=="true" & rnetlogoparamrefugees==4 & regeneration=="none", .(mean(pctovercrowded100),mean(pctovercrowded200),mean(pctovercrowded400),mean(pctovercrowded600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,0.5) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "crowded-flood", width=11.69, height=8.27)

ct <- dt[HaveRefugees=="false" & rnetlogoparamrefugees==1 & regeneration=="none", .(mean(medianPrices100),mean(medianPrices200),mean(medianPrices400),mean(medianPrices600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,8000) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "prices-none", width=11.69, height=8.27)

ct <- dt[HaveRefugees=="true" & rnetlogoparamrefugees==2 & regeneration=="none", .(mean(medianPrices100),mean(medianPrices200),mean(medianPrices400),mean(medianPrices600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,8000) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "prices-refugees", width=11.69, height=8.27)

ct <- dt[HaveRefugees=="true" & rnetlogoparamrefugees==3 & regeneration=="none", .(mean(medianPrices100),mean(medianPrices200),mean(medianPrices400),mean(medianPrices600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,8000) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "prices-many", width=11.69, height=8.27)

ct <- dt[HaveRefugees=="true" & rnetlogoparamrefugees==4 & regeneration=="none", .(mean(medianPrices100),mean(medianPrices200),mean(medianPrices400),mean(medianPrices600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,8000) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "prices-flood", width=11.69, height=8.27)

# graph 10-12
ct <- dt[HaveRefugees=="false" & rnetlogoparamrefugees==1 & regeneration=="none", .(mean(medianIncome100),mean(medianIncome200),mean(medianIncome400),mean(medianIncome600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,9000) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0.25, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "income-none", width=11.69, height=8.27)

ct <- dt[HaveRefugees=="true" & rnetlogoparamrefugees==2 & regeneration=="none", .(mean(medianIncome100),mean(medianIncome200),mean(medianIncome400),mean(medianIncome600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,9000) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0.25, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "income-refugees", width=11.69, height=8.27)

ct <- dt[HaveRefugees=="true" & rnetlogoparamrefugees==3 & regeneration=="none", .(mean(medianIncome100),mean(medianIncome200),mean(medianIncome400),mean(medianIncome600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,9000) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0.25, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "income-many", width=11.69, height=8.27)

ct <- dt[HaveRefugees=="true" & rnetlogoparamrefugees==4 & regeneration=="none", .(mean(medianIncome100),mean(medianIncome200),mean(medianIncome400),mean(medianIncome600)), by=K]
setnames(ct, c("V1","V2","V3","V4"), c("t100","t200","t400","t600"))
wt <- gather(ct, ticks, percentage, t100:t600)
myplot <- ggplot(data=wt, aes(x=ticks, y=percentage, fill=factor(K))) + geom_bar(stat="identity", position=position_dodge2()) + ylim(0,9000) + scale_x_discrete(labels = c("100","200","400","600")) + xlab("months") + ylab("% slums") + labs(fill = "Kapital") + theme(legend.position = c(0.8, 1), legend.justification = c(0, 1)) #+ scale_fill_brewer(palette="Dark2")
ExportPlot(myplot, "income-flood", width=11.69, height=8.27)


## table 10
table10 <- dt[regeneration=="none", .( mean(pctslums600),mean(pctovercrowded600),mean(medianPrices600),mean(medianIncome600) ), by=rnetlogoparamrefugees]
setnames(table10, c("V1","V2","V3","V4"), c("% slums", "% overcrowded", "price", "income"))


## table 11
table11 <- dt[rnetlogoparamrefugees==2, .( mean(pctslums600),mean(pctovercrowded600),mean(medianPrices600),mean(medianIncome600) ), by=regeneration]
setnames(table11, c("V1","V2","V3","V4"), c("% slums", "% overcrowded", "price", "income"))


detach(dt)
