setwd("your data folder here")
library(tidyverse)
library(ggpubr)
library(rstatix)
library(lsr)
library(ggplot2)
library(devtools)
library(car)
library(readr)

# Load data exam scores
examData <- read.csv("resultsExamForR.csv")
# F-test
var.test(finalExamScore ~ sessionType, data = examData)
# Two Sample t-test
t.test(finalExamScore ~ sessionType, data = examData, var.equal = TRUE)
# Summary of data stats (i.e. mean, sd)
examData %>%
  group_by(sessionType) %>%
  get_summary_stats(finalExamScore, type = "mean_sd")
stat.test <- examData %>% 
  t_test(finalExamScore ~ sessionType, detailed = TRUE, var.equal = TRUE) %>%
  add_significance()
stat.test
examData %>% cohens_d(finalExamScore ~ sessionType, var.equal = TRUE)
# Create a box-plot
bxp <- ggboxplot(
  examData, x = "sessionType", y = "finalExamScore", 
  ylab = "Final Exam Score", xlab = "Learning Mode", add = "jitter"
)
# Add p-value and significance levels
stat.test <- stat.test %>% add_xy_position(x = "sessionType")
bxp + 
  stat_pvalue_manual(stat.test, tip.length = 0, linetype = 2 ) +
  labs(subtitle = get_test_label(stat.test, detailed = TRUE))

# Load data self efficacy
selfEfficacyData <- read.csv("selfEfficacyForR.csv")
# F-test
var.test(mean ~ sessionType, data = selfEfficacyData)
# Two Sample t-test
t.test(mean ~ sessionType, data = selfEfficacyData, var.equal = TRUE)
cohensD(mean ~ sessionType, data = selfEfficacyData)
# Summary of data stats (i.e. mean, sd)
selfEfficacyData %>%
  group_by(sessionType) %>%
  get_summary_stats(mean, type = "mean_sd")
stat2.test <- selfEfficacyData %>% 
  t_test(mean ~ sessionType, detailed = TRUE, var.equal = TRUE) %>%
  add_significance()
stat2.test
selfEfficacyData %>% cohens_d(mean ~ sessionType, var.equal = TRUE)
# Create a box-plot
bxp <- ggboxplot(
  selfEfficacyData, x = "sessionType", y = "mean", 
  ylab = "Self-Efficacy Score", xlab = "Learning Mode", add = "jitter"
)
# Add p-value and significance levels
stat2.test <- stat2.test %>% add_xy_position(x = "sessionType")
bxp + 
  stat_pvalue_manual(stat2.test, tip.length = 0, linetype = 2 ) +
  labs(subtitle = get_test_label(stat2.test, detailed = TRUE))
# Two-way Anova
model <- aov(mean ~ sessionType * order, data = selfEfficacyData)
summary(model)
# Coloured barplot
selfEfficacyDataSummary <- read.csv("selfEfficacyForRSummary.csv")
ggplot(selfEfficacyDataSummary, aes(x = factor(order), y = mean, fill = sessionType, colour = sessionType)) +
  geom_bar(stat = "identity", position = "dodge", alpha = 0.5)  +
  geom_errorbar(aes(ymin=mean-stdev, ymax=mean+stdev), position = position_dodge(0.9), width = 0.25)
ggplot(selfEfficacyDataSummary, aes(x = factor(order), y = mean, fill = sessionType, colour = sessionType)) + 
  geom_bar(stat = "identity", position = "dodge", alpha = 0.5)  +
  geom_errorbar(aes(ymin=mean-stdev, ymax=mean+stdev), position = position_dodge(0.9), width = 0.25) +
  labs(x="Session Order", y="Self Efficacy Score") +
  theme_bw() + 
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank()) +
  theme(legend.position = c(0.1, 0.75)) +
  geom_text(aes(label=mean), position = position_dodge(0.90), size = 3, 
            vjust=-0.8, hjust=-0.5, colour = "gray25") +
  ylim(0, 10) +
  geom_text(aes(label=sessionType, y = 100), position = position_dodge(0.90))

understandabilityData <- read.csv("UnderstandabilityForR.csv")
ggboxplot(
  understandabilityData, x = "Statement", y = "Score", 
  ylab = "Understandability", xlab = "Statements", add = "jitter"
)

realismData <- read.csv("RealismForR.csv")
ggboxplot(
  realismData, x = "Statement", y = "Score", 
  ylab = "Realism", xlab = "Statements", add = "jitter"
)

randomQData <- read.csv("RandomQforR.csv")
ggboxplot(
  randomQData, x = "Statement", y = "Score", 
  ylab = "Score", xlab = "Statements", add = "jitter"
)

funData <- read.csv("FunForR.csv")
var.test(POSTQ5 ~ SessionType, data = funData)
#t.test(POSTQ5 ~ SessionType, data = funData, var.equal = TRUE)
cohensD(POSTQ5 ~ SessionType, data = funData)
funData %>%
  group_by(SessionType) %>%
  get_summary_stats(POSTQ5, type = "mean_sd")
stat2.test <- funData %>% 
  t_test(POSTQ5 ~ SessionType, detailed = TRUE, var.equal = TRUE) %>%
  add_significance()
stat2.test
funData %>% cohens_d(POSTQ5 ~ SessionType, var.equal = TRUE)
# Create a box-plot
bxp <- ggboxplot(
  funData, x = "SessionType", y = "POSTQ5", 
  ylab = "Fun Score", xlab = "Learning Mode", add = "jitter"
)
# Add p-value and significance levels
stat2.test <- stat2.test %>% add_xy_position(x = "SessionType")
bxp + 
  stat_pvalue_manual(stat2.test, tip.length = 0) +
  labs(subtitle = get_test_label(stat2.test, detailed = TRUE))

selfEfficacyQData <- read.csv("SelfEfficacyForRCompare.csv")
var.test(SelfEfficacy ~ SessionType, data = selfEfficacyQData)
cohensD(SelfEfficacy ~ SessionType, data = selfEfficacyQData)
selfEfficacyQData %>%
  group_by(SessionType) %>%
  get_summary_stats(SelfEfficacy, type = "mean_sd")
stat2.test <- selfEfficacyQData %>% 
  t_test(SelfEfficacy ~ SessionType, detailed = TRUE, var.equal = TRUE) %>%
  add_significance()
stat2.test
selfEfficacyQData %>% cohens_d(SelfEfficacy ~ SessionType, var.equal = TRUE)
# Create a box-plot
bxp <- ggboxplot(
  selfEfficacyQData, x = "SessionType", y = "SelfEfficacy", 
  ylab = "Self-Efficacy Score", xlab = "Learning Mode", add = "jitter"
)
# Add p-value and significance levels
stat2.test <- stat2.test %>% add_xy_position(x = "SessionType")
bxp + 
  stat_pvalue_manual(stat2.test, tip.length = 0) +
  labs(subtitle = get_test_label(stat2.test, detailed = TRUE))

mentalEffortData <- read.csv("MentalEffortForR.csv")
var.test(MentalEffort ~ SessionType, data = mentalEffortData)
cohensD(MentalEffort ~ SessionType, data = mentalEffortData)
mentalEffortData %>%
  group_by(SessionType) %>%
  get_summary_stats(MentalEffort, type = "mean_sd")
stat2.test <- mentalEffortData %>% 
  t_test(MentalEffort ~ SessionType, detailed = TRUE, var.equal = TRUE) %>%
  add_significance()
stat2.test
mentalEffortData %>% cohens_d(MentalEffort ~ SessionType, var.equal = TRUE)
# Create a box-plot
bxp <- ggboxplot(
  mentalEffortData, x = "SessionType", y = "MentalEffort", 
  ylab = "Mental Effort Score", xlab = "Learning Mode", add = "jitter"
)
# Add p-value and significance levels
stat2.test <- stat2.test %>% add_xy_position(x = "SessionType")
bxp + 
  stat_pvalue_manual(stat2.test, tip.length = 0) +
  labs(subtitle = get_test_label(stat2.test, detailed = TRUE))