
# Data underlying the publication: A Bayesian inference-based framework for modelling imperfect post-repair behavior of remaining useful life under uncertainty

The .zip file contains a folder that has inside 17 pridb files. These files concern acoustic emission signals as extracted by an AMSY-6 Vallen Systeme GmbH.





## Methodology

### Experimental setup

The test campaign involves tension-tension fatigue experiments on open-hole aluminum coupons. The coupons are cut from a 2 mm thick 7075-T6 aluminum sheet parallel to the rolling direction. The length of the coupons is 300 mm and the width is 45 mm. A 6 mm hole is drilled at the middle of the coupons, and 0.5-1 mm notches are introduced at the sides of the hole to induce controlled crack growth perpendicular to the loading direction. The coupons are tested under tension-tension fatigue load, with a maximum stress of 100 MPa, a fatigue ratio of 0.1, and a frequency of 5 Hz. The suggested repair methodology involves bonding a rectangular CFRP patch via secondary bonding using an Araldite 2015-1 two-part epoxy adhesive. This repair takes place at a predefined percentage of the average fatigue life of the tested coupons. To improve adhesion and remove air gaps between the bonded parts, the repaired coupons are cured at room temperature under void pressure for 24 hours.

An acoustic emission system, comprising of an AMSY-6 Vallen Systeme GmbH and two VS900-M wideband sensors - that was recording constantly during the experiment- was employed to monitor the coupons. These signals are saved in a computer with the file extension '.pridb'.

### Dataset description

This dataset consists of 17 trajectories representing acoustic emission signal measurements for 11 coupons. Coupons with the name 'AL_0_*' correspond to ones without repair, whilst those with the name 'AL_1_*' with repair. First, 5 coupons (namely, 'AL_0_1' - 'AL_0_5') are tested until failure to get information regarding the fatigue life prior to repair and determine the constant lifetime percentage at which the repair is performed. The remaining six coupons are tested until 14000 fatigue cycles corresponding to 60% of the average fatigue life (trajectories 'AL_0_6' - 'AL_0_11'), when the developed crack was repaired with the aforementioned procedure. From those, half are tested until failure (trajectories 'AL_1_6' - 'AL_1_8') while the other half are stopped at 11000 cycles (trajectories 'AL_1_9' - 'AL_1_11'), approximately 60% of the averaged repaired coupon lifetime, to showcase that there is no need to reach failure to develop the repair model.


### Software

To read pridb files and save them to familiar formats (e.g. csv, txt, etc.) the Vallen AE Python package is recommended:

[vallenae 0.10.1](https://pyvallenae.readthedocs.io/en/stable/)

Matlab could be also considered but has not been tested in this work.
## License

![Static Badge](https://img.shields.io/badge/License-CC_BY_4.0-blue)