function [out,v,a,f] = model_main(v,cc,a,f,modes)

%% Start values
startt=tic;
[a,v] = model_defaultoutput(a,v); % default all values that have not been passed in the set-file
model_checktoolboxes({'MATLAB';'Optimization_Toolbox'; 'PDE_Toolbox'; 'Statistics_Toolbox'; 'Symbolic_Toolbox'})

%% Parameters and settings
% Coordinate vectors structure
v.x = 0:cc.dx:v.Lx;
v.z = 0:cc.dz:v.Lz;
v.f1.x = 0:cc.f1.dx:v.f1.Lx; v.f2.x = 0:cc.f2.dx:v.f2.Lx; v.f3.x = 0:cc.f3.dx:v.f3.Lx;
v.f1.H = v.f1.h; v.f2.H = v.f2.h; v.f3.H = v.f3.h;
v.f1.z = linspace(0,v.f1.H,round(v.f1.H/cc.f1.dz+1)); v.f2.z = linspace(0,v.f2.H,round(v.f2.H/cc.f2.dz+1)); v.f3.z = linspace(0,v.f3.H,round(v.f3.H/cc.f3.dz+1));
v.f1.DX = (v.Lx - v.f1.Lx)/2; v.f2.DX = (v.f2.Lx - v.f1.Lx)/2; v.f3.DX = (v.Lx - v.f3.Lx)/2; % Sluice and gate edge offset, domain I and domain II edge offset
v.f1.zQR = linspace(0,v.f1.h,round(v.f1.h/cc.f1.dz+1));
v.f3.zQR = linspace(0,v.f3.h,round(v.f3.h/cc.f3.dz+1));

%% Preallocation final matrix
M = zeros(cc.f1.modes*2,cc.f1.modes*2);
AK_1_1 = zeros(cc.smodes^2,cc.smodes^2);
AK_1_2 = zeros(cc.smodes^2,cc.smodes^2);
AK_2 = zeros(cc.f1.modes,cc.smodes^2);
BPmin_1 = zeros(cc.smodes^2,cc.f1.modes);
BPplus_1 = zeros(cc.smodes^2,cc.f1.modes);
BPmin_2 = zeros(cc.f1.modes,cc.f1.modes);
BPplus_2 = zeros(cc.f1.modes,cc.f1.modes);
BPmin_3_1 = zeros(cc.f1.modes,cc.f1.modes);
BPmin_3_2 = zeros(cc.f1.modes,cc.f1.modes);
BPplus_3_1 = zeros(cc.f1.modes,cc.f1.modes);
BPplus_3_2 = zeros(cc.f1.modes,cc.f1.modes);
Fln = zeros(1,cc.smodes^2);

%% Start omega independent part
% -----------------------------
%% Load all modes
Wxz = modes.Wxz; Wx = modes.Wx; Wz = modes.Wz; %Structural modes
f1 = model_fluidmodes_closed(v.f1,cc.f1);
f2 = model_fluidmodes_free(v.f2,cc.f2);
f3 = model_fluidmodes_free(v.f3,cc.f3);

%% Integration constant structural modes
for k = 1:cc.smodes
    for m = 1:cc.smodes
        km = (k-1)*cc.smodes+m;
        GW(km) = trapz(v.x,(trapz(v.z,Wxz(:,:,k,m).^2,2)));
        omegan(km) = modes.omegan(k,m);
    end
end

%% Modal force Fl
fprintf('Determining modal forces...\n')

% Modal force 
if a.forceintervals == 0
    if a.F==1; plot_force(v.x,v.z,f,a); end
    for l = 1:cc.smodes
       for n = 1:cc.smodes
           ln = (l-1)*cc.smodes+n;
           Fln(ln) = trapz(v.x,trapz(v.z,f.F(:,:).*Wxz(:,:,l,n),2));
       end
    end
elseif a.forceintervals == 1
    for ii = 1:f.n_ivx
        for jj = 1:f.n_ivz
            ii_ivx = f.ii_ivx;
            ii_ivz = f.ii_ivz;
            f.F = f.interval(ii,jj).F;
            for l = 1:cc.smodes
               for n = 1:cc.smodes
                   ln = (l-1)*cc.smodes+n;
                   Fln(ln) = trapz(v.x(ii_ivx(ii):ii_ivx(ii+1)),trapz(v.z(ii_ivz(jj):ii_ivz(jj+1)),f.F(ii_ivx(ii):ii_ivx(ii+1),ii_ivz(jj):ii_ivz(jj+1)).*Wxz(ii_ivx(ii):ii_ivx(ii+1),ii_ivz(jj):ii_ivz(jj+1),l,n),2));
               end
            end
            Fln_iv(:,ii,jj) = Fln(:);
        end
    end
    %     Wkones = ones(size(Wkm));
    %     Fln_check = trapz(v.x,trapz(v.z(ii_iv(ivn):ii_iv(ivn+1)),f.F(:,ii_iv(ivn):ii_iv(ivn+1)).*Wkones(:,ii_iv(ivn):ii_iv(ivn+1),l,n),2));
end

%% Qkp, Qkq, Rrq, Rrp

% Integral Q = W*P1
% Integral Q in x-direction
for k = 1:cc.smodes
    for p1 = 1:cc.f1.fxmodes
    Q_intxL(k,p1) = trapz(v.f1.x,(Wx(round(v.f1.DX/cc.dx)+1:round((v.Lx-v.f1.DX)/cc.f1.dx)+1,k).*f1.X(:,p1)));
    end
end

% Integral Q in z-direction
for k = 1:cc.smodes
    for m = 1:cc.smodes
        for p2 = 1:cc.f1.fzmodes
        Q_intzL(k,m,p2) = trapz(v.f1.zQR,(Wz(1:round((v.f1.h/cc.f1.dz+1)),k,m).*f1.Z(1:round((v.f1.h/cc.f1.dz+1)),p2)));
        end
    end
end

% Integral Q combined
for k = 1:cc.smodes
    for m = 1:cc.smodes
        km = (k-1)*cc.smodes+m;
        for p1 = 1:cc.f1.fxmodes
            for p2 = 1:cc.f1.fzmodes
            p = (p1-1)*cc.f1.fzmodes+p2;
            Q(p,km) = Q_intxL(k,p1)*Q_intzL(k,m,p2);
            end
        end
    end
end

% Integral T = W*P3
% Integral T in x-direction
for k = 1:cc.smodes
    for p1 = 1:cc.f3.fxmodes
    T_intxL(k,p1) = trapz(v.f3.x,(Wx(round(v.f3.DX/cc.dx)+1:round((v.Lx-v.f3.DX)/cc.f1.dx)+1,k).*f3.X(:,p1)));
    end
end

% Integral T in z-direction
for k = 1:cc.smodes
    for m = 1:cc.smodes
        for p2 = 1:cc.f3.fzmodes
        T_intzL(k,m,p2) = trapz(v.f3.zQR,(Wz(1:round((v.f3.h/cc.f3.dz+1)),k,m).*f3.Z(1:round((v.f3.h/cc.f3.dz+1)),p2)));
        end
    end
end

% Integral T combined
for k = 1:cc.smodes
    for m = 1:cc.smodes
        km = (k-1)*cc.smodes+m;
        for p1 = 1:cc.f3.fxmodes
            for p2 = 1:cc.f3.fzmodes
            p = (p1-1)*cc.f3.fzmodes+p2;
            T(p,km) = T_intxL(k,p1)*T_intzL(k,m,p2);
            end
        end
    end
end

% Integral R = P1*P2
% Integral R in x-direction
for r1 = 1:cc.f2.fxmodes
    for p1 = 1:cc.f1.fxmodes
    R_intxL(r1,p1) = trapz(v.f1.x,f2.X(round(v.f2.DX/cc.f2.dx)+1:round((v.f2.Lx-v.f2.DX)/cc.f2.dx+1),r1).*f1.X(:,p1));
    end
end

% Integral R in z-direction
for r2 = 1:cc.f2.fzmodes
    for p2 = 1:cc.f1.fzmodes
    R_intzL(r2,p2) = trapz(v.f1.zQR,f2.Z(1:round(v.f1.h/cc.f1.dz+1),r2).*f1.Z(1:round(v.f1.h/cc.f1.dz+1),p2));
    end
end

% Integral R combined
for r1 = 1:cc.f2.fxmodes
    for r2 = 1:cc.f2.fzmodes
        r = (r1-1)*cc.f2.fzmodes+r2;
        for p1 = 1:cc.f1.fxmodes
            for p2 = 1:cc.f1.fzmodes
                p = (p1-1)*cc.f1.fzmodes+p2;
                R(p,r) = R_intxL(r1,p1)*R_intzL(r2,p2);
            end
        end
    end
end

%% START OMEGA DEPENDENT PART
fprintf('Starting calculation of the gate fluid system for %d frequencies...\n',length(f.omegavec))
for o = 1:length(f.omegavec)
tstartloop=tic;
Omega = f.omegavec(o);
if Omega == 0; Omega = f.omegavec(2)/1000; end

%% kyI and kyII
% Compressible or incompressible fluid
if a.compressible == 1 || o == 1
v.kf = Omega/v.cp;
    
% FLUID I: Separation constant in y-direction
for p1 = 1:cc.f1.fxmodes
    for p2 = 1:cc.f1.fzmodes
        p = (p1-1)*cc.f1.fzmodes+p2;
        if (v.kf^2 - f1.kx(p1)^2 - f1.kz(p2)^2) < 0
            f1.ky(p) = -sqrt(v.kf^2 - f1.kx(p1)^2 - f1.kz(p2)^2);
        else
            f1.ky(p) =  sqrt(v.kf^2 - f1.kx(p1)^2 - f1.kz(p2)^2);
        end
        if real(f1.ky(p)) == 0; f1.ky(p)= f1.ky(p) + 10^-20; end
        if imag(f1.ky(p)) == 0; f1.ky(p)= f1.ky(p) + (10^-20)*1j; end
    end
end

% FLUID II: Separation constant in y-direction
for r1 = 1:cc.f2.fxmodes
    for r2 = 1:cc.f2.fzmodes
        r = (r1-1)*cc.f2.fzmodes+r2;
        if (v.kf^2 - f2.kx(r1)^2 - f2.kz(r2)^2) < 0
            f2.ky(r) = -sqrt(v.kf^2 - f2.kx(r1)^2 - f2.kz(r2)^2);
        else
            f2.ky(r) =  sqrt(v.kf^2 - f2.kx(r1)^2 - f2.kz(r2)^2);
        end
        if real(f2.ky(r)) == 0; f2.ky(r) = f2.ky(r) + 10^-20; end
        if imag(f2.ky(r)) == 0; f2.ky(r) = f2.ky(r) + (10^-20)*1j; end
    end
end
end

% FLUID III: Separation constant in y-direction
for t1 = 1:cc.f3.fxmodes
    for t2 = 1:cc.f3.fzmodes
        t = (t1-1)*cc.f3.fzmodes+t2;
        if (v.kf^2 - f3.kx(t1)^2 - f3.kz(t2)^2) < 0
            f3.ky(t) = -sqrt(v.kf^2 - f3.kx(t1)^2 - f3.kz(t2)^2);
        else
            f3.ky(t) =  sqrt(v.kf^2 - f3.kx(t1)^2 - f3.kz(t2)^2);
        end
        if real(f3.ky(t)) == 0; f3.ky(t)= f3.ky(t) + 10^-20; end
        if imag(f3.ky(t)) == 0; f3.ky(t)= f3.ky(t) + (10^-20)*1j; end
    end
end

%% Filling equation 1
Ik = v.rhos*(omegan.^2-Omega^2).*GW;
Ck = v.cdamp*1j*Omega*GW;

AK_1_1 = diag(Ik)+diag(Ck);
for k = 1:cc.smodes^2
    for l = 1:cc.smodes^2
        AK_1_2(l,k) = v.f3.rhof*1j*Omega^2*sum(T(:,k).*T(:,l)./(f3.ky.*f3.DZ).');
    end
end
AK_1 = AK_1_1+AK_1_2;

for l = 1:cc.smodes^2
    for p = 1:cc.f1.modes
        BPmin_1(l,p) = -v.f1.rhof*1j*Omega*Q(p,l)*exp(-1j*f1.ky(p)*v.f1.Ly);
        BPplus_1(l,p) = -v.f1.rhof*1j*Omega*Q(p,l);
    end
end

%% Filling equation 2
BPmin_2  = diag(+f1.ky.*f1.DZ.*exp(-1j*f1.ky*v.f1.Ly));
BPplus_2  = diag(-f1.ky.*f1.DZ);

for k = 1:cc.smodes^2
    for q = 1:cc.f1.modes
        AK_2(q,k) = -Omega*Q(q,k); % Not clear why - and not +
    end
end

%% Filling equation 3
BPmin_3_1  = (diag(+v.f1.rhof/v.f2.rhof*f1.DZ));
BPplus_3_1 = (diag(+v.f1.rhof/v.f2.rhof*exp(-1j*f1.ky*v.f1.Ly).*f1.DZ));

for p = 1:cc.f1.modes
    for q = 1:cc.f1.modes
        BPmin_3_2(q,p) = +f1.ky(p)*sum((R(p,:).*R(q,:))./(f2.ky.*f2.DZ));
    end
end
for p = 1:cc.f1.modes
    for q = 1:cc.f1.modes
        BPplus_3_2(q,p) = -f1.ky(p)*exp(-1j*f1.ky(p)*v.f1.Ly)*sum((R(p,:).*R(q,:))./(f2.ky.*f2.DZ));
    end
end

BPmin_3 = BPmin_3_1+BPmin_3_2;
BPplus_3 = BPplus_3_1+BPplus_3_2;
AK_3 = zeros(cc.f1.modes,cc.smodes^2);

%% Constructing total matrix and determination of modal coefficients
M = [[AK_1 BPplus_1 BPmin_1]; [AK_2 BPplus_2 BPmin_2]; [AK_3 BPplus_3 BPmin_3]];

if a.forceintervals == 0
    Fm = [Fln zeros(1,cc.f1.modes) zeros(1,cc.f1.modes)];
    MC = Fm/M.';
    Aln = MC(1:cc.smodes^2);
    Bplus = MC(cc.smodes^2+1:cc.smodes^2+cc.f1.modes);
    Bmin = MC(cc.smodes^2+cc.f1.modes+1:cc.smodes^2+2*cc.f1.modes);
elseif a.forceintervals == 1
    if a.nwaves == 0
        for i = 1:f.n_ivz
            Fln_vec(1,:) = Fln_iv(:,i);
            Fm = [Fln_vec zeros(1,cc.f1.modes) zeros(1,cc.f1.modes)];
            MC(:,i) = Fm/M.';
            Aln_iv_ifft(:,i) = MC(1:cc.smodes^2,i)*f.interval(i).Y0(o);
            Bplus_iv_ifft(:,i) = MC(cc.smodes^2+1:cc.smodes^2+cc.f1.modes,i)*f.interval(i).Y0(o);
            Bmin_iv_ifft(:,i) = MC(cc.smodes^2+cc.f1.modes+1:cc.smodes^2+2*cc.f1.modes,i)*f.interval(i).Y0(o);
        end
        Aln(1,:) = sum(Aln_iv_ifft,2);
        Bplus(1,:) = sum(Bplus_iv_ifft,2);
        Bmin(1,:) = sum(Bmin_iv_ifft,2);
    else
       	for ii = 1:f.n_ivx
            for jj = 1:f.n_ivz
            Fln_vec(1,:) = Fln_iv(:,ii,jj);
            Fm = [Fln_vec zeros(1,cc.f1.modes) zeros(1,cc.f1.modes)];
            MC = Fm/M.';
            interval(ii,jj).Aln_RAO(:,o) = MC(1:cc.smodes^2);
            interval(ii,jj).Bplus_RAO(:,o) = MC(cc.smodes^2+1:cc.smodes^2+cc.f1.modes);
            interval(ii,jj).Bplus_RAO(:,o) = MC(cc.smodes^2+cc.f1.modes+1:cc.smodes^2+2*cc.f1.modes);
            end
        end
    end
end

if a.forceintervals == 0 || a.nwaves == 0
    for r = 1:cc.f2.modes
        Cplus(r) = 1/(1j*f2.ky(r)*f2.DZ(r))*sum((-Bmin.*1j.*f1.ky+Bplus.*1j.*f1.ky.*exp(-1j*f1.ky*v.f1.Ly)).*R(:,r).'); 
    end
    for t = 1:cc.f3.modes
        Dplus(t) = Omega/(f3.ky(t)*f3.DZ(t))*sum(Aln.*T(t,:));
    end
end

% Check if solution succeeded
NrNaN = sum(isnan(MC(1,:)));
if NrNaN > 0
    error('Model solution (Aln) contains NaN. Frequency: %f (%i)',Omega,o);
end

% Restructure Akm (can be better written as resize function)
if a.nwaves == 0
for k = 1:cc.smodes
    for m = 1:cc.smodes
    km = (k-1)*cc.smodes+m;
    Akm(k,m) = Aln(km);
    end
end

if a.fft == 0
    for k = 1:cc.smodes
        for m = 1:cc.smodes
            km = (k-1)*cc.smodes+m;
            Wmodes(:,:,km) = Akm(k,m)*Wxz(:,:,k,m);
        end
    end
    w = sum(Wmodes,3);
    w_abs = abs(w); % absolute value of summed quantified mode contributions;
else
    Akm_H(:,:,o) = Akm; %
%     if o == 2; Akm_H(:,:,1) = Akm; end % Correcting first result, because solution does not work for omega = 0
end % frequency response
end

%% Plot plate shapes
if a.wetsmodes.plot >= 1
    a.wetsmodes.dataname = ['Modalshape_' num2str(o)]; a.wetsmodes.titlename = ['Resonance shape at $f_{' num2str(o) '}$ = ' num2str(round(Omega/(2*pi),1)) ' Hz'];
    plot_pshape(v,a,w,a.wetsmodes);
end
if a.wetsmodes.plot >= 2
    a.wetsmodes.dataname = ['Modalcontributions_' num2str(o)]; a.wetsmodes.titlename =['Contributions modal shapes at $\omega_{' num2str(o) '}$ = ' num2str(round(Omega/(2*pi),1)) ' Hz'];
    plot_pshape_contr(a,Akm,a.wetsmodes);
end
if a.pshape.plot >= 1;  plot_pshape(v,a,w,a.pshape); end
if a.pshape.plot >= 2;  plot_pshape_contr(a,Akm,a.pshape); end

%% Analysis per frequency - structural
if a.pstress.calc == 1
    v.D = real(v.D); % Use real part of bending rigidity

    [FZ(:,:),FX(:,:)]=gradient(w_abs,v.z,v.x); %dw/dz(x,z) and dw/dx(x,z)
    FZ(:,end) = FZ(:,end-1)+(FZ(:,end-1)-FZ(:,end-2)) + ((FZ(:,end-1)-FZ(:,end-2))-(FZ(:,end-2)-FZ(:,end-3)));
    FZ(:,1) = FZ(:,2)+(FZ(:,2)-FZ(:,3)) + ((FZ(:,2)-FZ(:,3))-(FZ(:,3)-FZ(:,4)));
    [k_zz(:,:),k_xz(:,:)] = gradient(FZ,v.z,v.x); % dw^2/dz^2, dw^2/dxdz
    k_zz(:,end) = k_zz(:,end-1)+(k_zz(:,end-1)-k_zz(:,end-2)) + ((k_zz(:,end-1)-k_zz(:,end-2))-(k_zz(:,end-2)-k_zz(:,end-3)));
    k_zz(:,1) = k_zz(:,2)+(k_zz(:,2)-k_zz(:,3)) + ((k_zz(:,2)-k_zz(:,3))-(k_zz(:,3)-k_zz(:,4)));
    [~,k_xx(:,:)] = gradient(FX,v.z,v.x); % dw^2/dx^2

    sigma_xx = -v.D*v.thy/v.I*(k_xx + v.nu*k_zz);
    sigma_zz = -v.D*v.thy/v.I*(v.nu*k_xx + k_zz); 
    tau_xz = -v.D*v.thy/v.I*(1-v.nu)*(k_xz);

    out.sigma_v = sqrt(sigma_xx.^2 - sigma_xx.*sigma_zz + sigma_zz.^2 + 3*tau_xz.^2);
    out.sigma_v_max(o) = max(max(abs(out.sigma_v)));
end
if a.pstress.plot == 1
    plot_pstress(v,a,out.sigma_v,a.pstress);
end

%% Plate deflection per frequency
% Maximum plate's deflection
if any(a.pmotion) == 1
    max_w_amp(o) = max(max(w_abs)); % plate's maximum deflection on any location, different for each omega
    for i = 1:size(a.poi,1)
    w_poi(o,i) = w_abs(round(a.poi(i,1)/cc.dx+1),round(a.poi(i,2)/cc.dz+1)); % plate's deflection at poi's
    end
end

%% Time left
tloop(o)=toc(tstartloop);
if a.freqmovie == 1
tmovdiff= tloop(o)-tmovie;
tmov = [tmovie tmovdiff a.tcomp1 a.tcomp2 a.tcomp3 a.tplot a.tsave];
disp(tmov)
end
if o == 13
    timeremainminprev = timeremainmin;
    timeremainsev.cprev = timeremainsec;
end
if o>13
    timeremainminprev = min(timeremainmin,timeremainminprev);
    timeremainsev.cprev = min(timeremainsec,timeremainsev.cprev);
end
if o>11
    tloopa = sum(tloop(end-10:end))/11;
    timeremainmin = round(tloopa*(length(f.omegavec)-o)/60);
    timeremainsec = round(tloopa*(length(f.omegavec)-o));
end
if o>12
    if or(timeremainmin < timeremainminprev,o==13) || timeremainsec < 181
        if timeremainsec > 180
            clc;fprintf('Time past: %i [min] \n',round(sum(tloop)/60))
            fprintf('Estimated time remaining: %d [min]\n',timeremainmin)
        else
            if timeremainsec < timeremainsev.cprev
                clc;fprintf('Time past: %i [min] \n',round(sum(tloop)/60))
                fprintf('Estimated time remaining: %d:%02d [min]\n', floor(timeremainsec/60),rem(timeremainsec,60))
            end
        end
    end
end
   
end % End omega loop    
fprintf('Calculation finished\n')

%% Frequency analysis after
% Find natural frequencies by peaks.
if a.pks == 1; omegapks = omegapeaks(f.omegavec,max_w_amp); end

% Plotting plate's motion over frequency range (max and poi's)
if isempty(a.poi) == 1; w_poi = []; end
if (any(a.pmotion == 1) == 1); plot_pmotion(f.omegavec,max_w_amp,w_poi,a); end

% Plotting fluid's motion over frequency range (max and poi's)
if isempty(a.poi) == 1; pfL_poi = []; pfR_poi = []; end
if a.fmotion(1) == 1; leftright = 1; plot_fmotion(f.omegavec,max_pfL_amp,pfL_poi,leftright,a); end
if a.fmotion(2) == 1; leftright = 2; plot_fmotion(f.omegavec,max_pfR_amp,pfR_poi,leftright,a); end

%% Passing all requested parameters to out. structure and .mat file
calc_time = toc(startt); a.outputpar = [a.outputpar, {'calc_time'}];
for i = 1:length(a.outputpar); out.(genvarname(a.outputpar{i})) = eval(genvarname(a.outputpar{i})); end

% Saving requested variables
if isempty(a.outputpar) == 0; save(['.\results\' a.casecode '.mat'],a.outputpar{:}); end
if a.saveresults == 1; save(['.\results\' a.casecode '_casepars.mat'],'a','f','cc','v','out'); end

%% Subfunctions
function [omegapks] = omegapeaks(omegalin,max_w_amp)
[~,pksmax] = findpeaks(max_w_amp);
if length(pksmax)>=1
    for i = 1:length(pksmax)
    omegapks(i) = omegalin(pksmax(i));
    end
else
    omegapks = 'No peaks founds';
end