function [f] = data_2Dv_makeintervals(v,cc,f,a,options)

%% Options
% --- Set unallocated options to default ---
if nargin < 4; options = struct(); end
if isfield(options,'plot') == 0; options.plot = 0; end 
if isfield(options,'dataname') == 0; options.dataname = 'integrated_and_interval_forces'; end 
if isfield(options,'specificfolder') == 0; options.specificfolder = 'force'; end 
if isfield(options,'textfontsize') == 0; options.textfontsize = 18; end 
tfss = options.textfontsize;
tfsb = tfss+5;

%% Start 
fprintf('Dividing force data into intervals..\n')

p = f.p;
z = 0:cc.dz:v.Lz;
iv_z = f.iv_z;

% Dummies for x-direction
f.ii_ivx = round(f.iv_x/cc.dx+1,0); % Indexes of interval boundaries
f.n_ivx = length(f.ii_ivx)-1;

%% Integral of each wave part
ii_ivz = round(iv_z/cc.dz+1,0); % Indexes of interval boundaries
f.n_ivz = length(ii_ivz)-1;

for i = 1:size(p,1) % loop over time steps
    for jj=1:length(ii_ivz)-1  % loop over intervals
        integral_iv(i,jj) = trapz(z(ii_ivz(jj):ii_ivz(jj+1)),p(i,ii_ivz(jj):ii_ivz(jj+1)));
    end
    integral_total(i) = trapz(z,p(i,:));
end

% Find maximum of total
if isfield(f,'pmean') == 1
    [~,i_m] = max(f.pmean);
else
    [~,i_m] = max(integral_total);
end

%% Creating new wave signal for waveparts
for jj = 1:f.n_ivz
    f.interval(jj).amp = zeros(1,size(p,1));
end
for i = 1:size(p,1) % loop over time steps
    for jj=1:length(ii_ivz)-1  % loop over intervals
        f.interval(jj).amp(i) = integral_iv(i,jj)/(z(ii_ivz(jj+1))-z(ii_ivz(jj))); % average pressure at time step
    end
end

%% Creating force vector for frequency analysis
f.static.F = zeros(length(0:cc.dx:v.Lx),length(0:cc.dz:v.Lz),1,1);
for jj = 1:f.n_ivz
f.interval(jj).F = zeros(length(0:cc.dx:v.Lx),length(0:cc.dz:v.Lz),1,1);
end
for j = 1:length(0:cc.dx:v.Lx)
    for jj=1:length(ii_ivz)-1  % loop over intervals
        f.interval(jj).F(j,ii_ivz(jj):ii_ivz(jj+1),1,1) = 1;
        f.static.F(j,ii_ivz(jj):ii_ivz(jj+1),1,1) =  f.interval(jj).amp(i_m);
    end
end

%% Construct force parameters for analysis
f.n_ivz = length(ii_ivz)-1;
f.ii_ivz = ii_ivz;
f.totalforce = integral_total;

%% Plot total force and intervals
if options.plot == 1
t_min = -0.0501; % Lower bound of extracted response interval
t_max = 0.20; % Upper bound of extracted response interval
[~,index_start] = find(f.t >= t_min,1,'first');
[~,index_end] = find(f.t >= t_max,1,'first');

figure
subplot(15,1,[1:8])
plot(1000*f.t(index_start:index_end),f.totalforce(index_start:index_end)/1000,'k','LineWidth',1);
xlim([1000*f.t(index_start) 1000*f.t(index_end)]);
grid on
box on
hold on

%xlabel('Time [s]','Interpreter','Latex','Fontsize',tfsb);
set(gca,'xticklabel',{[]})
ylabel('Force [kN/m$^1$]','Interpreter','Latex','Fontsize',tfsb);
set(gca,'Ticklabelinterpreter','Latex','Fontsize',tfss)
% set(gcf, 'units','normalized','outerposition',[0 0 1 3/4],'color','white');

subplot(15,1,[9:15])
hold on
for i = 1:f.n_ivz
plot(1000*f.t(index_start:index_end),f.interval(i).amp(index_start:index_end)/1000,'LineWidth',1);
legendentries{i} = num2str(i);
end
xlim([1000*f.t(index_start) 1000*f.t(index_end)]);
grid on
box on
xlabel('Time [ms]','Interpreter','Latex','Fontsize',tfsb);
ylabel('Pressure [kN/m$^2$]','Interpreter','Latex','Fontsize',tfsb);
set(gca,'Ticklabelinterpreter','Latex','Fontsize',tfss)
set(gcf, 'units','normalized','outerposition',[0 0 1 1],'color','white');
legend(legendentries);

if a.saveplots == 1
    specificfolder = options.specificfolder;
    fullfoldername = fullfile(a.plotfolder,specificfolder);
    if ~exist(fullfoldername, 'dir'); mkdir(fullfoldername); end
    figurename = options.dataname;
    fullfigurename = fullfile(fullfoldername, figurename);
    export_fig(fullfigurename,'-png','-eps');
end
end



