function a = plot_t_pmotion_probcase(wt,f,v,cc,a,options)

% --- Set unallocated options to default ---
if nargin < 5; options = struct(); end
if isfield(options,'plottype') == 0; options.plottype = 'noforce'; end
if isfield(options,'findmax') == 0; options.findmax = 0; end
if isfield(options,'dataname') == 0; options.dataname = 'Platedeflection'; end 
if isfield(options,'specificfolder') == 0; options.specificfolder = ''; end 
if isfield(options,'textfontsize') == 0; options.textfontsize = 16; end 
if isfield(options,'saveresponses') == 0; options.saveresponses = 0; end 
if isfield(options,'xlims') == 0; options.xlims = [f.t(1) f.t(end)]; end 

tfss = options.textfontsize;
tfsb = tfss+2;

% Find location and time where maximum deflection occurs
% Maximum absolute deflection per time step
if options.findmax == 1 
[max_wt(1,:)] = max(max(abs(wt),[],1),[],2); max_wt_abs = abs(max_wt);
[it,~] = find(max_wt_abs == max(max_wt_abs),1,'first');
w_at_t_max(:,:) = wt(:,:,it);
max_w_at_t_max = max(max(w_at_t_max));
[iz,ix] = find(w_at_t_max == max_w_at_t_max,1,'first');
a.poi = [v.zs(iz) v.xs(ix); a.poi];
end

%-Figure------------------------------------------------------------------
linestyle = {'k-','k--','k:','k-.'};%{'k-','k.-','ks-','kd-','k+-','kp-'};
legendi = {};
figure
tplot = f.t;
mi = size(wt,3); % Could be used to shorten plot
%-------------------------------------------------------------------------
if strcmp(options.plottype,'withforce') == 1; subplot(3,1,[1 2]); end
for i = 1:size(a.poi,1)
    wrespplot(1,:) = wt(round(a.poi(i,1)/cc.dx+1,0),round(a.poi(i,2)/cc.dz+1,0),:)*1000; % from m to mm
    phasesign = real(sign(wrespplot)); phasesign(isnan(phasesign)==1) = 0;
    wrespplot_amp = abs(wrespplot).*phasesign;
    if options.saveresponses == 1
        save([a.casefolder '/Results/response_sw_' num2str(a.waves) '_comp_' num2str(a.compressible) '_poi_' num2str(i)],'wrespplot_amp')
        save([a.casefolder '/Results/response_study_general'])
    end
    if size(a.poi,1) <= length(linestyle)
    plot(tplot(1:mi),real(wrespplot_amp(1:mi)),linestyle{i}); hold on
    else
    plot(tplot(1:mi),real(wrespplot_amp(1:mi))); hold on
    end
    legendi{end+1} = ['(x,z) = (' num2str(a.poi(i,1)) ',' num2str(a.poi(i,2)) ') m'];
    maxwrespplot(i) = max(abs(wrespplot_amp));
    [~,jj] = find(wrespplot_amp == maxwrespplot(i));
    maxwt(i) = tplot(jj);
    clear wrespplot
    clear wrespplot_amp
end
maxw = max(maxwrespplot);
[~,jj] = find(maxwrespplot == maxw);
plot(maxwt(jj),maxw,'ro','LineWidth',1.5);
% ylim([-70 70])
ylim([-1.1*maxw 1.1*maxw]);
ll=legend(legendi);
set(ll,'Interpreter','Latex','Fontsize',tfss);
xlim([options.xlims(1) options.xlims(2)]);
grid on
ax = gca;
%ax.YAxisLocation = 'origin';
if options.numaxis == 0
    set(gca,'YTick',[]);
    ylabel('Deflection','Interpreter','Latex','Fontsize',tfsb);
elseif options.numaxis == 1
    ylabel('Deflection [mm]','Interpreter','Latex','Fontsize',tfsb);
end
set(gca,'Ticklabelinterpreter','Latex','Fontsize',tfss)

%-------------------------------------------------------------------------
if strcmp(options.plottype,'withforce') == 1
subplot(3,1,3)
plot(tplot(1:mi),f.totalforce(1:mi)/1000,'k','LineWidth',1); hold on
xlabel('Time [s]','Interpreter','Latex','Fontsize',tfsb);
xlim([options.xlims(1) options.xlims(2)]);
%ylim([-1.1*max(abs(f.totalforce/1000)) 1.1*max(abs(f.totalforce/1000))])
ax = gca;
%ax.YAxisLocation = 'origin';
grid on
    if options.numaxis == 0
        set(gca,'YTick',[]);
        ylabel('Force amplitude','Interpreter','Latex','Fontsize',tfsb);
    elseif options.numaxis == 1
        if strcmp(options.plottype,'total') == 1
            ylabel('Force [kN/m]','Interpreter','Latex','Fontsize',tfsb);
        else
            ylabel('Pressure [kN/m$^2$]','Interpreter','Latex','Fontsize',tfsb);
        end
        set(gca,'Ticklabelinterpreter','Latex','Fontsize',tfss)
    end
end
%-------------------------------------------------------------------------
if strcmp(options.plottype,'withforce') == 1
   set(gcf, 'units','normalized','outerposition',[0 0 1 1],'color','white');
else
   set(gcf, 'units','normalized','outerposition',[0 0 1 2/3],'color','white');
end 

if a.saveplots == 1
    if isfield(options,'specificfolder') == 1
        specificfolder = options.specificfolder;
    else
        specificfolder = 'dyn_t_resp';
    end
    fullfoldername = fullfile(a.plotfolder,specificfolder);
    if ~exist(fullfoldername, 'dir'); mkdir(fullfoldername); end
    figurename = options.dataname;
    fullfigurename = fullfile(fullfoldername, figurename);
    export_fig(fullfigurename,'-png','-eps');
end

%function end
end