function plot_fshape(v,a,pf_amp,options)

% --- Set unallocated options to default ---
if isfield(options,'title') == 0
    if isfield(options,'titlename') == 1; options.title = 1; else options.title = 0; end
end
if isfield(options,'dataname') == 0; options.dataname = 'Fluidshape_contr'; end 
if isfield(options,'specificfolder') == 0; options.specificfolder = ''; end 
if isfield(options,'nmodes_contr') == 0; options.nmodes_contr = 1000; end
if isfield(options,'textfontsize') == 0; options.textfontsize = 20; end 
if isfield(options,'axis_normalised') == 0; options.axis_normalised = 0; end 
if isfield(options,'ylims') == 0; options.ylims = [0 0]; end 
tfss = options.textfontsize;
tfsb = tfss+5;

% Plot total plate shape
phasesign = real(sign(pf_amp));
phasesign(isnan(phasesign)==1) = 0;
pf_amp = abs(pf_amp.').*phasesign.';

mm_pf_amp_abs = max(max(abs(pf_amp)));
[ii,jj] = find(abs(pf_amp) == mm_pf_amp_abs,1,'first');
mm_pf_amp = pf_amp(ii,jj);

% Plot fluid total shapes
ff=figure;
if options.axis_normalised == 1
    contourf(v.x,v.z,pf_amp/mm_pf_amp,30)
    hold on
    h=colorbar;
    set(h, 'ylim', [-1 1]);
    caxis([-1 1])
else
    contourf(v.x,v.z,pf_amp,30)
    hold on
    h=colorbar;
    if options.ylims(1) > 0 || options.ylims(2) > 0
        set(h, 'ylim', [options.ylims(1) options.ylims(2)]);
        caxis([options.ylims(1) options.ylims(2)])
    else
        set(h, 'ylim', [-abs(mm_pf_amp) abs(mm_pf_amp)]);
        caxis([-abs(mm_pf_amp) abs(mm_pf_amp)])
    end
end
axis equal
set(gca,'Ticklabelinterpreter','Latex','Fontsize',tfss)

if options.title == 1
    title(options.titlename,'Interpreter','Latex','Fontsize',tfsb);
end

%% Setting width colorbar and size figure
set(gcf,'Units','Normalized','Position',[0.1 0.1 0.9 0.8])
colorbarpos=get(h,'Position');
gcapos = get(gca,'Position');
colorbarpos(3)=0.6*colorbarpos(3);
set(h,'Position',colorbarpos);
set(gca,'Position',gcapos);

%% Save figure
if a.saveplots == 1
        fullfoldername = fullfile(a.plotfolder,options.specificfolder);
        if ~exist(fullfoldername, 'dir'); mkdir(fullfoldername); end
        figurename = options.dataname;
        fullfigurename = fullfile(fullfoldername, figurename);
        export_fig(fullfigurename,'-png','-eps')
end

