function plot_fmodes1D(zf,Z,h)
global s_plots
global outputfigures
global p_tit

sz = size(Z);

figure;
subplot(1,2,1)
plot([0, 0], [min(zf) max(zf)+0.5], '-k','LineWidth',2); hold on
plot([-1, 1], [h h], '--b'); hold on
plot(Z(:,1),zf,'LineWidth',1.5); hold on
ylim([min(zf) max(zf)+0.5])
grid on
ylabel('z-direction [m]','Interpreter','LaTeX','fontsize',16)
xlabel('relative potential [-]','Interpreter','Latex','fontsize',16)
if p_tit == 1; title('Propagating mode','Interpreter','Latex','Fontsize',16); end
set(gca,'Ticklabelinterpreter','Latex','Fontsize',15)
subplot(1,2,2)
plot([0, 0], [min(zf) max(zf)+0.5], '-k','LineWidth',2); hold on
plot([-1, 1], [h h], '--b'); hold on
for i = 2:sz(2)
plot(Z(:,i),zf,'LineWidth',1.5); hold on
end
ylim([min(zf) max(zf)+0.5])
grid on
ylabel('z-direction [m]','Interpreter','Latex','fontsize',16)
xlabel('relative potential [-]','Interpreter','Latex','fontsize',16)
set(gca,'Ticklabelinterpreter','Latex','Fontsize',15)
ll=legend('Gate','Still water level');
set(ll,'Interpreter','Latex','Fontsize',15)
if p_tit == 1; title('Evanescent modes','Interpreter','Latex','Fontsize',16); end
if s_plots == 1;
    figurename = sprintf('propmode_%d', Omega);
    fullfigurename = fullfile(outputfigures, figurename);
    export_fig(fullfigurename,'-eps','-png')
end

% Function end
end