function plot_fmodes(v,fshape,cc,Omega,a,options)
alt = 1;
options.title = 1;
options.specificfolder = 'system/fmodes'; 
if isfield(options,'textfontsize') == 0; options.textfontsize = 20; end 
tfss = options.textfontsize;
tfsb = tfss+5;

xf = v.xf;
zf = v.zf;
P = fshape.P;
fmodes = cc.fzmodes;

%% Contourplots fluid modes
for p = 1:fmodes
    for r = 1:fmodes
%         options.dataname = ['Fluidmodes_' fshape.side '_' num2str(p) '_' num2str(r) '_freq_' num2str(round(Omega)) ];
        ii = figure;
        pr = (p-1)*fmodes+r;
        contourf(xf,zf,P(:,:,pr)',25)
        axis equal
        caxis([-1 1])
        h=colorbar;
        
        %% Specific figure appearance and labels 1
        set(gca,'Fontsize',tfss)
        xlabel('x-direction [m]','Interpreter','Latex','Fontsize',tfsb);
        ylabel('z-direction [m]','Interpreter','Latex','Fontsize',tfsb);
        set(gca,'TicklabelInterPreter','LaTex','Fontsize',tfss)
        set(gcf, 'Color', 'w');
        
        %% Title
        titlename = ['Modal fluid shape (' num2str(p) ',' num2str(r) ')'];   
        if options.title == 1; title(titlename,'Interpreter','Latex','Fontsize',tfsb); end
        
        %% Setting width colorbar and size figure
        set(gcf,'Units','Normalized','Position',[0.1 0.1 0.9 0.8])
        colorbarpos=get(h,'Position');
        gcapos = get(gca,'Position');
        colorbarpos(3)=0.6*colorbarpos(3);
        set(h,'Position',colorbarpos);
        set(gca,'Position',gcapos);   
        
        %% Saving figure
        if a.saveplots == 1;
                fullfoldername = fullfile(a.plotfolder,options.specificfolder);
                if ~exist(fullfoldername, 'dir'); mkdir(fullfoldername); end
                figurename = options.dataname;
                fullfigurename = fullfile(fullfoldername, figurename);
                export_fig(fullfigurename,'-png')
        end
             
    end
end

% Function and if end
end