function f = forcetime_church(f,tin,Fin)

% Time points in church signal
tend = f.tend; % length of time signal (s)
tsig = [0 tin];
tsig = [tsig tend];

% Force points in church signal
if f.cooker == 1;
    dtpk = tsig2(2)-tsig2(1);
    ppk = 2*f.Ppk/dtpk;
    Fa = ppk;
    Fb = ppk/10;
    Fc = ppk/10;
    Fd = 0;
end
    
Fsig = [0 Fin 0];

dt = f.dt; % timestep (s)
t = 0:dt:tend;

% 'Drawing' church signal
j = 2;
for i = 1:length(t)
    if t(i) <= tsig(1)
        amp(i) = Fsig(1);
    else
        if t(i) >= tsig(j)
            j=j+1;
            if i == length(t)
                j = j-1;
            end
        end
        amp(i) = (t(i)-tsig(j-1))/(tsig(j)-tsig(j-1))*(Fsig(j)-Fsig(j-1))+Fsig(j-1);
    end
end

f.amp = amp;
f.t = t;

% % % % % Even sized time length
% % % % if mod(length(t),2) == 1
% % % %     f.n = nt-1;
% % % % else
% % % %     f.n = nt;
% % % % end
% % % % f.t = t(1:f.n);
% % % % f.amp = amp(1:f.n);
% % % % 
% % % % % Fourier transform
% % % % fs = 1/dt;  % Sample frequency (Hz) = number of points / second
% % % % fnyq = fs/2; % Nyquist frequency (Hz)
% % % % freq = (0:f.n-1)*(fs/f.n);
% % % % 
% % % % % FFT
% % % % f.Y = fft(f.amp);
% % % % f.omegafft = freq*2*pi;
% % % % 
% % % % % Shortened FFT results
% % % % f.Y0 = f.Y(1:f.n/2+1);
% % % % f.omegavec = freq(1:f.n/2+1)*2*pi;

%% Backup
% figure
% plot(f.omegavec,real(f.Y0)*2/n); hold on
% plot(f.omegavec,imag(f.Y0)*2/n); hold on
% plot(f.omegavec,abs(f.Y0)*2/n); hold on
% legend('Real (sine)','Imaginary (cosine)','Abs')
% grid on
% figure
% plot(f.omegavec,phase(f.Y0*2/n)); hold on
% legend('Phase')
% grid on
% 
% Yresp = Y0 .* H;
% Yresptr(1:n/2+1) = Yresp;
% Yfliptr = fliplr(conj(Yresp));
% Yresptr(n/2+2:n) = Yfliptr(2:end-1);
% 
% Fresp = ifft(Yresptr);
% 
% for i = 1:length(omega)
%     Fali_exp(:,i) =  1/n*Y(i)*exp(1j*omega(i)*t);
% end
% Fal_exp = sum(Fali_exp,2); Fal_exp = Fal_exp.';
% 
% figure
% plot(t,amp,'k');
% hold on;
% plot(t,Fal_exp,'.m');
% hold on
% plot(t,Fresp,'r-');
% grid on;
% ll=legend('Original','Original $\rightarrow$ matlab fft $\rightarrow$ analytical iDFT','Tranformed','Check of transformed');
% set(ll,'Interpreter','Latex');
