function f = forceshape_cooker(v,cc,f,a)

% Cooker impulse theory is used
f.cooker = 1;

% Linespaces along gate and fluid
v.xs = linspace(0,v.Lx,v.Lx/cc.dx+1);
HR = v.hR+v.zbot; % Water height above gate bottom right side
v.zfR = linspace(v.zbot,HR,round((HR-v.zbot)/cc.dz+1));

mu=0.5;%4.44
U0=1.22;
dt=0.03;
rho=v.rhof;

N = 10000;% number of harmonics in analytical solution
for n = 1:N
    lambdan = (n-0.5)*pi;
    an = 2*U0*(cos(mu*lambdan)-1)/(lambdan^2);
    Pn(:,n) = v.rhof*v.hR*an*sin(lambdan*(v.zfR-v.hR)/v.hR);
end
Pz(1,:) = sum(Pn,2);

if a.F == 1;
figure
plot(Pz/(rho*U0*v.hR),v.zfR/v.hR,'k','LineWidth',1.5)
set(gca,'Fontsize',14)
xlabel('$P/(\rho_{f} U_{0} H)$ [-]','Interpreter','Latex','Fontsize',18);
ylabel('z/H [-]','Interpreter','Latex','Fontsize',18);
set(gca,'Ticklabelinterpreter','Latex','Fontsize',15)
set(gcf, 'color', 'white');
if a.saveplots == 1;
    figurename = sprintf('cookerimpulsevertical');
    fullfigurename = fullfile(a.plotfolder, figurename);
    export_fig(fullfigurename,'-png','-eps')
end
end

% Normalising and extending over x-direction to full plate
f.Ppk = max(Pz);
Pz = Pz/max(Pz);
Px(:,1) = ones(1,length(v.xs));
f.F = Px*Pz;

end