function f = model_fouriertransform(f,maxomeg)

%% Change to time vector, adding zero force at start and end of interval
f.tin = f.t; % time vector before fourier transform
f.t = f.t-f.t(1); % setting start time vector at zero
dt = f.t(2)-f.t(1); % the time step, remains unchanged

tend = f.t(end); % end of time vector, will increase
f.t = 0:dt:(f.addstart+tend+f.addend)-dt;% add time for start and end to time vector
nt = length(f.t); % new length of time vector

if mod(length(f.t),2) == 1
    f.n = nt-1;
else
    f.n = nt;
end
f.t = f.t(1:f.n); % new even sized length of time vector

%% Loop with fourier transform of each force interval
for ii = 1:f.n_ivx
    for jj = 1:f.n_ivz
    clear f.amp f.ampn
    f.amp = f.interval(ii,jj).amp; % Load amplitude for given interval

    %% Add start time and end time with amp=0
    f.amp = f.interval(ii,jj).amp;
    f.ampn(1:round(f.addstart/dt)) = 0;
    f.ampn(round(f.addstart/dt)+1:round((f.addstart+tend)/dt)+1) = f.amp;
    f.ampn(round((f.addstart+tend)/dt)+2:round((f.addstart+tend+f.addend)/dt)+1) = 0;
    f.amp = f.ampn(1:f.n); % New longer amplitude signal
    f.interval(ii,jj).amp = f.amp; % new even sized length per interval saved as output

    %%  Fourier transform
    f.fs = 1/dt;  % Sample frequency (Hz) = number of points / second
    f.fnyq = f.fs/2; % Nyquist frequency (Hz)
    f.freq = (0:f.n-1)*(f.fs/f.n); % Frequency vector

    % Performing FFT
    f.interval(ii,jj).Y = fft(f.amp); % performing frequency

    % Shortening results of FFT to half as result is symmetric
    f.interval(ii,jj).Y0 = f.interval(ii,jj).Y(1:f.n/2+1); % outcome of the fft that is transformed back after multiplying with response
    f.omegavec = f.freq(1:f.n/2+1)*2*pi; % vector with frequencies used in the gate-fluid main model
    f.n_restore = length(f.omegavec); % To restore amplitude vector to the required length for an inverse transform

    % Shortening frequency vector to maximum relevant given as input
    if nargin == 2 && maxomeg>0 && maxomeg < f.omegavec(end)
        [~,f.n_shortened] = find(f.omegavec >= maxomeg,1,'first');
        f.omegavec = f.omegavec(1:f.n_shortened);
    else
        f.n_shortened = f.n;
    end
    f.tshift = f.tin(1)-f.t(1)-f.addstart; % Shift in time saved for plotting later

    end
end

%% Add start time and end time with amp=0 to totalforce
f.totalforcen(1:round(f.addstart/dt)) = 0;
f.totalforcen(round(f.addstart/dt)+1:round((f.addstart+tend)/dt)+1) = f.totalforce;
f.totalforcen(round((f.addstart+tend)/dt)+2:round((f.addstart+tend+f.addend)/dt)+1) = 0;
f.totalforce = f.totalforcen; % New longer amplitude signal
