function [fshape,ccf,af] = model_fluidmodes_surface(vf,ccf,af,Omega)


%% Determining fshapes
% X-direction, constant and fshape
for p = 1:ccf.fxmodes
    fshape.kx(p) = (p-1)*pi/vf.Lx; % Separation constant
    for i = 1:length(vf.xf)
        fshape.X(i,p) = cos(fshape.kx(p)*(vf.xf(i)-vf.DX));
    end
end
       
% Z-direction, constants
if af.imagwave == 1
for r = af.imagwave % Imaginary value
    disp_imag = @(k) k*vf.g*tanh(k*vf.h) - Omega^2; % dispersion equation
    kz_imag = abs(fsolve(disp_imag,200,ccf.optionsfsol)); fshape.kz(r) = kz_imag*1j; % solving and assigning imaginary kz
end
end

for r = (1+af.imagwave):ccf.fzmodes % Real values
    if af.realwave == 1
        disp_real = @(k) -k*vf.g*tan(k*vf.h) - Omega^2; % dispersion equation
        fshape.kz(r) = abs(lsqnonlin(disp_real,(r-af.imagwave-0.25)*pi/vf.h,(r-af.imagwave-0.4999999999)*pi/vf.h,(r-af.imagwave-0.00000000001)*pi/vf.h,ccf.optionsnonlin)); % solving and assigning real kz
    elseif af.realwave == 0
        fshape.kz(r) = ((2*(r-af.imagwave)-1)*pi)/(2*vf.h);
    end
end

% Z-direction, fshapes
for r = 1:ccf.fzmodes
    for i = 1:length(vf.zf)
       fshape.Z(i,r) = cos(fshape.kz(r)*(vf.zf(i)-vf.zbot));
    end
    % Normalising z-fshapes
    fshape.Z(:,r) = fshape.Z(:,r)./max(abs(fshape.Z(:,r)));
end

% Combined 2D fshape
for p = 1:ccf.fxmodes
    for r = 1:ccf.fzmodes
        pr = (p-1)*ccf.fxmodes+r;
        fshape.P(:,:,pr) = fshape.X(:,p)*transpose(fshape.Z(:,r));
    end
end

% Integration constant fluid modes
for p = 1:ccf.fxmodes
    for r = 1:ccf.fzmodes
        pr = (p-1)*ccf.fzmodes+r;
        fshape.DZ(pr) = trapz(vf.xf,fshape.X(:,p).^2)*trapz(vf.zf,fshape.Z(:,r).^2);
    end
end

%% Check whether surface wave still influences the fluid reponse
% If imaginary fshape leads to NaN or INF, it does not contain energy anymore. Case
% is swithed to no waves.
if abs(fshape.kz(af.imagwave+1)-pi/(2*vf.h))<0.0001*pi/(2*vf.h) && af.realwave == 1;
   af.realwave = 0;   
end

if isnan(fshape.Z(end,1)) == 1 && af.imagwave == 1;
    af.imagwave = 0;
    ccf.fzmodes = ccf.fzmodes-1;
    clear fshape;
    [fshape,ccf,af] = model_fluidmodes_surface(vf,ccf,af,Omega);
end

if af.imagwave == 0 && af.realwave == 0;
    af.wavesswitched = 1;
    af.waves = 0;
    clear fshape;
    [fshape] = model_fluidmodes(vf,ccf);
end

%% Plotting modes
% if af.fmodes == 1; plot_fmodes1D(vf.zf,fshape.Z,vf.h,a); end
% if af.fmodes == 2; plot_fmodes(vf.xf,vf.zf,fshape.P,ccf.fmodes,Omega,a); end
