function [a,v] = model_defaultoutput(a,v)

%% Set default values for non-existing fields

%----------------General------------------------
if isfield(a,'plot') == 0; a.plot = 1; end % plot 0/1
if isfield(a,'poi') == 0; a.poi = []; end % Points of interest [x z] on plate, where plate amplitudes and fluid pressures will be evaluated (per frequency and/or timestep)
if isfield(a,'F') == 0; a.F = 0; end % Plot the force shape
if isfield(a,'fluid') == 0; a.fluid = 1; end  % Include fluid in the calculations, 0=dry, 1=wet
if isfield(a,'run') == 0; a.run = 1; end  % Run number to save
if isfield(a,'waves') == 0; a.waves = 1; end  % Include surface waves in the calculations, 0=dry, 1=wet
if isfield(a,'compressible') == 0; a.compressible = 1; end  % Include compressibilty in the calculations, 0=dry, 1=wet
if isfield(a,'outputpar') == 0; a.outputpar = {}; end
if isfield(a,'tensions') == 0; a.tensions = 0; end
%----------------Frequency----------------------
if isfield(a,'freqmovie') == 0; a.freqmovie = 0; end
if isfield(a,'vidobj') == 0; a.vidobj = 0; end
if isfield(a,'pmotion') == 0; a.pmotion = [0 0 0]; end % 0/1 defl, 0/1 velocity, 0/1 acceleration
if isfield(a,'pmotion_ylim') == 0; a.pmotion_ylim = []; end % ylimits plots delf, vel, acc
if isfield(a,'fmotion') == 0; a.fmotion = [0 0 0]; end % 0/1 pressure L, pressure R,
if isfield(a,'fmotion_ylim') == 0; a.fmotion_ylim = []; end  % ylimits plots defl [low high]; vel [low high]; acc
if isfield(a,'pks') == 0; a.pks = 0; end % determine natural frequencies by searching peaks in deflection response
if isfield(a,'drysmodes') == 0; a.drysmodes = struct('plot',0); end 
if isfield(a,'wetsmodes') == 0; a.wetsmodes = struct('plot',0); end 
if isfield(a,'fmodes') == 0; a.fmodes.plot = [0 0]; end % plot title 0=off/1=on
if isfield(a,'pshape') == 0; a.pshape.plot = 0; end % 0:off/1:2D /2: +contributions/ 3 [L/R]
if isfield(a,'fshapeL') == 0; a.fshapeL.plot = 0; end % 0:off/1:2D /2: +contributions/  phi shape L, phi shape R
if isfield(a,'fshapeR') == 0; a.fshapeR.plot = 0; end % 0:off/1:2D /2: +contributions/  phi shape L, phi shape R
if isfield(a,'fsliceL') == 0; a.fsliceL.plot = 0; end % slice plot (3D), L
if isfield(a,'fsliceR') == 0; a.fsliceR.plot = 0; end % slice plot (3D), R
if isfield(a,'plotfmodes') == 0; a.plotfmodes = 10; end
if isfield(a,'pstress') == 0; a.pstress.plot = 0; a.pstress.calc = 0; end

%----------------Time---------------------------
if isfield(a,'H') == 0; a.H = [0 0 0]; end
if isfield(a,'title') == 0; a.title = 1; end % plot title 0=off/1=on
if isfield(a,'fft') == 0; a.fft = 0; end %
if isfield(a,'nwaves') == 0; a.nwaves = 0; end %
if isfield(a,'freqmovie') == 0; a.freqmovie = 0; end
if isfield(a,'forceintervals') == 0; a.forceintervals = 0; end % Calculation with force divided into intervals

%----------------Initial values---------------------------
a.f1.wavesswitched = 0;
a.f2.wavesswitched = 0;

% ---------------Plotting---------------------------------
if isfield(a,'title') == 0; a.title = 1; end % plot title 0=off/1=on
% --------------Values------------------------------------------
if isfield(v.f1,'rhof') == 0; v.f1.rhof = v.rhof; end % 
if isfield(v.f2,'rhof') == 0; v.f2.rhof = v.rhof; end % 
% --------------Values------------------------------------------
if isfield(v,'cdamp') == 0; v.cdamp = 0; end 
    
%% Set values based on given fields
if a.freqmovie == 1
    a.plot = 0;
    if a.pshape(2) == 0; a.pshape(2) = 4; end
    if a.fshape(2) == 0; a.fshape(2) = 4; end
    a.pmotion(1) = 1;
end

if a.fft == 1
    if a.nwaves == 0
    a.outputpar = [a.outputpar, {'Akm_H'}];
    else
    a.outputpar = [a.outputpar, {'interval'}];
    end
end

if a.pks == 1
    a.outputpar = [a.outputpar, {'omegapks'}];
    a.pmotion = [1 0 0];
end

if a.saveplots == 1; if ~exist(a.plotfolder, 'dir'); mkdir(a.plotfolder); end; end

if (any(a.pmotion == 1) == 1)
    a.outputpar = [a.outputpar, {'max_w_amp'}];
    if isempty(a.poi)==0
        a.outputpar = [a.outputpar, {'w_poi'}]; 
    end
end

% Fluid modes
if a.waves == 1
    a.f1.waves = 1;
    a.f2.waves = 1;
    a.f1.imagwave = 1; % Include imaginary surface wave (damping)
    a.f2.imagwave = 1; % Include imaginary surface wave (damping)
    a.f1.realwave = 1; % Include real surface waves (effect of surface waves waves on the hydrodynamic mass)
    a.f2.realwave = 1; % Include real surface waves (effect of surface waves waves on the hydrodynamic mass)
else
    a.f1.waves = 0;
    a.f2.waves = 0;  
end
if a.compressible == 1
    a.f1.compressible = 1;
    a.f2.compressible = 1;
else
    a.f1.compressible = 0;
    a.f2.compressible = 0;
end