function [f] = data_2Dv_interpolate(v,cc,f,options)
fprintf('Interpolating force data..\n')

%% Complement z-data with extra zero point at (end), and equal to new (2) at (bottom)
zq = 0:cc.dz:v.Lz;
 
if f.z(end) ~= v.f1.h
    f.z(end+1) = v.f1.h;
    if strcmp(options.bctop,'open') == 1
    f.p(:,end+1) = 0;
    elseif strcmp(options.bctop,'closed') == 1
    f.p(:,end+1) = f.p(:,end); 
    end
end
if v.f1.h < v.Lz
   f.z(end+1) = v.f1.h+0.001;
   f.z(end+1) = v.f1.h+0.002;
   f.p(:,end+1) = 0;
   f.p(:,end+1) = 0;
end

if f.z(1) ~= 0
    f.z(2:length(f.z)+1) = f.z;
    f.z(1) = 0;
    f.p(:,2:size(f.p,2)+1) = f.p;
end

p_interp = zeros(size(f.p,1),size(zq,2));
for i = 1:size(f.p,1)
    p_interp(i,:) = interp1(f.z,f.p(i,:),zq,'PCHIP');
end
f.p = p_interp;