function a = plot_t_pmotion(wt,f,v,cc,a,options)

tplot = f.t;

% Find location and time where maximum deflection occurs
% Maximum absolute deflection per time step
[max_wt(1,:)] = max(max(abs(wt),[],1),[],2); max_wt_abs = abs(max_wt);
[it,~] = find(max_wt_abs == max(max_wt_abs));
w_at_t_max(:,:) = wt(:,:,it);
max_w_at_t_max = max(max(w_at_t_max));
[iz,ix] = find(w_at_t_max == max_w_at_t_max,1,'first');
a.poi = [v.zs(iz) v.xs(ix); a.poi];

mi = size(wt,3);
mintplot=f.t(1);

%-Figure------------------------------------------------------------------
linestyle = {'k-','k--','k:','k-.'};%{'k-','k.-','ks-','kd-','k+-','kp-'};
legendi = {};
figure
%-------------------------------------------------------------------------
if strcmp(options.plottype,'noforce') == 0; subplot(3,1,[1 2]); end
for i = 1:size(a.poi,1)
    wrespplot(1,:) = wt(round(a.poi(i,1)/cc.dx+1,0),round(a.poi(i,2)/cc.dz+1,0),:)*1000; % from m to mm
    %wrespplot = wrespplot(1:mi);
    phasesign = real(sign(wrespplot)); phasesign(isnan(phasesign)==1) = 0;
    wrespplot_amp = abs(wrespplot).*phasesign;
    if size(a.poi,1) <= length(linestyle)
    plot(tplot(1:mi),real(wrespplot_amp(1:mi)),linestyle{i}); hold on
    else
    plot(tplot(1:mi),real(wrespplot_amp(1:mi))); hold on
    end
    legendi{end+1} = ['(x,z) = (' num2str(a.poi(i,1)) ',' num2str(a.poi(i,2)) ') m'];
    maxwrespplot(i) = max(abs(wrespplot));
    clear wrespplot
    clear wrespplot_amp
end
maxw = max(maxwrespplot);
ylim([-1.1*maxw 1.1*maxw]);
ll=legend(legendi);
set(ll,'Interpreter','Latex','Fontsize',16);
xlim([tplot(1) tplot(mi)]);
grid on
ax = gca;
%ax.YAxisLocation = 'origin';
if options.numaxis == 0; 
    set(gca,'YTick',[]);
    ylabel('Deflection','Interpreter','Latex','Fontsize',18);
elseif options.numaxis == 1;
    ylabel('Deflection [mm]','Interpreter','Latex','Fontsize',18);
end
set(gca,'Ticklabelinterpreter','Latex','Fontsize',17)

%-------------------------------------------------------------------------
if strcmp(options.plottype,'noforce') == 0;
subplot(3,1,3)
plot(tplot(1:mi),f.totalforce(1:mi)/1000,'k','LineWidth',1); hold on
xlabel('Time [s]','Interpreter','Latex','Fontsize',18);
xlim([tplot(1) tplot(mi)]);
%ylim([-1.1*max(abs(f.totalforce/1000)) 1.1*max(abs(f.totalforce/1000))])
ax = gca;
%ax.YAxisLocation = 'origin';
grid on
if options.numaxis == 0; 
    set(gca,'YTick',[]);
    ylabel('Force amplitude','Interpreter','Latex','Fontsize',18);
elseif options.numaxis == 1;
    if strcmp(options.plottype,'total') == 1;
        ylabel('Force [kN/m$^1$]','Interpreter','Latex','Fontsize',18);
    else
        ylabel('Pressure [kN/m$^2$]','Interpreter','Latex','Fontsize',18);
    end
    set(gca,'Ticklabelinterpreter','Latex','Fontsize',17)
end
subplot(3,1,[1 2]);
end
%-------------------------------------------------------------------------
if strcmp(options.plottype,'noforce') == 0;
    set(gcf, 'units','normalized','outerposition',[0 0 1 1],'color','white');
else
   set(gcf, 'units','normalized','outerposition',[0 0 1 2/3],'color','white');
end 

if a.saveplots == 1;
    if isfield(options,'specificfolder') == 1;
        specificfolder = options.specificfolder;
    else
        specificfolder = 'dyn_t_resp';
    end
    fullfoldername = fullfile(a.plotfolder,specificfolder);
    if ~exist(fullfoldername, 'dir'); mkdir(fullfoldername); end
    figurename = options.dataname;
    fullfigurename = fullfile(fullfoldername, figurename);
    export_fig(fullfigurename,'-png','-eps');
end

%function end
end